package com.hippoagent.adapters;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.callback.OptionSelectedCallback;
import com.hippoagent.model.get_all_bots.Bot;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by amit on 04/05/18.
 */

public class OptionAdapter extends RecyclerView.Adapter<OptionAdapter.MyViewHolder> {
    private Context context;
    private ArrayList<Bot> arrayList;
    private OptionSelectedCallback qrCallback;
    private int mLastPos = -1;

    public OptionAdapter(Context context, OptionSelectedCallback qrCallback) {
        this.context = context;
        this.qrCallback = qrCallback;
    }

    @Override
    public MyViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        context = parent.getContext();
        View view = LayoutInflater.from(context).inflate(R.layout.hippo_item_option, parent, false);
        return new MyViewHolder(view);
    }

    @Override
    public void onBindViewHolder(final MyViewHolder holder, @SuppressLint("RecyclerView") final int position) {
        holder.tvOption.setText(arrayList.get(position).getBotName());
        if (holder.getAdapterPosition() == mLastPos) {
            holder.tvOption.setSelected(true);
        } else {
            holder.tvOption.setSelected(false);
        }
        holder.tvOption.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                holder.tvOption.setSelected(true);
                mLastPos = holder.getAdapterPosition();
                qrCallback.optionSelected(arrayList.get(position));
                notifyDataSetChanged();
            }
        });


    }

    public void setData(List<Bot> mOptions) {
        this.arrayList = (ArrayList<Bot>) mOptions;
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        if (arrayList == null) return 0;
        else return arrayList.size();

    }

    public class MyViewHolder extends RecyclerView.ViewHolder {
        private TextView tvOption;
        private LinearLayout mainLayout;

        public MyViewHolder(View itemView) {
            super(itemView);
            mainLayout = itemView.findViewById(R.id.main_layout);
            tvOption = (TextView) itemView.findViewById(R.id.tvOption);

            /*mainLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                }
            });*/
        }
    }
}
