package com.hippoagent.adapters;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.model.MultiSelectButtons;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-12-17.
 *
 * @author gurmail
 */
public class MultiSelectionAdapter extends RecyclerView.Adapter<MultiSelectionAdapter.ViewHolder> {

    private Context context;
    private ArrayList<MultiSelectButtons> selectButtons;
    private boolean isMultiSelected;

    public MultiSelectionAdapter(ArrayList<MultiSelectButtons> selectButtons,
                                 boolean isMultiSelected) {
        this.selectButtons = selectButtons;
        this.isMultiSelected = isMultiSelected;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        context = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.hippo_item_multi_selection, viewGroup, false), isMultiSelected);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        MultiSelectButtons buttons = selectButtons.get(i);
        viewHolder.textView.setText(buttons.getTitle());

        if(isMultiSelected) {
            viewHolder.radioButton.setVisibility(View.GONE);
            viewHolder.checkBox.setVisibility(View.VISIBLE);
        } else {
            viewHolder.checkBox.setVisibility(View.GONE);
            viewHolder.radioButton.setVisibility(View.VISIBLE);
        }

        if(buttons.getStatus() == 1) {
            viewHolder.checkBox.setChecked(true);
            viewHolder.radioButton.setChecked(true);
            //viewHolder.mainLayout.setBackground(context.getDrawable(R.drawable.hippo_mullti_selector_bg));
        } else {
            viewHolder.mainLayout.setBackground(context.getDrawable(R.drawable.hippo_multi_normal_bg));
            viewHolder.checkBox.setChecked(false);
            viewHolder.radioButton.setChecked(false);
        }

        viewHolder.checkBox.setEnabled(false);
        viewHolder.radioButton.setEnabled(false);
    }

    @Override
    public int getItemCount() {
        return selectButtons.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView textView;
        private CheckBox checkBox;
        private RadioButton radioButton;
        private LinearLayout mainLayout;

        public ViewHolder(@NonNull View itemView, final boolean isMultiSelect) {
            super(itemView);

            textView = itemView.findViewById(R.id.item_textview);
            checkBox = itemView.findViewById(R.id.cb_item_view);
            radioButton = itemView.findViewById(R.id.rb_item_view);
            mainLayout = itemView.findViewById(R.id.main_layout);


        }
    }
}

