package com.hippoagent.adapters;

import android.app.Activity;
import android.graphics.Color;

import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.utils.LoadImageFile;

import java.util.ArrayList;
import java.util.List;

import de.hdodenhof.circleimageview.CircleImageView;

/**
 * Created by harsh on 15/09/17.
 */

public class FuguTagAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Activity activity;
    private ArrayList<GetAgentsResponse.Agents> agentDetails = new ArrayList<>();
    private FuguChatActivity fuguChatActivity;
    private String removableText;
    private Callback callback;

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.tag_recycler_layout, parent, false);
        return new FuguTagging(v);
    }

    public FuguTagAdapter(FuguChatActivity fuguChatActivity, ArrayList<GetAgentsResponse.Agents> agentDetails, String removableText, Callback callback) {
        this.agentDetails = agentDetails;
        this.fuguChatActivity = fuguChatActivity;
        this.removableText = removableText;
        this.callback = callback;
        this.activity = fuguChatActivity;
    }

    @Override
    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        final FuguTagging holder1 = (FuguTagging) holder;
        holder1.tvTaggedPerson.setText(agentDetails.get(position).getFullName());

        try {
            LoadImageFile.getInstance().loadImage(fuguChatActivity, agentDetails.get(position).getUserImage(), holder1.ivTagPerson);
//            Glide.with(activity).load(agentDetails.get(position).getUserImage())
//                    .placeholder(ContextCompat.getDrawable(activity, R.drawable.agent_ic_profile_placeholder))
//                    .dontAnimate()
//                    .error(ContextCompat.getDrawable(activity, R.drawable.agent_ic_profile_placeholder))
//                    .into(holder1.ivTagPerson);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(agentDetails.get(position).getOnlineStatus().equals(FuguAppConstant.AVAILABLE)) {
            holder1.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_available_without_border));
        }
        else if(agentDetails.get(position).getOnlineStatus().equals(FuguAppConstant.AWAY)){
            holder1.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_away_without_border));
        }
        else {
            holder1.viewStatus.setBackground(activity.getResources().getDrawable(R.drawable.ic_offline_without_border));
        }
        holder1.itemView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                holder1.rlBackground.setBackgroundColor(Color.WHITE);
                holder1.tvTaggedPerson.setTextColor(Color.parseColor("#627de3"));
                holder1.viewSelectedBar.setVisibility(View.VISIBLE);
                return false;
            }
        });

        holder1.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                callback.onClick(agentDetails.get(position));
                holder1.rlBackground.setBackgroundColor(Color.WHITE);
                holder1.tvTaggedPerson.setTextColor(Color.parseColor("#627de3"));
                holder1.viewSelectedBar.setVisibility(View.VISIBLE);
            }
        });

//        Animation animation = AnimationUtils.loadAnimation(fuguChatActivity, R.anim.slide_from_bottom);
//        holder.itemView.setAnimation(animation);
//        if (position > -1) {
//            Animation animation1 = AnimationUtils.loadAnimation(fuguChatActivity, R.anim.slide_from_bottom);
//            holder.itemView.startAnimation(animation1);
//        }

    }

    @Override
    public int getItemCount() {
        return agentDetails.size();
    }

    public void setData(List<GetAgentsResponse.Agents> agentDetails) {
        this.agentDetails = (ArrayList<GetAgentsResponse.Agents>) agentDetails;
        notifyDataSetChanged();
    }

    class FuguTagging extends RecyclerView.ViewHolder {
        private TextView tvTaggedPerson;
        private CircleImageView ivTagPerson;
        private RelativeLayout rlBackground;
        private View viewSelectedBar,viewStatus;

        public FuguTagging(View itemView) {
            super(itemView);
            tvTaggedPerson = (TextView) itemView.findViewById(R.id.tvTaggedPerson);
            ivTagPerson = (CircleImageView) itemView.findViewById(R.id.ivTagPerson);
            rlBackground = (RelativeLayout) itemView.findViewById(R.id.rlBackground);
            viewSelectedBar = (View) itemView.findViewById(R.id.viewSelectedBar);
            viewStatus = (View) itemView.findViewById(R.id.viewStatus);
        }
    }

    public interface Callback {
        void onClick(GetAgentsResponse.Agents agent);
    }
}

