package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Intent;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;

import java.util.ArrayList;

/**
 * Created by Bhavya Rattan on 08/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguChannelsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList<>();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1l;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> fuguConversationList, String userName, Long userId, String businessName) {
        inflater = LayoutInflater.from(activity.getApplicationContext());
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = inflater.inflate(R.layout.fugu_item_channels, parent, false);
        ChannelViewHolder holder = new ChannelViewHolder(view);
        return holder;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final ChannelViewHolder channelViewHolder = (ChannelViewHolder) holder;
        final FuguConversation currentChannelItem = fuguConversationList.get(position);

        channelViewHolder.tvChannelName.setText(currentChannelItem.getLabel());
        channelViewHolder.tvMessage.setText(currentChannelItem.getMessage());

        if (currentChannelItem.getChannelId().compareTo(-1l) == 0)
            channelViewHolder.tvDate.setVisibility(View.GONE);
        else {
        channelViewHolder.tvDate.setText(DateUtils.getInstance().getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
        channelViewHolder.tvDate.setVisibility(View.VISIBLE);
              }
        channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent chatIntent = new Intent(activity, FuguChatActivity.class);
                chatIntent.putExtra("label", currentChannelItem.getLabel());
                chatIntent.putExtra("channelId", currentChannelItem.getChannelId());
                chatIntent.putExtra("labelId", currentChannelItem.getLabelId());
                chatIntent.putExtra("defaultMessage", currentChannelItem.getMessage());
                chatIntent.putExtra("businessName", businessName);
                chatIntent.putExtra("userId", userId);
                chatIntent.putExtra("userName", userName);
                chatIntent.putExtra("status", currentChannelItem.getStatus());
                activity.startActivityForResult(chatIntent, 200);
            }
        });


    }

    @Override
    public int getItemCount() {
        Log.e("fuguConversationList size", "==" + fuguConversationList.size());
        return fuguConversationList.size();
    }

    class ChannelViewHolder extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private TextView tvChannelName, tvMessage, tvDate;
        private ImageView ivChannelIcon;

        public ChannelViewHolder(View itemView) {
            super(itemView);
            rlRoot = (RelativeLayout) itemView.findViewById(R.id.rlRoot);
            tvChannelName = (TextView) itemView.findViewById(R.id.tvChannelName);
            tvMessage = (TextView) itemView.findViewById(R.id.tvMessage);
            tvDate = (TextView) itemView.findViewById(R.id.tvDate);
            ivChannelIcon = (ImageView) itemView.findViewById(R.id.ivChannelIcon);
        }
    }
}

