package com.hippoagent.adapters

import android.content.Context
import android.graphics.Typeface
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.callback.OnAnayticsListener
import com.hippoagent.model.DateModel
import kotlinx.android.synthetic.main.list_item_date.view.*

/**
 * Created by gurmail on 2019-08-20.
 * @author gurmail
 */
class DateAdapter(var data : ArrayList<DateModel>?, var listener: OnAnayticsListener?) : androidx.recyclerview.widget.RecyclerView.Adapter<DateAdapter.ViewHolder>() {

    var context: Context? = null
    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): ViewHolder {
        context = p0.context
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.list_item_date, p0, false))
    }

    override fun getItemCount(): Int {
        return data!!.size
    }

    override fun onBindViewHolder(holder: ViewHolder, pos: Int) {
        holder.bind(pos, data?.get(pos)!!)
    }

    inner class ViewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, dataModel: DateModel) = with(itemView) {
            cbDate.text = dataModel.text
            cbDate.isChecked = dataModel.isSelected
            /*val face = Typeface.createFromAsset(context.assets, "fonts/ProximaNova-Reg.ttf")
            if(dataModel.isSelected) {
                cbDate.setTypeface(face, Typeface.BOLD)
            } else {
                cbDate.setTypeface(face, Typeface.NORMAL)
            }*/

            cbDate.setOnCheckedChangeListener { compoundButton, _ ->
                if (compoundButton.isPressed) {
                    for(i in 0 until data!!.size) {
                        if(adapterPosition == i) {
                            data!![i].isSelected = !data!![i].isSelected
                        } else {
                            data!![i].isSelected = false
                        }
                    }
                    listener?.onClick(adapterPosition, dataModel.text, dataModel.text)
                    notifyDataSetChanged()
                }
            }
        }
    }

}