package com.hippoagent.adapters;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;

import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.ActionButtonModel;
import com.hippoagent.utils.FuguColorConfig;

import java.util.ArrayList;

/**
 * Created by cl-macmini-01 on 12/15/17.
 */

public class CustomActionButtonsAdapter extends RecyclerView.Adapter<CustomActionButtonsAdapter.ActionButtonViewHolder> {

    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private ArrayList<ActionButtonModel> mActionButtons;
    private FuguColorConfig fuguColorConfig;

    /**
     * Constructor
     *
     * @param context       calling context
     * @param actionButtons the action buttons
     */
    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> actionButtons) {
        mContext = context;
        mLayoutInflater = LayoutInflater.from(context);
        mActionButtons = actionButtons;
        this.fuguColorConfig = CommonData.getColorConfig();
    }

    @Override
    public ActionButtonViewHolder onCreateViewHolder(final ViewGroup parent, final int viewType) {
        View main = mLayoutInflater.inflate(R.layout.hippo_list_item_action_button, parent, false);
        return new ActionButtonViewHolder(main);
    }

    @Override
    public void onBindViewHolder(final ActionButtonViewHolder holder, final int position) {
        int pos = holder.getAdapterPosition();
        ActionButtonModel actionButton = mActionButtons.get(pos);
        holder.btnAction.setText(actionButton.getButtonText());

        holder.btnAction.setTextColor(fuguColorConfig.getFuguPrimaryTextMsgFrom());
    }

    @Override
    public int getItemCount() {
        return mActionButtons.size();
    }

    /**
     * Action Button ViewHolder
     */
    class ActionButtonViewHolder extends RecyclerView.ViewHolder {

        Button btnAction;

        ActionButtonViewHolder(final View itemView) {
            super(itemView);
            btnAction = itemView.findViewById(R.id.btnAction);
            btnAction.setClickable(false);
            btnAction.setEnabled(false);
//            btnAction.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(final View v) {
//                    ((FuguChatActivity) mContext).onCustomActionClicked(mActionButtons.get(getAdapterPosition())
//                            .getButtonAction());
//                }
//            });
        }
    }
}
