package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.databinding.LayoutMembersItemDetailsBinding;
import com.hippoagent.model.ChatMembersModel;

import java.util.ArrayList;

/**
 * Created by gurmail on 11/03/19.
 *
 * @author gurmail
 */
public class ChatMembersAdapter extends RecyclerView.Adapter<ChatMembersAdapter.ViewHolder> {
    private static final String TAG = ChatMembersAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<ChatMembersModel.Datum> data = new ArrayList<>();

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        return new ViewHolder(LayoutInflater.from(context)
                .inflate(R.layout.layout_members_item_details, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        viewHolder.detailsBinding.tvTitle.setText(data.get(position).getFullName() + " (" + data.get(position).getAppName()+")");
        viewHolder.detailsBinding.tvStatus.setVisibility(View.VISIBLE);
        if(!TextUtils.isEmpty(data.get(position).getPhoneNumber()))
            viewHolder.detailsBinding.tvStatus.setText(data.get(position).getPhoneNumber());
        else
            viewHolder.detailsBinding.tvStatus.setVisibility(View.GONE);
    }

    @Override
    public int getItemCount() {
        return data == null ? 0 : data.size();
    }

    public void setMembersData(ArrayList<ChatMembersModel.Datum> data) {
        this.data = data;
        notifyDataSetChanged();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LayoutMembersItemDetailsBinding detailsBinding;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            detailsBinding = DataBindingUtil.bind(itemView);

        }
    }
}
