package com.hippoagent.adapters

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.model.user_details.CJourney
import kotlinx.android.synthetic.main.date_header.view.*
import kotlinx.android.synthetic.main.item_jounery_layout.view.*

/**
 * Created by gurmail on 2019-09-09.
 * @author gurmail
 */
class ChannelJourneyAdapter constructor(var tempArray: ArrayList<CJourney>) : androidx.recyclerview.widget.RecyclerView.Adapter<androidx.recyclerview.widget.RecyclerView.ViewHolder>() {
    var context: Context? = null
    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): androidx.recyclerview.widget.RecyclerView.ViewHolder {
        context = p0.context
        return if(p1 == 0) {
            HeaderHolder(LayoutInflater.from(context).inflate(R.layout.date_header, p0,  false))
        } else {
            ItemHolder(LayoutInflater.from(context).inflate(R.layout.item_jounery_layout, p0, false))
        }
    }

    override fun getItemCount(): Int {
        return tempArray.size
    }

    override fun getItemViewType(position: Int): Int {
        if(tempArray[position].isHeader)
            return 0
        else
            return 1
    }

    override fun onBindViewHolder(p0: androidx.recyclerview.widget.RecyclerView.ViewHolder, p1: Int) {
        if (p0 is ItemHolder) {
            val holder: ItemHolder = p0 as ItemHolder
            holder.bind(p1, tempArray[p1])
        } else {
            val header: HeaderHolder = p0 as HeaderHolder
            header.bind(p1, tempArray[p1])
        }
    }

    inner class HeaderHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, cJourney: CJourney) = with(itemView) {
            tvDate.text = cJourney.date
        }
    }

    inner class ItemHolder(itemView: View): androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, cJourney: CJourney) = with(itemView) {
            timeView.text = cJourney.date
            if(!TextUtils.isEmpty(cJourney.description)) {
                tvDetailView.text = cJourney.description
                tvDetailView.visibility = View.VISIBLE
            } else {
                tvDetailView.visibility = View.GONE
            }
            tvLinkView.text = cJourney.link
            tvLinkView.setLinkTextColor(context.resources.getColor(R.color.color_tag))

            if(position +1 == tempArray.size) { // || tempArray[position+1].isHeader
                lineView.visibility = View.GONE
            } else {
                lineView.visibility = View.VISIBLE
            }
        }
    }
}