package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.databinding.LayoutBroadcastItemDetailBinding;
import com.hippoagent.model.BroadcastUser;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.ProgressBarDisplayRunnable;

import java.util.ArrayList;

/**
 * Created by gurmail on 13/02/19.
 *
 * @author gurmail
 */
public class BroadcastDetailAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = BroadcastDetailAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadcastUser> arrayList = new ArrayList<>();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;

    public BroadcastDetailAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadcastUser> arrayList) {
        this.arrayList = arrayList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        if(viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_loaddata, parent, false));
        } else {
            return new ViewHolder(LayoutInflater.from(context)
                    .inflate(R.layout.layout_broadcast_item_detail, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if(holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder) holder;
            BroadcastUser objectModel = arrayList.get(position);
            viewHolder.detailBinding.tvTitle.setText(objectModel.getFullName());

            if(!TextUtils.isEmpty(objectModel.getLastActivity())) {
                String localDate = DateUtils.getInstance().convertToLocal(objectModel.getLastActivity(), STANDARD_DATE_FORMAT_TZ, OUTPUT_FORMAT);
                viewHolder.detailBinding.tvStatus.setText("Read at "+localDate);
            } else {
                viewHolder.detailBinding.tvStatus.setText("Delivered");
            }

            if(!TextUtils.isEmpty(objectModel.getRepliedOn())) {
                viewHolder.detailBinding.chatIcon.setVisibility(View.VISIBLE);
            } else {
                viewHolder.detailBinding.chatIcon.setVisibility(View.GONE);
            }

        }
    }


    @Override
    public int getItemCount() {
        return arrayList == null ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if(arrayList.get(position).getUserId().equals(-1)) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private LayoutBroadcastItemDetailBinding detailBinding;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            detailBinding = DataBindingUtil.bind(itemView);
            detailBinding.llLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(onItemClickListener != null)
                        onItemClickListener.onClickItem(getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
//            loadmoreBinding = DataBindingUtil.bind(itemView);
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if(arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getUserId() != null
                && arrayList.get(arrayList.size() - 1).getUserId().intValue() == -1;
        if(show) {
            if (!isProgressBarExist) {
                arrayList.add(ProgressBarModel.getInstance());
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        }else{
            if(arrayList.remove(ProgressBarModel.getInstance())){
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }

        }

    }
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;
    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position){
        if(progressBarDisplayRunnable == null){
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static BroadcastUser progressBarModel;
        private ProgressBarModel() {
        }
        public static BroadcastUser getInstance(){
            if(progressBarModel ==null)
                progressBarModel = new BroadcastUser(-1);
            return progressBarModel;
        }
    }

}
