package com.hippoagent.adapters

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import androidx.appcompat.widget.AppCompatTextView
import androidx.recyclerview.widget.RecyclerView
import android.text.Html
import android.text.Spannable
import android.text.SpannableString
import android.text.TextPaint
import android.text.style.RelativeSizeSpan
import android.text.style.URLSpan
import android.text.style.UnderlineSpan
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.R
import com.hippoagent.callback.OnAnayticsListener
import com.hippoagent.model.AnalyticsDatum
import com.hippoagent.utils.BetterLinkMovementMethod
import kotlinx.android.synthetic.main.analytics_item.view.*

/**
 * Created by gurmail on 2019-07-30.
 * @author gurmail
 */
class AnalyticsAdapter(var analyticsDatum: ArrayList<AnalyticsDatum>?, var listener: OnAnayticsListener?) : androidx.recyclerview.widget.RecyclerView.Adapter<AnalyticsAdapter.ViewHolder>() {

    var context: Context? = null
    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): ViewHolder {
        context = p0.context
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.analytics_item, p0, false))
    }

    override fun getItemCount(): Int {
        return analyticsDatum!!.size
    }

    override fun onBindViewHolder(p0: ViewHolder, p1: Int) {
        p0.bind(p1, analyticsDatum!![p1])
    }

    inner class ViewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, data: AnalyticsDatum) = with(itemView) {
            tvTextView.text = data.title

            itemView.setOnClickListener {
                listener?.onClick(adapterPosition, analyticsDatum?.get(adapterPosition)?.title!!, analyticsDatum?.get(adapterPosition)?.link!!)
            }
        }
    }

    private fun manipulateAndSetText(tvMessage: AppCompatTextView, message: String?, messageState: Int = 1) {
        val textArray = message.toString().split(" ")
        var text = ""
        for (i in textArray) {
            if (i.toLowerCase().contains("http") ||
                    i.toLowerCase().contains("www")) {
                text = "$text <a href=\"" + i + "\">$i</a> "
            } else {
                text = "$text $i"
            }
        }

        text = text.replace("Http", "http")
        text = text.replace("Https", "https")
        text = text.replace("WWW", "www")

        text = text.trim().replace("\n", "<br>")
        val s = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            Html.fromHtml(text.toString(), Html.FROM_HTML_OPTION_USE_CSS_COLORS) as Spannable
        } else {
            Html.fromHtml(text.toString()) as Spannable
        }
        for (u in s.getSpans(0, s.length, URLSpan::class.java)) {
            s.setSpan(object : UnderlineSpan() {
                override fun updateDrawState(tp: TextPaint) {
                    tp.isUnderlineText = false
                }
            }, s.getSpanStart(u), s.getSpanEnd(u), 0)
        }
        tvMessage.setLinkTextColor(context!!.resources.getColor(R.color.picker_primary_color))
        tvMessage.setText(s)

        tvMessage.movementMethod = BetterLinkMovementMethod.getInstance()
        //val replacements = ""//MyEmojiParser.getUnicodeCandidates(s.toString())
        //val messagee = MyEmojiParser.removeAllEmojis()

//        if (replacements.size in 1..2 && messagee.isEmpty()) {
//            val ss1 = SpannableString(s)
//            ss1.setSpan(RelativeSizeSpan(2f), 0, s.length, 0)
//            tvMessage.text = ss1
//        } else {
//            if (messageState == 4) {
//                val messagee = MyEmojiParser.removeAllEmojis(s.substring(0, s.length - 9))
//                if (replacements.size in 1..2 && messagee.isEmpty()) {
//                    val ss1 = SpannableString(s)
//                    ss1.setSpan(RelativeSizeSpan(1f), s.length - 9, s.length, 0)
//                    ss1.setSpan(RelativeSizeSpan(2f), 0, s.length - 9, 0)
//                    tvMessage.text = ss1
//                } else {
//                    val ss1 = SpannableString(s)
//                    ss1.setSpan(RelativeSizeSpan(1f), 0, s.length, 0)
//                    tvMessage.text = ss1
//                }
//            } else {
//                val ss1 = SpannableString(s)
//                ss1.setSpan(RelativeSizeSpan(1f), 0, s.length, 0)
//                tvMessage.text = ss1
//            }
//        }

        val ss1 = SpannableString(s)
        ss1.setSpan(RelativeSizeSpan(1f), 0, s.length, 0)
        tvMessage.text = ss1

        BetterLinkMovementMethod.linkifyHtmlNone(tvMessage).setOnLinkLongClickListener(
                urlClickListenerLong).setOnLinkClickListener(urlClickListener)
    }

    private val urlClickListenerLong = BetterLinkMovementMethod.OnLinkLongClickListener() { _, url ->

        if (url.toLowerCase().contains("http") || url.toLowerCase().contains("www")) {
            //onLinkLongClick = true
            //Log.i("LinkOnLongClick", "true")
//            if (isChatActivity()) {
//                chatActivity?.copyUrl(url)
//            } else {
//                fuguInnerChatActivity?.copyUrl(url)
//            }
        }
        true
    }

    private val urlClickListener = BetterLinkMovementMethod.OnLinkClickListener { _, url ->
        if (!false) {
            if (url.toLowerCase().contains("http") || url.toLowerCase().contains("www")) {
                var clickableLink = url
                clickableLink = clickableLink.replace("<b>", "")
                clickableLink = clickableLink.replace("<i>", "")
                clickableLink = clickableLink.replace("</i>", "")
                clickableLink = clickableLink.replace("</b>", "")
                clickableLink = clickableLink.replace("</br>", "")
                clickableLink = clickableLink.replace("<br>", "")
                try {

                    if (clickableLink.startsWith("www")) {
                        clickableLink = "http://" + clickableLink
                    }

                    val i = Intent(Intent.ACTION_VIEW)
                    i.data = Uri.parse(clickableLink)
                    context?.startActivity(i)
                } catch (e: java.lang.Exception) {
//                    try {
//                        if (isChatActivity()) {
//                            showErrorMessage(chatActivity!!, "$clickableLink is not a valid link!")
//                        } else {
//                            showErrorMessage(chatActivity!!, "$clickableLink is not a valid link!")
//                        }
//                    } catch (e: java.lang.Exception) {
//                        e.printStackTrace()
//                    }

                }
            } else {
//                try {
//                    openProfile(url, mContext)
//                } catch (e: Exception) {
//
//                }

            }
        }
//        onLongClick = false
        true
    }
}