package com.hippoagent.adapters;

import android.app.Activity;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.DateUtils;

import java.util.ArrayList;

/**
 * Created by ankit on 30/05/17.
 */

public class AllChatAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>{
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    private ArrayList<Object> allChatList;
    private Activity activity;
    private Callback callback;
    private RecyclerView recyclerView;

    public AllChatAdapter(ArrayList<Object> allChatList, Activity activity, Callback callback, RecyclerView recyclerView) {
        this.allChatList = allChatList;
        this.activity = activity;
        this.callback = callback;
        this.recyclerView = recyclerView;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if(viewType == TYPE_HEADER){
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_header, parent, false);
            return new ViewHolderHeader(v);
        } else if(viewType == ITEM_PROGRESS_BAR){
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        } else{
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_chat, parent, false);
            return new ViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder) viewholder;
//            position--;
            Conversation conversation = (Conversation) allChatList.get(position);
            holder.rlChat.setTag(position);
            holder.tvMessage.setText(conversation.getMessage());
            holder.tvName.setText(conversation.getLabel());
            if(!TextUtils.isEmpty(conversation.getBotChannelName())) {
                holder.tvChannelName.setVisibility(View.VISIBLE);
                holder.tvChannelName.setText(conversation.getBotChannelName());
            } else{
                holder.tvChannelName.setVisibility(View.GONE);
            }

            if(conversation.getUserId() == MyApplication.getInstance().getUserData().getUserId()){
                holder.tvMessenger.setText(activity.getString(R.string.you_colon));
            } else{
                holder.tvMessenger.setText(activity.getString(R.string.user_colon));
            }

            if(!conversation.getUnreadCount().equals(0)){
                holder.tvUnread.setVisibility(View.VISIBLE);
                holder.tvUnread.setText(String.valueOf(conversation.getUnreadCount()));
            } else{
                holder.tvUnread.setVisibility(View.GONE);
            }

//            holder.tvTime.setText(DateUtils.getTimeToDisplay(conversation.getDate()));
            holder.tvTime.setText(DateUtils.getInstance().getRelativeDate(DateUtils.getInstance().convertToLocal(conversation.getLastUpdatedAt()), true));

            holder.rlChat.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = (int) v.getTag();
                    Conversation conversation = (Conversation) allChatList.get(pos);
                    callback.onClick(pos, conversation);
                }
            });

        } else if(viewholder instanceof ViewHolderHeader){
            ViewHolderHeader holder = (ViewHolderHeader) viewholder;
            holder.tvHeader.setText("2 "+activity.getResources().getString(R.string.open_conversations));
        }

    }

    @Override
    public int getItemCount() {
        if (allChatList == null || allChatList.size() == 0) {
            return 0;
        } else {
            return allChatList.size();
        }
    }

    @Override
    public int getItemViewType(int position) {
//        if(position == 0 && allChatList != null && allChatList.size() > 0){
//            return TYPE_HEADER;
//            return TYPE_ITEM;
//        } else{
//            return TYPE_ITEM;
//        }
        if(allChatList.get(position) instanceof ProgressBarItem){
            return ITEM_PROGRESS_BAR;
        } else{
            return TYPE_ITEM;
        }
    }


    public class ViewHolder extends RecyclerView.ViewHolder{
        public RelativeLayout rlChat;
        public TextView tvMessage, tvName, tvChannelName, tvMessenger, tvTime, tvUnread;
        public ViewHolder(final View itemView) {
            super(itemView);
            rlChat = (RelativeLayout) itemView.findViewById(R.id.rlChat);
            tvMessage = (TextView) itemView.findViewById(R.id.tvMessage);
            tvName = (TextView) itemView.findViewById(R.id.tvName);
            tvChannelName = (TextView) itemView.findViewById(R.id.tvChannelName);
            tvMessenger = (TextView) itemView.findViewById(R.id.tvMessenger);
            tvTime = (TextView) itemView.findViewById(R.id.tvTime);
            tvUnread = (TextView) itemView.findViewById(R.id.tvUnread);
        }
    }

    public class ViewHolderHeader extends RecyclerView.ViewHolder{
        public TextView tvHeader;
        public ViewHolderHeader(View itemView) {
            super(itemView);
            tvHeader = (TextView) itemView.findViewById(R.id.tvHeader);
        }
    }

    private static class ProgressBarViewHolder extends RecyclerView.ViewHolder {

//        public RelativeLayout relative;

        public ProgressBarViewHolder(View itemView) {
            super(itemView);
//            relative = (RelativeLayout) itemView.findViewById(R.id.relative);
        }
    }

    public static class ProgressBarItem{

    }

    public interface Callback{
        void onClick(int position, Conversation conversation);
    }
}
