package com.hippoagent.adapters

import android.content.Context
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.callback.AgentTickListener
import com.hippoagent.model.payment.ActiveAgent
import com.hippoagent.utils.LoadImageFile
import kotlinx.android.synthetic.main.agent_listing.view.*
import kotlinx.android.synthetic.main.list_item_header.view.*

/**
 * Created by gurmail on 23/04/19.
 * @author gurmail
 */
class AgentPaymentAdapter(var agents: ArrayList<ActiveAgent>?, var listener: AgentTickListener) : androidx.recyclerview.widget.RecyclerView.Adapter<androidx.recyclerview.widget.RecyclerView.ViewHolder>() {

    var context: Context? = null
    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): androidx.recyclerview.widget.RecyclerView.ViewHolder {
        context = p0.context
        if(p1 == 1) {
            return ViewHolder(LayoutInflater.from(context).inflate(R.layout.agent_listing, p0, false))
        } else {
            return HeaderHolder(LayoutInflater.from(context).inflate(R.layout.agent_listing_header, p0, false))
        }
    }

    override fun getItemCount(): Int {
        return agents!!.size
    }

    override fun getItemViewType(position: Int): Int {
        when(agents!![position].status) {
            1    -> return 1
            -101 -> return 2
            -100 -> return 2
            else -> return 1
        }
    }

    override fun onBindViewHolder(p0: androidx.recyclerview.widget.RecyclerView.ViewHolder, position: Int) {
        if (p0 is ViewHolder) {
            val holder: ViewHolder = p0 as ViewHolder
            holder.bind(position, agents!![position])
        } else {
            val header: HeaderHolder = p0 as HeaderHolder
            header.bind(position, agents!![position])
        }
    }

    inner class HeaderHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, agent: ActiveAgent) = with(itemView) {
            if(agent != null) {
                tvHeader.text = agent.fullName
            }
        }
    }

    inner class ViewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, agent: ActiveAgent) = with(itemView) {
            if(agent != null) {
                var name = if (TextUtils.isEmpty(agent.fullName)) agent.email else agent.fullName
                agentName.text = name
                if (agent.status == 1) {
                    if(agent.isChecked)
                        status.text = "Active"
                    else
                        status.text = "Inactive"
                } else {
                    if(agent.isChecked)
                        status.text = "Invited"
                    else
                        status.text = "Revoked"
                }

                status.isEnabled = agent.isChecked
                if(!agent.isChecked) {
                    agentName.setTextColor(ContextCompat.getColor(context, R.color.disable_color));
                } else {
                    agentName.setTextColor(ContextCompat.getColor(context, R.color.text_color));
                }
                radioButton.setChecked(agent.isChecked, true)

                radioButton.isClickable = false

                LoadImageFile.getInstance().loadImage(context, agent.userImage,
                        R.drawable.agent_ic_profile_placeholder, agentImage , 1)
                if(agent.userId == MyApplication.getInstance().userData.userId) {
                    agentName.text = "$name (You)"
                    agentCard.isEnabled = false
                    agentCard.isClickable = false
                    radioButton.visibility = View.GONE
                } else {
                    agentCard.isEnabled = true
                    agentCard.isClickable = true
                    radioButton.visibility = View.VISIBLE
                }
            }

            agentCard.setOnClickListener {
                agent.isChecked = !agent.isChecked
                status.isEnabled = agent.isChecked
                notifyItemChanged(adapterPosition)
                listener.agentTickChange(agents!!)
            }

        }
    }
}