//package com.hippoagent.activities;
//
//import android.Manifest;
//import android.content.Intent;
//import android.content.pm.PackageManager;
//import android.os.Bundle;
//import androidx.annotation.NonNull;
//import androidx.annotation.Nullable;
//import com.google.android.material.textfield.TextInputLayout;
//import androidx.core.app.ActivityCompat;
//import androidx.core.content.ContextCompat;
//
//import android.text.Editable;
//import android.text.SpannableString;
//import android.text.TextPaint;
//import android.text.TextUtils;
//import android.text.TextWatcher;
//import android.text.method.LinkMovementMethod;
//import android.text.style.ClickableSpan;
//import android.view.KeyEvent;
//import android.view.View;
//import android.view.WindowManager;
//import android.widget.Button;
//import android.widget.CheckBox;
//import android.widget.CompoundButton;
//import android.widget.EditText;
//import android.widget.ImageView;
//import android.widget.RelativeLayout;
//import android.widget.TextView;
//import android.widget.Toast;
//
//import com.hippoagent.BuildConfig;
//import com.hippoagent.Config;
//import com.hippoagent.MyApplication;
//import com.hippoagent.R;
//import com.hippoagent.callback.OnImageUploadListener;
//import com.hippoagent.database.CommonData;
//import com.hippoagent.datastructure.ApiResponseFlags;
//import com.hippoagent.helper.ImageUpload;
//import com.hippoagent.model.Continent.Continent;
//import com.hippoagent.model.LoginResponse.LoginResponse;
//import com.hippoagent.model.UserInfoModel;
//import com.hippoagent.model.onBoard.UserConfig;
//import com.hippoagent.model.user_details.DeviceDetails;
//import com.hippoagent.retrofit.APIError;
//import com.hippoagent.retrofit.ApiInterface;
//import com.hippoagent.retrofit.CommonParams;
//import com.hippoagent.retrofit.ResponseResolver;
//import com.hippoagent.retrofit.RestClient;
//import com.hippoagent.utils.Constants;
//import com.hippoagent.utils.ImageChooser;
//import com.hippoagent.utils.LoadImageFile;
//import com.hippoagent.utils.Pref1;
//import com.hippoagent.utils.filelogger.Logger;
//import com.hippoagent.utils.GAEvents;
//import com.hippoagent.utils.Log;
//import com.hippoagent.utils.SPLabels;
//import com.hippoagent.utils.UniqueIMEIID;
//import com.hippoagent.utils.Utils;
//import com.google.gson.Gson;
//import com.google.gson.GsonBuilder;
//import com.google.gson.JsonObject;
//import com.hbb20.CountryCodePicker;
//import com.kbeanie.multipicker.api.Picker;
//import com.kbeanie.multipicker.api.entity.ChosenImage;
//
//import org.jetbrains.annotations.NotNull;
//
//import java.util.List;
//
//import de.hdodenhof.circleimageview.CircleImageView;
//import io.paperdb.Paper;
//import retrofit2.Call;
//import retrofit2.Retrofit;
//import retrofit2.converter.gson.GsonConverterFactory;
//
//import static com.hippoagent.utils.Constants.APP_SOURCE;
//import static com.hippoagent.utils.Constants.APP_VERSION_CODE;
//
//
///**
// * Created by mohitkr.dhiman on 27/02/18.
// */
//
//public class SignupActivity extends FuguBaseActivity implements GAEvents, ImageChooser.OnImageSelectListener {
//
//
//    String continentCode;
//    RelativeLayout rlBack;
//    private EditText etEmail, etPassword, etName, etBusinessName, etContact;
//    private TextInputLayout inputEmail, inputPassword, inputName, inputBusinessName, inputContact;
//    private Button bSignUp;
//    private CheckBox tnc;
//    private TextView tvTnc;
//    private CountryCodePicker countryCodePicker;
//    private UserConfig userConfig;
//    private ImageChooser imageChooser;
//    private ImageView ivLogo;
//    private RelativeLayout rlImage, rlImageView;
//    private String imagePath = "";
//    private CircleImageView ivAgentImage;
//    private TextView registerAs;
//
//    private String conditionLink = "";
//    private String policyLink = "";
//
//    private static boolean isValidEmail(String email) {
//        return !TextUtils.isEmpty(email) && android.util.Patterns.EMAIL_ADDRESS.matcher(email).matches();
//    }
//
//    @Override
//    protected void onCreate(@Nullable Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_signup);
//        inputEmail = (TextInputLayout) findViewById(R.id.inputEmail);
//        etEmail = (EditText) findViewById(R.id.etEmail);
//        inputPassword = (TextInputLayout) findViewById(R.id.inputPassword);
//        etPassword = (EditText) findViewById(R.id.etPassword);
//        inputName = (TextInputLayout) findViewById(R.id.inputName);
//        etName = (EditText) findViewById(R.id.etName);
//        inputBusinessName = (TextInputLayout) findViewById(R.id.inputBusinessName);
//        etBusinessName = (EditText) findViewById(R.id.etBusinessName);
//        inputContact = (TextInputLayout) findViewById(R.id.inputContact);
//        etContact = (EditText) findViewById(R.id.etContact);
//        countryCodePicker = (CountryCodePicker) findViewById(R.id.ccp);
//        bSignUp = (Button) findViewById(R.id.bSignUp);
//        bSignUp.setEnabled(false);
//        rlBack = (RelativeLayout) findViewById(R.id.rlBack);
//        tnc = (CheckBox) findViewById(R.id.tnc);
//        tvTnc = (TextView) findViewById(R.id.tv_tnc);
//
//        rlImageView = findViewById(R.id.rlImageView);
//        rlImage = findViewById(R.id.rlImage);
//        ivLogo = findViewById(R.id.ivLogo);
//        ivAgentImage = findViewById(R.id.ivAgentImage);
//        registerAs = findViewById(R.id.register_as);
//
//        rlImage.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                imageChooser.selectImage();
//            }
//        });
//
//        userConfig = new Gson().fromJson(Pref1.with(this).getString("userConfig", ""), UserConfig.class);
//        try {
//            if(userConfig.getData().getBusinessProperties().getIsConsultantSignupAllowed() == 1) {
//                inputBusinessName.setVisibility(View.GONE);
//                //ivLogo.setVisibility(View.GONE);
//                rlImageView.setVisibility(View.VISIBLE);
//                imageChooser = new ImageChooser(SignupActivity.this);
//                registerAs.setText("Register as "+userConfig.getData().getBusinessProperties().getRegisterAs());
//            }
//            conditionLink = userConfig.getData().getTermsAndCondition();
//            policyLink = userConfig.getData().getPrivacyPolicy();
//        } catch (Exception e) {
//            e.printStackTrace();
//            conditionLink = getIntent().getStringExtra("conditionLink");
//            policyLink = getIntent().getStringExtra("policyLink");
//        }
//
//
//
//
//
//        ActivityCompat.requestPermissions(this,
//                new String[]{Manifest.permission.READ_PHONE_STATE}, 100);
//
//        setTocSpannableText(tvTnc);
//        bSignUp.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                submitForm();
//                //MyApplication.getInstance().trackEvent(SIGNUP_SCREEN, SIGNUP_CLICKED, "signup_button");
//
//            }
//        });
//        rlBack.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                SignupActivity.super.onBackPressed();
//            }
//        });
//
//        countryCodePicker.setOnCountryChangeListener(new CountryCodePicker.OnCountryChangeListener() {
//            @Override
//            public void onCountrySelected() {
//
//                countryCodePicker.setDefaultCountryUsingPhoneCode(Integer.parseInt(countryCodePicker.getSelectedCountryCode()));
//            }
//        });
//
//        etEmail.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
//
//            }
//
//            @Override
//            public void onTextChanged(CharSequence s, int start, int before, int count) {
//
//            }
//
//            @Override
//            public void afterTextChanged(Editable s) {
//                //MyApplication.getInstance().trackEvent(SIGNUP_SCREEN, EMAIL_ID_ENTERED, "email_id_entered");
//            }
//        });
//
//        etPassword.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
//
//            }
//
//            @Override
//            public void onTextChanged(CharSequence s, int start, int before, int count) {
//
//            }
//
//            @Override
//            public void afterTextChanged(Editable s) {
//                //MyApplication.getInstance().trackEvent(SIGNUP_SCREEN, PASSWORD_ENTERED, "password_entered");
//            }
//        });
//        etName.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
//
//            }
//
//            @Override
//            public void onTextChanged(CharSequence s, int start, int before, int count) {
//
//            }
//
//            @Override
//            public void afterTextChanged(Editable s) {
//                //MyApplication.getInstance().trackEvent(SIGNUP_SCREEN, NAME_ENTERED, "name_entered");
//            }
//        });
//        etBusinessName.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
//
//            }
//
//            @Override
//            public void onTextChanged(CharSequence s, int start, int before, int count) {
//
//            }
//
//            @Override
//            public void afterTextChanged(Editable s) {
//                //MyApplication.getInstance().trackEvent(SIGNUP_SCREEN, BUSINESS_NAME_ENTERED, "business_name_entered");
//            }
//        });
//        etContact.addTextChangedListener(new TextWatcher() {
//            @Override
//            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
//
//            }
//
//            @Override
//            public void onTextChanged(CharSequence s, int start, int before, int count) {
//
//            }
//
//            @Override
//            public void afterTextChanged(Editable s) {
//                //MyApplication.getInstance().trackEvent(LOGIN_SCREEN, CONTACT_ENTERED, "contact_entered");
//            }
//        });
//
//        etPassword.setOnKeyListener(new View.OnKeyListener() {
//            public boolean onKey(View v, int keyCode, KeyEvent event) {
//                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
//                        (keyCode == KeyEvent.KEYCODE_ENTER)) {
//                    bSignUp.performClick();
//                    return true;
//                }
//                return false;
//            }
//        });
//
//        tnc.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
//            @Override
//            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                if (buttonView.isChecked())
//                    bSignUp.setEnabled(true);
//                else
//                    bSignUp.setEnabled(false);
//            }
//        });
//    }
//
//    private void submitForm() {
//        if (!validateBusinessName() && inputBusinessName.getVisibility() == View.VISIBLE) {
//            return;
//        }
//        if (!validateName()) {
//            return;
//        }
//        if (!validateEmail()) {
//            return;
//        }
//        if (!validatePassword()) {
//            return;
//        }
//        if (inputBusinessName.getVisibility() == View.GONE && !validateContact()) {
//            return;
//        }
//
//        apiContinent();
//    }
//
//    private boolean validateEmail() {
//        String email = etEmail.getText().toString().trim();
//
//        if (email.isEmpty() || !isValidEmail(email)) {
//            inputEmail.setError(getString(R.string.err_msg_email));
//            requestFocus(inputEmail);
//            return false;
//        } else {
//            inputEmail.setErrorEnabled(false);
//        }
//        return true;
//    }
//
//    private boolean validatePassword() {
//        if (etPassword.getText().toString().trim().isEmpty()) {
//            inputPassword.setError(getString(R.string.err_msg_password));
//            requestFocus(inputPassword);
//            return false;
//        } else {
//            inputPassword.setErrorEnabled(false);
//        }
//
//        return true;
//    }
//
//    private boolean validateName() {
//        if (etName.getText().toString().trim().isEmpty()) {
//            inputName.setError(getString(R.string.err_msg_name));
//            requestFocus(inputName);
//            return false;
//        } else {
//            inputName.setErrorEnabled(false);
//        }
//
//        return true;
//    }
//
//    private boolean validateBusinessName() {
//        if (etBusinessName.getText().toString().trim().isEmpty()) {
//            inputBusinessName.setError(getString(R.string.err_msg_business_name));
//            requestFocus(inputBusinessName);
//            return false;
//        } else {
//            inputBusinessName.setErrorEnabled(false);
//        }
//
//        return true;
//    }
//
//    private boolean validateContact() {
//        if(TextUtils.isEmpty(etContact.getText().toString().trim())) {
//            inputContact.setError(getString(R.string.err_msg_phone));
//            requestFocus(inputContact);
//            return false;
//        } else if(!Utils.isValidPhoneNumber(etContact.getText().toString().trim())) {
//            inputContact.setError(getString(R.string.err_msg_phone_invalid));
//            requestFocus(inputContact);
//            return false;
//        } else {
//            inputContact.setErrorEnabled(false);
//        }
//
//        return true;
//    }
//
//    private void requestFocus(View view) {
//        if (view.requestFocus()) {
//            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
//        }
//    }
//
//    private void apiContinent() {
//        if (isNetworkAvailable()) {
//            Logger.INSTANCE.apiRequest("/requestCountryCodeGeoIP2", "");
//            RestClient.getApiInterfaceForContinent().getContinent()
//                    .enqueue(new ResponseResolver<Continent>(SignupActivity.this, true, true) {
//                        @Override
//                        public void success(final Continent continent) {
//                            Logger.INSTANCE.apiResponse("/requestCountryCodeGeoIP2", "");
//                            try {
//                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == continent.getStatus()) {
//                                    continentCode = continent.getData().getContinentCode();
//                                    try {
//                                        CommonData.setUserContCode(continent.getData().getContinentCode());
//                                        CommonData.setUserCountryCode(continent.getData().getCountryCode());
//                                    } catch (Exception e) {
//
//                                    }
//                                    if(inputBusinessName.getVisibility() == View.VISIBLE) {
//                                        apiSignup();
//                                    } else {
//                                        wlSignup();
//                                    }
//                                } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == continent.getStatus()) {
//                                    Toast.makeText(SignupActivity.this, continent.getMessage(), Toast.LENGTH_SHORT).show();
//                                }
//                            } catch (Exception e) {
//                                Logger.INSTANCE.apiFailed("/requestCountryCodeGeoIP2", e.getLocalizedMessage());
//                                e.printStackTrace();
//                            }
//                        }
//
//                        @Override
//                        public void failure(APIError error) {
//                            Logger.INSTANCE.apiFailed("/requestCountryCodeGeoIP2", error.getMessage());
//                            Log.e("error", "error");
//                        }
//                    });
//        } else {
//            Toast.makeText(SignupActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//        }
//    }
//
//    private void wlSignup() {
//        if (isNetworkAvailable()) {
//            CommonParams.Builder builder = new CommonParams.Builder();
//            builder.add("app_secret_key", BuildConfig.REFERENCE_SECRET_KEY);
//            builder.add("full_name", etName.getText().toString().trim());
//            builder.add("email", etEmail.getText().toString().trim());
//            builder.add("password", etPassword.getText().toString().trim());
//            if(!TextUtils.isEmpty(CommonData.getUserContCode())) {
//                builder.add("continent_code", CommonData.getUserContCode());
//                builder.add("country_code", CommonData.getUserCountryCode());
//            }
//
//            if (!TextUtils.isEmpty(etContact.getText().toString().trim())) {
//                builder.add("contact_number", etContact.getText().toString().trim());
//            } else {
//                builder.add("contact_number", "");
//            }
//
//            builder.add("source", "Hippo-Agent-App-Direct");
//            builder.add("medium", "Hippo-Agent-App");
//
//            if(!TextUtils.isEmpty(imagePath)) {
//                builder.add("user_image", imagePath);
//            }
//            if (Config.isWhiteLabel)
//                builder.add("app_type", HippoConfig.getInstance().getAttributes().getAppType());
//
//            CommonParams commonParams = builder.build();
//
//            Logger.INSTANCE.apiRequest("/api/agent/agentSignup", new Gson().toJson(commonParams.getMap()));
//            RestClient.getApiInterface().agentSignup(commonParams.getMap()).enqueue(new ResponseResolver<LoginResponse>(SignupActivity.this, true, false) {
//                @Override
//                public void success(LoginResponse loginResponse) {
//                    Logger.INSTANCE.apiResponse("/api/agent/agentSignup", "");
//                    try {
//                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
//                            if(userConfig.getData().getTemplates() != null && userConfig.getData().getTemplates().size()>0) {
//                                Pref1.with(SignupActivity.this).save("access_token", loginResponse.getUserData().getAccessToken());
//                                Pref1.with(SignupActivity.this).save("en_user_id", loginResponse.getUserData().getEnUserId());
//                                startActivity(new Intent(SignupActivity.this, SignupOnBoard.class));
//                                finish();
//                            } else {
//                                apiLogin();
//                            }
//                        } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.getStatusCode()) {
//                            Toast.makeText(SignupActivity.this, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
//                        } else if(ApiResponseFlags.ACTION_EXITS.getOrdinal() == loginResponse.getStatusCode()) {
//                            Intent intent = new Intent();
//                            Bundle conData = new Bundle();
//                            conData.putString("email", etEmail.getText().toString().trim());
//                            intent.putExtras(conData);
//                            setResult(100, intent);
//                            finish();
//                        }
//                    } catch (Exception e) {
//                        e.printStackTrace();
//                    }
//                }
//
//                @Override
//                public void failure(APIError error) {
//                    if (error.getStatusCode() == ApiResponseFlags.ACTION_EXITS.getOrdinal()) {
//                        Toast.makeText(SignupActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
//                        Intent intent = new Intent();
//                        Bundle conData = new Bundle();
//                        conData.putString("email", etEmail.getText().toString().trim());
//                        intent.putExtras(conData);
//                        setResult(100, intent);
//                        finish();
//                    }
//                }
//            });
//
//
//        } else {
//            Toast.makeText(SignupActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//        }
//    }
//
//    private void apiSignup() {
//        if (isNetworkAvailable()) {
//            Log.v("app_version", "---> " + HippoConfig.getInstance().getAttributes().getVersionCode());
//            Log.v("email", "---> " + etEmail.getText().toString().trim());
//
//            // TODO: 18/01/19 Remove +91 country code and required changes
//            CommonParams.Builder builder = new CommonParams.Builder();
//            builder.add("business_name", etBusinessName.getText().toString().trim());
//            builder.add("full_name", etName.getText().toString().trim());
//            builder.add("email", etEmail.getText().toString().trim());
//            builder.add("password", etPassword.getText().toString().trim());
//            if(!TextUtils.isEmpty(CommonData.getUserContCode())) {
//                builder.add("continent_code", CommonData.getUserContCode());
//                builder.add("country_code", CommonData.getUserCountryCode());
//            }
//
//            if (!TextUtils.isEmpty(etContact.getText().toString().trim())) {
//                builder.add("contact_number", etContact.getText().toString().trim());
//            } else {
//                builder.add("contact_number", "");
//            }
//
//            builder.add("source", "Hippo-Agent-App-Direct");
//            builder.add("medium", "Hippo-Agent-App");
//
//            CommonParams commonParams = builder.build();
//
//            Logger.INSTANCE.apiRequest("/api/business/signUp", new Gson().toJson(commonParams.getMap()));
//            RestClient.getApiInterface().signup(commonParams.getMap())
//                    .enqueue(new ResponseResolver<LoginResponse>(SignupActivity.this, true, true) {
//                        @Override
//                        public void success(final LoginResponse loginResponse) {
//                            Logger.INSTANCE.apiResponse("/api/business/signUp", "");
//                            try {
//                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
//                                    apiLogin();
//                                } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.getStatusCode()) {
//                                    Toast.makeText(SignupActivity.this, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
//                                }
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                            }
//                        }
//
//                        @Override
//                        public void failure(APIError error) {
//                            Logger.INSTANCE.apiFailed("/api/business/signUp", error.getMessage());
//                            Log.e("error", "error");
//                        }
//                    });
//        } else {
//            Toast.makeText(SignupActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//        }
//    }
//
//    private void apiLogin() {
//        if (isNetworkAvailable()) {
//            Log.v("app_version", "---> " + HippoConfig.getInstance().getAttributes().getVersionCode());
//            Log.v("email", "---> " + etEmail.getText().toString().trim());
//
//            Gson gson = new GsonBuilder().create();
//            JsonObject deviceDetailsJson = null;
//            try {
//                deviceDetailsJson = gson.toJsonTree(new DeviceDetails(getAppVersion()).getDeviceDetails()).getAsJsonObject();
//            } catch (PackageManager.NameNotFoundException e) {
//                e.printStackTrace();
//            }
//
//            CommonParams.Builder builder = new CommonParams.Builder();
//            builder.add(Constants.EMAIL, etEmail.getText().toString().trim());
//            builder.add(Constants.PASSWORD, etPassword.getText().toString().trim());
//            builder.add(DEVICE_TYPE, Constants.ANDROID);
//            builder.add(Constants.DEVICE_TOKEN, Paper.book(CommonData.name).read(SPLabels.DEVICE_TOKEN));
//            builder.add(APP_VERSION_CODE, HippoConfig.getInstance().getAttributes().getVersionCode());
//            builder.add("device_id", UniqueIMEIID.getUniqueIMEIId(this));
//            builder.add(DEVICE_DETAILS, deviceDetailsJson);
//            builder.add(APP_SOURCE, String.valueOf(2));
//
//            CommonParams commonParams = builder.build();
//
//            Logger.INSTANCE.apiRequest("/api/agent/v1/agentLogin", new Gson().toJson(commonParams.getMap()));
//            RestClient.getApiInterface().login(commonParams.getMap())
//                    .enqueue(new ResponseResolver<LoginResponse>(SignupActivity.this, true, true) {
//                        @Override
//                        public void success(final LoginResponse loginResponse) {
//                            Logger.INSTANCE.apiResponse("/api/agent/v1/agentLogin", "");
//                            try {
//                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
//                                    try {
//                                        MyApplication.getInstance().saveUserData(loginResponse.getUserData());
//                                    } catch (Exception e) {
//                                        e.printStackTrace();
//                                    }
//                                    if (loginResponse.getUserData().getVersion() != null &&
//                                            loginResponse.getUserData().getVersion().getIsForce() != null) {
//                                        Pref1.with(SignupActivity.this).save("access_token", loginResponse.getUserData().getAccessToken());
//                                        Pref1.with(SignupActivity.this).save("en_user_id", loginResponse.getUserData().getEnUserId());
//                                        if (loginResponse.getUserData().getVersion().getLatestVersion() > HippoConfig.getInstance().getAttributes().getVersionCode()) {
//                                            if (loginResponse.getUserData().getVersion().getIsForce().equals(1)) {
//                                                SingleBtnUpdateWindow(loginResponse);
//                                                Paper.book(CommonData.name).delete(SPLabels.IS_FORCE);
//                                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
//                                                Paper.book(CommonData.name).write(SPLabels.IS_FORCE, loginResponse.getUserData().getVersion().getIsForce());
//                                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, loginResponse.getUserData().getVersion().getIsForce());
//                                                return;
//                                            } else if (loginResponse.getUserData().getVersion().getIsForce().equals(0)) {
//                                                Log.v("Latest Version--->>>>>>", String.valueOf(MyApplication.getInstance().getLatestVersion()));
//                                                ShowUpdateWindowTwoBtns(loginResponse);
//                                            } else {
//                                                Paper.book(CommonData.name).delete(SPLabels.USER_DATA);
//                                                Paper.book(CommonData.name).write(SPLabels.USER_DATA, loginResponse.getUserData());
//                                                Paper.book(CommonData.name).write(SPLabels.TAGS, loginResponse.getUserData().getTags());
//                                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
//                                                Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, loginResponse.getUserData().getVersion().getLatestVersion());
//                                                finish();
//                                                startActivity(new Intent(SignupActivity.this, HomeActivity.class));
//
//                                            }
//
//                                        } else {
//                                            Paper.book(CommonData.name).delete(SPLabels.USER_DATA);
//                                            Paper.book(CommonData.name).write(SPLabels.USER_DATA, loginResponse.getUserData());
//                                            Paper.book(CommonData.name).write(SPLabels.TAGS, loginResponse.getUserData().getTags());
//                                            Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
//                                            Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, loginResponse.getUserData().getVersion().getLatestVersion());
//                                            finish();
//                                            startActivity(new Intent(SignupActivity.this, HomeActivity.class));
//                                        }
//                                    } else {
//                                        Pref1.with(SignupActivity.this).save("access_token", loginResponse.getUserData().getAccessToken());
//                                        Pref1.with(SignupActivity.this).save("en_user_id", loginResponse.getUserData().getEnUserId());
//                                        Paper.book(CommonData.name).delete(SPLabels.USER_DATA);
//                                        Paper.book(CommonData.name).write(SPLabels.USER_DATA, loginResponse.getUserData());
//                                        Paper.book(CommonData.name).write(SPLabels.TAGS, loginResponse.getUserData().getTags());
//                                        finish();
//                                        startActivity(new Intent(SignupActivity.this, HomeActivity.class));
//                                    }
//                                } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.getStatusCode()) {
//                                    Toast.makeText(SignupActivity.this, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
//                                }
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                            }
//                        }
//
//                        @Override
//                        public void failure(APIError error) {
//                            Logger.INSTANCE.apiFailed("/api/agent/v1/agentLogin", error.getMessage());
//                            Log.e("error", "error");
//                        }
//                    });
//        } else {
//            Toast.makeText(SignupActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//        }
//    }
//
//    @Override
//    public void onBackPressed() {
//        super.onBackPressed();
//        finish();
//    }
//
//    /*private void showUpdateWindowTwoBtns(final LoginResponse loginResponse) {
//
//        Paper.book(CommonData.name).delete(SPLabels.USER_DATA);
//        Paper.book(CommonData.name).write(SPLabels.USER_DATA, loginResponse.getUserData());
//        Paper.book(CommonData.name).write(SPLabels.TAGS, loginResponse.getUserData().getTags());
//        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
//        Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, loginResponse.getUserData().getVersion().getLatestVersion());
//
//        startActivity(new Intent(SignupActivity.this, MainActivity.class).putExtra(SHOW_UPDATE, true)
//                .putExtra(UPDATE_LINK, loginResponse.getUserData().getVersion().getDownloadLink())
//                .putExtra(UPDATE_TITLE, loginResponse.getUserData().getVersion().getText()));
//    }
//
//    private void SingleBtnUpdateWindow(final LoginResponse loginResponse) {
//        //MyApplication.getInstance().trackEvent(GAEvents.LOGIN_SCREEN, GAEvents.FORCE_UPDATE, "force_update_clicked");
//        AlertDialog alertDialog = new AlertDialog.Builder(SignupActivity.this).create();
//        alertDialog.setMessage(loginResponse.getUserData().getVersion().getText());
//        alertDialog.setButton(AlertDialog.BUTTON_NEUTRAL, "OK",
//                new DialogInterface.OnClickListener() {
//                    public void onClick(DialogInterface dialog, int which) {
//                        Intent browserIntent = new Intent(Intent.ACTION_VIEW,
//                                Uri.parse(loginResponse.getUserData().getVersion().getDownloadLink()));
//                        startActivity(browserIntent);
//                        finish();
//                    }
//                });
//        alertDialog.show();
//    }*/
//
//    /**
//     * set spannable text
//     */
//    private void setTocSpannableText(TextView textView) {
//        String spanText = getResources().getString(R.string.terms_of_service);
//        String privacyText = getResources().getString(R.string.privacy_policy);
//        String fullText = getResources().getString(R.string.confirmation);
//        SpannableString spannableString = new SpannableString(getResources().getString(R.string.confirmation));
//        ClickableSpan terms = new ClickableSpan() {
//            @Override
//            public void onClick(final View widget) {
//                if(!TextUtils.isEmpty(conditionLink))
//                    Utils.redirectUserToUrl(SignupActivity.this, conditionLink);
//                else
//                    Utils.redirectUserToUrl(SignupActivity.this, getString(R.string.terms_of_service_link));
//            }
//
//            @Override
//            public void updateDrawState(final TextPaint ds) {
//                // super.updateDrawState(ds);
//                ds.setUnderlineText(false);
//                ds.setColor(ContextCompat.getColor(SignupActivity.this, R.color.colorPrimaryDark));
//            }
//        };
//        ClickableSpan privacy = new ClickableSpan() {
//            @Override
//            public void onClick(final View widget) {
//                if(!TextUtils.isEmpty(policyLink))
//                    Utils.redirectUserToUrl(SignupActivity.this, policyLink);
//                else
//                    Utils.redirectUserToUrl(SignupActivity.this, getString(R.string.privacy_policy_link));
//            }
//
//            @Override
//            public void updateDrawState(final TextPaint ds) {
//                // super.updateDrawState(ds);
//                ds.setUnderlineText(false);
//                ds.setColor(ContextCompat.getColor(SignupActivity.this, R.color.colorPrimaryDark));
//            }
//        };
//
//        spannableString.setSpan(terms, fullText.indexOf(spanText), (fullText.indexOf(spanText) + spanText.length()), 0);
//        spannableString.setSpan(privacy, fullText.indexOf(privacyText), (fullText.indexOf(privacyText) + privacyText.length()), 0);
//
//        textView.setMovementMethod(LinkMovementMethod.getInstance());
//        textView.setText(spannableString, TextView.BufferType.SPANNABLE);
//        textView.setSelected(true);
//    }
//
//    private void getUserInfo(UserCallback callback) {
//        try {
//            Gson gson = new GsonBuilder()
//                    .setLenient()
//                    .create();
//
//            Retrofit retrofit = new Retrofit.Builder()
//                    .baseUrl("https://ip.tookanapp.com:8000")
//                    .addConverterFactory(GsonConverterFactory.create(gson))
//                    .build();
//
//            ApiInterface gerritAPI = retrofit.create(ApiInterface.class);
//
//            Call<UserInfoModel> call = gerritAPI.getUserInfo();
//            call.enqueue(new ResponseResolver<UserInfoModel>() {
//                @Override
//                public void success(UserInfoModel userInfoModel) {
//                    try {
//                        CommonData.setUserContCode(userInfoModel.getData().getContinentCode());
//                        CommonData.setUserCountryCode(userInfoModel.getData().getCountryCode());
//                    } catch (Exception e) {
//
//                    }
//                    if(callback != null) {
//                        callback.onSuccess(userInfoModel);
//                    }
//                }
//                @Override
//                public void failure(APIError error) {
//                    if(callback != null) {
//                        callback.onSuccess(null);
//                    }
//                }
//            });
//        } catch (Exception e) {
//            if(callback != null) {
//                callback.onSuccess(null);
//            }
//        }
//    }
//
//    public interface UserCallback {
//        void onSuccess(UserInfoModel userInfoModel);
//    }
//
//    @Override
//    public void onActivityResult(int requestCode, int resultCode, Intent data) {
//        super.onActivityResult(requestCode, resultCode, data);
//        if (requestCode == Picker.PICK_IMAGE_DEVICE || requestCode == Picker.PICK_IMAGE_CAMERA)
//            imageChooser.onActivityResult(requestCode, resultCode, data);
//    }
//
//
//    @Override
//    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
//        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
//        if (requestCode == ImageChooser.PERMISSION_REQUEST_CODE_CAMERA_READ_WRITE)
//            imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
//    }
//
//
//    @Override
//    public void loadImage(List<ChosenImage> list) {
//        //profileImgFile = new File(list.get(0).getThumbnailPath());
//        new ImageUpload().uploadingImageAPI(SignupActivity.this, list.get(0).getThumbnailPath(), new OnImageUploadListener() {
//            @Override
//            public void onImageUpload(@NotNull String path) {
//                imagePath = path;
//                LoadImageFile.getInstance().loadImage(SignupActivity.this, list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, ivAgentImage, 3);
//            }
//        });
//    }
//}
//
