package com.hippoagent.activities;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import androidx.appcompat.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.fragments.ChangePasswordFragment;
import com.hippoagent.fragments.EditProfileFragment;
import com.hippoagent.fragments.ViewProfileFragment;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.UniqueIMEIID;
import com.google.gson.Gson;

import java.util.HashMap;

import io.paperdb.Paper;

import static com.hippoagent.appData.AppManager.USER_ONBOARD_HASCLASS;
import static com.hippoagent.appData.AppManager.USER_ONBOARD_VALUE;
import static com.hippoagent.utils.GAEvents.BACK_BTN_CLICKED;
import static com.hippoagent.utils.GAEvents.CHANGE_PASS_SCREEN;
import static com.hippoagent.utils.GAEvents.EDIT_PRO_SCREEN;
import static com.hippoagent.utils.GAEvents.LOGOUT_CLICKED;
import static com.hippoagent.utils.GAEvents.PRO_SCREEN;

public class ProfileActivity extends FuguBaseActivity implements View.OnClickListener {
    private LinearLayout llContainer, llTitle;
    private Toolbar toolbar;
    private TextView toolbarTitle, tvLogout;
    private boolean isOpenAnotherFrag = false, isChangePass = false;
    private ImageChooser imageChooser;

    private int userOnBoardingValue = 0;
    private boolean onboardClassFinish = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_profile);

        if (getIntent().hasExtra(USER_ONBOARD_VALUE)) {
            userOnBoardingValue = getIntent().getIntExtra(USER_ONBOARD_VALUE, 0);
            onboardClassFinish = getIntent().getBooleanExtra(USER_ONBOARD_HASCLASS, true);
        } else if (savedInstanceState != null) {
            userOnBoardingValue = savedInstanceState.getInt(USER_ONBOARD_VALUE, 0);
            onboardClassFinish = savedInstanceState.getBoolean(USER_ONBOARD_HASCLASS, true);
        }
        initView();
        openScreens(userOnBoardingValue);

    }

    private void openScreens(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case ONLY_NAME:
                openEditScreenFragment();
                break;
            case ONLY_PASSWORD:
                openPasswordFragment();
                break;
            case BOTH_NAME_PASSWORD:
                openEditScreenFragment();
                break;
            default:
                getAgentData();
                break;
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putInt(USER_ONBOARD_VALUE, userOnBoardingValue);
        outState.putBoolean(USER_ONBOARD_HASCLASS, onboardClassFinish);
        super.onSaveInstanceState(outState);
    }

    private void initView() {
        toolbarTitle = (TextView) findViewById(R.id.tv_toolbar_name);
        tvLogout = (TextView) findViewById(R.id.tvLogout);
        tvLogout.setOnClickListener(this);
        llTitle = (LinearLayout) findViewById(R.id.llTitle);
        imageChooser = new ImageChooser(this);

        llContainer = (LinearLayout) findViewById(R.id.llContainer);
        toolbar = (Toolbar) findViewById(R.id.my_toolbar);
        setSupportActionBar(toolbar);
        try {
            getSupportActionBar().setDisplayShowTitleEnabled(false);
            getSupportActionBar().setDisplayHomeAsUpEnabled(userOnBoardingValue == 0);
        } catch (Exception e) {
            e.printStackTrace();
        }
        setToolbarTitle(getResources().getString(R.string.your_profile), false);

    }

    public void setToolbarTitle(String title, boolean isClicked) {
        toolbarTitle.setText(title);
        if (isClicked) {
            tvLogout.setVisibility(View.GONE);
        } else {
            tvLogout.setVisibility(View.VISIBLE);
        }
    }

    public void setClickBool(boolean isClicked, boolean isChange) {
        isOpenAnotherFrag = isClicked;
        isChangePass = isChange;
    }

    private boolean doubleBackToExitPressedOnce = false;

    private void backButton() {
        if (doubleBackToExitPressedOnce) {
            apiLogout();
            return;
        }

        this.doubleBackToExitPressedOnce = true;
        Toast.makeText(this, "Press again to exit", Toast.LENGTH_SHORT).show();

        new Handler().postDelayed(new Runnable() {

            @Override
            public void run() {
                doubleBackToExitPressedOnce = false;
            }
        }, 2000);
    }

    private void userOnBoardingBack(int userOnBoardingValue) {
        switch (UserOnBoard.get(userOnBoardingValue)) {
            case BOTH_NAME_PASSWORD:
                //backButton();
                break;
            case ONLY_NAME:
            case ONLY_PASSWORD:
            default:
                ////MyApplication.getInstance().trackEvent(PRO_SCREEN, BACK_BTN_CLICKED, "profile_back_button");
                //super.onBackPressed();
                break;
        }
    }

    @Override
    public void onBackPressed() {
        if (userOnBoardingValue != 0) {
            //userOnBoardingBack(userOnBoardingValue);
        } else if (isOpenAnotherFrag) {
            isOpenAnotherFrag = false;
            getSupportFragmentManager().beginTransaction()
                    .setCustomAnimations(
                            R.anim.anim_slide_in_right, R.anim.anim_slide_out_right, R.anim.anim_slide_in_left, R.anim.anim_slide_out_left)
                    .replace(llContainer.getId(), ViewProfileFragment.newInstance(), ViewProfileFragment.class.getName())
                    .commit();
            setToolbarTitle(getResources().getString(R.string.your_profile), false);
            if (isChangePass) {
                //MyApplication.getInstance().trackEvent(CHANGE_PASS_SCREEN, BACK_BTN_CLICKED, "change_password_back_button");
            } else {
                //MyApplication.getInstance().trackEvent(EDIT_PRO_SCREEN, BACK_BTN_CLICKED, "edit_profile_back_button");
            }
        } else {
            //MyApplication.getInstance().trackEvent(PRO_SCREEN, BACK_BTN_CLICKED, "profile_back_button");
            super.onBackPressed();
        }
    }

    public void updateMenu() {
        invalidateOptionsMenu();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed();
        } else if (item.getItemId() == R.id.btnSkip) {
            onBackPressed();
        }
        return true;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        imageChooser.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.tvLogout) {//MyApplication.getInstance().trackEvent(PRO_SCREEN, LOGOUT_CLICKED, "profile_logout");
            performLogout();
        }
    }

    private void apiLogout() {
        if (isNetworkAvailable()) {
            Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, MyApplication.getInstance().getUserData().getAccessToken())
                    .add(Constants.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
                    .add(Constants.DEVICE_TYPE, Constants.ANDROID)
                    .build();
            Logger.INSTANCE.apiRequest("/api/agent/agentLogout", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().logout(commonParams.getMap())
                    .enqueue(new ResponseResolver<LoginResponse>(ProfileActivity.this, true, true) {
                        @Override
                        public void success(LoginResponse loginResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/agentLogout", "");
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
                                    MyApplication.getInstance().logout(ProfileActivity.this);
                                }
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/agent/agentLogout", e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/agentLogout", error.getMessage());
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(ProfileActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    public void getAgentData() {
        getAgentData(false);
    }
    public void getAgentData(final boolean flag) {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
        params.put(Constants.EN_USER_ID, String.valueOf(MyApplication.getInstance().getUserData().getEnUserId()));

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        Logger.INSTANCE.apiRequest("/api/agent/getInfo", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap())
                .enqueue(new ResponseResolver<AgentProfileDetails>(ProfileActivity.this, !flag, true) {
                    @Override
                    public void success(AgentProfileDetails agentProfileDetails) {
                        Logger.INSTANCE.apiResponse("/api/agent/getInfo", "");
                        try {
                            Paper.book(CommonData.name).delete(SPLabels.AGENT_PROFILE_DATA);
                            Paper.book(CommonData.name).write(SPLabels.AGENT_PROFILE_DATA, agentProfileDetails);
                            if(flag) {
                                MyApplication.getInstance().getAgentProfileDetails().getData().setUserImage(agentProfileDetails.getData().getUserImage());
                                MyApplication.getInstance().getUserData().setUserImage(agentProfileDetails.getData().getUserImage());
                            } else {
                                getSupportFragmentManager().beginTransaction()
                                        .replace(llContainer.getId(), ViewProfileFragment.newInstance(), ViewProfileFragment.class.getName())
                                        .commit();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            Logger.INSTANCE.apiFailed("/api/agent/getInfo", e.getLocalizedMessage());
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/agent/getInfo", error.getMessage());
                    }

                });
    }

    private void performLogout() {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton(ProfileActivity.this, "", getResources().getString(R.string.logout_message)
                , getResources().getString(R.string.logout_caps)
                , getResources().getString(R.string.cancel), new DialogPop.Callback() {
                    @Override
                    public void onPositiveClick() {
                        apiLogout();
                    }

                    @Override
                    public void onNegativeClick() {

                    }
                });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_NO) {
        } else if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_YES) {
            getWindow().getDecorView().clearFocus();
        }
    }


    public void hideKeyboardFrom(Activity activity) {
        InputMethodManager imm = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
        if (imm.isAcceptingText()) {
            imm.toggleSoftInput(InputMethodManager.HIDE_IMPLICIT_ONLY, 0); // hide
        } else {

        }
    }

    public void afterAgentOnBoard() {
        MyApplication.getInstance().getUserData().setAgentOnboardingComplete(0);
        MyApplication.getInstance().saveUserData(MyApplication.getInstance().getUserData());
        if (onboardClassFinish) {
            super.onBackPressed();
        } else {
            finish();
            startActivity(new Intent(ProfileActivity.this, HomeActivity.class));
        }
    }

    private void openEditScreenFragment() {

        EditProfileFragment editProfileFragment = new EditProfileFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(USER_ONBOARD_VALUE, userOnBoardingValue);
        editProfileFragment.setArguments(bundle);

        setClickBool(true, false);
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.llContainer, editProfileFragment, EditProfileFragment.class.getName())
                .commit();
    }

    private ChangePasswordFragment getChangePasswordFragment() {
        return (ChangePasswordFragment) getSupportFragmentManager().findFragmentByTag(ChangePasswordFragment.class.getName());
    }

    public void openPasswordFragment() {
        setClickBool(true, true);
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.llContainer, ChangePasswordFragment.newInstance(userOnBoardingValue), ChangePasswordFragment.class.getName())
                .commit();
    }
}
