package com.hippoagent.activities

import android.app.Activity
import android.content.Intent
import android.content.pm.PackageManager
import android.widget.Toast
import com.hippoagent.callback.LoginApiCallBack
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.ApiResponseFlags
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.LoginResponse.LoginResponse
import com.hippoagent.model.LoginResponse.Tag
import com.hippoagent.model.LoginResponse.UserData
import com.hippoagent.model.user_details.DeviceDetails
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.*
import com.hippoagent.utils.Constants.APP_SOURCE
import com.hippoagent.utils.Constants.APP_VERSION_CODE
import com.google.gson.GsonBuilder
import com.google.gson.JsonObject
import com.hippoagent.*
import io.paperdb.Paper

/**
 * Created by gurmail on 2019-11-21.
 * @author gurmail
 */
object LoginApi: FuguAppConstant {
    fun login(context: Activity, configAttributes: HippoConfigAttributes, loginApicallBack: LoginApiCallBack, showLoader: Boolean, parseData: Boolean) {
        val gson = GsonBuilder().create()
        var deviceDetailsJson: JsonObject? = null
        try {
            deviceDetailsJson = gson.toJsonTree(DeviceDetails(getAppVersion(context)).deviceDetails).asJsonObject
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }

        val builder = CommonParams.Builder()
        builder.add(Constants.ACCESS_TOKEN, configAttributes.authToken)
        builder.add(FuguAppConstant.DEVICE_TYPE, Constants.ANDROID)
        builder.add(Constants.DEVICE_TOKEN, configAttributes.deviceToken)
        builder.add(APP_VERSION_CODE, BuildConfig.VERSION_CODE)
        builder.add("device_id", UniqueIMEIID.getUniqueIMEIId(context))
        builder.add(FuguAppConstant.DEVICE_DETAILS, deviceDetailsJson)
        builder.add(APP_SOURCE, 2.toString())
        if (configAttributes.isWhitelabel)
            builder.add("app_type", configAttributes.appType)

        val commonParams = builder.build()

        RestClient.getApiInterface().login(commonParams.map).enqueue(object : ResponseResolver<LoginResponse>(context, showLoader, true) {
            override fun success(loginResponse: LoginResponse) {
                if(!parseData){
                    loginApicallBack.onApiSuccess(loginResponse)

                    return
                }
                try {
                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.statusCode) {
                        Paper.book(CommonData.name).delete(SPLabels.USER_DATA)
                        Paper.book(CommonData.name).write<UserData>(SPLabels.USER_DATA, loginResponse.userData)
                        Paper.book(CommonData.name).write<List<Tag>>(SPLabels.TAGS, loginResponse.userData.tags)
                        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)
                        //Paper.book(CommonData.name).write<Int>(SPLabels.LATEST_VERSION, loginResponse.userData.version.latestVersion!!)
                        /*try {
                            MyApplication.getInstance().saveUserData(loginResponse.userData)
                        } catch (e: Exception) {
                        }*/

                        loginApicallBack.onApiSuccess(loginResponse)

                        /*if (loginResponse.userData.version != null && loginResponse.userData.version.isForce != null) {
                            Pref1.with(context).save("access_token", loginResponse.userData.accessToken)
                            Pref1.with(context).save("en_user_id", loginResponse.userData.enUserId)
                            try {
                                MyApplication.getInstance().saveUserData(loginResponse.userData)
                            } catch (e: Exception) {
                            }
                            if (loginResponse.userData.version.latestVersion > HippoConfig.getInstance().getAttributes().getVersionCode()) {
                                if (loginResponse.userData.version.isForce == 1) {
                                    loginApicallBack.singleBtnUpdateWindow(loginResponse)
                                    Paper.book(CommonData.name).delete(SPLabels.IS_FORCE)
                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)
                                    Paper.book(CommonData.name).write<Int>(SPLabels.IS_FORCE, loginResponse.userData.version.isForce!!)
                                    Paper.book(CommonData.name).write<Int>(SPLabels.LATEST_VERSION, loginResponse.userData.version.isForce!!)
                                    return
                                } else if (loginResponse.userData.version.isForce == 0) {
                                    loginApicallBack.showUpdateWindowTwoBtns(loginResponse)
                                } else {
                                    Paper.book(CommonData.name).delete(SPLabels.USER_DATA)
                                    Paper.book(CommonData.name).write<UserData>(SPLabels.USER_DATA, loginResponse.userData)
                                    Paper.book(CommonData.name).write<List<Tag>>(SPLabels.TAGS, loginResponse.userData.tags)
                                    Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)
                                    Paper.book(CommonData.name).write<Int>(SPLabels.LATEST_VERSION, loginResponse.userData.version.latestVersion!!)

                                }
                            } else {
                                Paper.book(CommonData.name).delete(SPLabels.USER_DATA)
                                Paper.book(CommonData.name).write<UserData>(SPLabels.USER_DATA, loginResponse.userData)
                                Paper.book(CommonData.name).write<List<Tag>>(SPLabels.TAGS, loginResponse.userData.tags)
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION)
                                Paper.book(CommonData.name).write<Int>(SPLabels.LATEST_VERSION, loginResponse.userData.version.latestVersion!!)

                                //todo return success

                            }
                        } else {
                            Pref1.with(context).save("access_token", loginResponse.userData.accessToken)
                            Pref1.with(context).save("en_user_id", loginResponse.userData.enUserId)
                            Paper.book(CommonData.name).delete(SPLabels.USER_DATA)
                            Paper.book(CommonData.name).write<UserData>(SPLabels.USER_DATA, loginResponse.userData)
                            Paper.book(CommonData.name).write<List<Tag>>(SPLabels.TAGS, loginResponse.userData.tags)
                        }*/
                    } else if (ApiResponseFlags.LOGIN_ERROR.getOrdinal() == loginResponse.statusCode) {
                        Log.e("Error", "Something went wrong")
                        loginApicallBack.onErrorMessage(loginResponse)
                        //Toast.makeText(context, loginResponse.getMessage(), Toast.LENGTH_SHORT).show()
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            override fun failure(error: APIError?) {
                loginApicallBack.onApiFailed(error)
            }
        })
    }

    fun getAppVersion(context: Activity): Int {
        try {
            return BuildConfig.VERSION_CODE//context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionCode
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
            return 0
        }

    }
}