package com.hippoagent.activities;


import android.animation.ObjectAnimator;
import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.transition.Transition;
import com.easyfilepicker.easypermissions.AfterPermissionGranted;
import com.easyfilepicker.easypermissions.AppSettingsDialog;
import com.easyfilepicker.easypermissions.EasyPermissions;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.model.Image;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;
import com.hippoagent.utils.zoomview.ZoomageView;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

/**
 * Created by gurmail on 21/01/19.
 *
 * @author gurmail
 */
public class ImageDisplayActivity extends FuguBaseActivity implements EasyPermissions.PermissionCallbacks {

    private static final String TAG = ImageDisplayActivity.class.getSimpleName();
    private String imageUrl = "";

    ImageView ivImage, ivDownload;
    LinearLayout llTopBar;
    TextView tvDateTime;
    ZoomageView ivOriginalImage;
    FuguAgentProgressWheel progressWheel;
    private Image image;
    private RelativeLayout mainLayout;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_activity_image_display);

        // fixing portrait mode problem for SDK 26 if using windowIsTranslucent = true
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        } else {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
        }

        mainLayout = findViewById(R.id.main_layout);
        progressWheel = findViewById(R.id.progress);
        progressWheel.spin();

        ivImage = findViewById(R.id.ivMsgImage);
        ivDownload = findViewById(R.id.ivDownload);
        ivOriginalImage = findViewById(R.id.ivOriginalImage);
        llTopBar = findViewById(R.id.llTopBar);
        TextView tvChannelName  = findViewById(R.id.tvChannelName);
        tvDateTime = findViewById(R.id.tvDateTime);
        ImageView ivBack = findViewById(R.id.ivBack);

        image = (Image) getIntent().getSerializableExtra("image");

        if (!TextUtils.isEmpty(image.getChannelName())) {
            tvChannelName.setText(image.getChannelName());
        } else {
            tvChannelName.setText("Message");
        }
        //supportPostponeEnterTransition();

        ivImage.setVisibility(View.VISIBLE);
//        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//            ivImage.setTransitionName(getString(R.string.activity_image_trans));
//        }


        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM, hh:mm a");
        SimpleDateFormat formatter2 = new SimpleDateFormat("hh:mm a");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        try {
            String date = formatter.format(sdf.parse(DateUtils.getInstance().convertToLocal(image.getDateTime())));
            if (android.text.format.DateUtils.isToday(sdf.parse(DateUtils.getInstance().convertToLocal(image.getDateTime())).getTime())) {
                String time = formatter2.format(sdf.parse(DateUtils.getInstance().convertToLocal(image.getDateTime())));
                tvDateTime.setText("Today, "+time);
            } else {
                tvDateTime.setText(formatter.format(sdf.parse(DateUtils.getInstance().convertToLocal(image.getDateTime()))));
            }
        } catch (Exception e) {
            tvDateTime.setVisibility(View.GONE);
        }

        /*SwipeableLayout swipeableLayout = findViewById(R.id.swipeableLayout);

        swipeableLayout.setOnSwipedListener(swipedFrom -> {
            swipedFromDefault = swipedFrom;
            onBackPressed();
        });

        ivOriginalImage.setOnDoubleTap(zoom -> {
            if (zoom <= 1.0f) {
                swipeableLayout.isSwipeable(true);
            } else {
                swipeableLayout.isSwipeable(false);
            }
        });*/

        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        ivDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                downloadFile(image.getImageUrl());
            }
        });

        RequestOptions requestOptions = new RequestOptions().placeholderOf(R.drawable.hippo_placeholder)
                .dontAnimate()
                .onlyRetrieveFromCache(true)
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(R.drawable.hippo_call_placeholder)
                .dontTransform();

        final RequestOptions requestOptions2 = new RequestOptions()
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(R.drawable.hippo_call_placeholder)
                .dontTransform();



        Glide.with(ImageDisplayActivity.this).load(image.getThumbnailUrl())
                .apply(requestOptions)
                .into(new CustomViewTarget<RelativeLayout, Drawable>(mainLayout) {
                    @Override
                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                        ivImage.setVisibility(View.GONE);
                        progressWheel.setVisibility(View.GONE);
                        Glide.with(ImageDisplayActivity.this).asBitmap()
                                .apply(requestOptions2)
                                .load(image.getImageUrl())
                                .into(ivOriginalImage);
                    }

                    @Override
                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        supportStartPostponedEnterTransition();
                        ivImage.setVisibility(View.VISIBLE);
                        ivImage.setImageDrawable(resource);
                        progressWheel.setVisibility(View.GONE);
                        ObjectAnimator alphaAnimation = new ObjectAnimator().ofFloat(llTopBar, View.ALPHA, 0f, 1f);// .ofFloat(llTopBar, View.ALPHA, 0f, 1f)
                        alphaAnimation.setDuration(500);
                        alphaAnimation.setStartDelay(200);
                        alphaAnimation.start();

                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                Glide.with(ImageDisplayActivity.this).load(image.getImageUrl())
                                        .apply(requestOptions2)
                                        .into(new CustomViewTarget<RelativeLayout, Drawable>(mainLayout) {
                                            @Override
                                            protected void onResourceCleared(@Nullable Drawable placeholder) {

                                            }

                                            @Override
                                            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                                ivImage.setVisibility(View.GONE);
                                                progressWheel.setVisibility(View.GONE);
                                                Glide.with(ImageDisplayActivity.this).asBitmap()
                                                        .apply(requestOptions2)
                                                        .load(image.getThumbnailUrl())
                                                        .into(ivOriginalImage);
                                            }

                                            @Override
                                            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                                                supportStartPostponedEnterTransition();
                                                ivImage.setVisibility(View.GONE);
                                                ivOriginalImage.setImageDrawable(resource);
                                                if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                                                    ivImage.setTransitionName("");
                                                    ivOriginalImage.setTransitionName(getString(R.string.activity_image_trans));
                                                }
                                            }
                                        });
                            }
                        }, 500);
                    }

                    @Override
                    protected void onResourceCleared(@Nullable Drawable placeholder) {

                    }
                });



        /*RequestOptions requestOptions = new RequestOptions().placeholderOf(R.drawable.hippo_placeholder)
                .dontAnimate()
                .onlyRetrieveFromCache(true)
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(R.drawable.hippo_call_placeholder)
                .dontTransform();

        final RequestOptions requestOptions2 = new RequestOptions()
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(R.drawable.hippo_call_placeholder)
                .dontTransform();

        Glide.with(ImageDisplayActivity.this).load(image.getThumbnailUrl())
                .apply(requestOptions)
                .into(new SimpleTarget<Drawable>() {
                    @Override
                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        //supportStartPostponedEnterTransition();
//                        ActivityCompat.postponeEnterTransition(ImageDisplayActivity.this);
//                        ActivityCompat.startPostponedEnterTransition(ImageDisplayActivity.this);

                        ivImage.setImageDrawable(resource);
                        progressWheel.setVisibility(View.GONE);
//                        ObjectAnimator alphaAnimation = new ObjectAnimator().ofFloat(llTopBar, View.ALPHA, 0f, 1f);// .ofFloat(llTopBar, View.ALPHA, 0f, 1f)
//                        alphaAnimation.setDuration(500);
//                        alphaAnimation.setStartDelay(200);
//                        alphaAnimation.start();

                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                Glide.with(ImageDisplayActivity.this).load(image.getImageUrl())
                                        .apply(requestOptions2)
                                        .into(new SimpleTarget<Drawable>() {
                                            @Override
                                            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
//                                                ActivityCompat.postponeEnterTransition(ImageDisplayActivity.this);
//                                                ActivityCompat.startPostponedEnterTransition(ImageDisplayActivity.this);

                                                //supportStartPostponedEnterTransition();
                                                ivImage.setVisibility(View.GONE);
                                                ivOriginalImage.setImageDrawable(resource);
                                            }
                                        });
                            }
                        }, 500);
                    }
                });*/
    }


    @Override
    public void onBackPressed() {
        supportFinishAfterTransition();
        super.onBackPressed();
    }

    private Long downloadFile(String url) {
        if(!checkPermission()) {
            readExternalStorage();
            return null;
        }

        String fileName = Utils.extractFileNameWithoutSuffix(url);
        String ext = Utils.getExtension(url);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse(url));
        request.setDescription(MyApplication.getInstance().getUserData().getBusinessName());
        request.setTitle(fileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
        String directory = Utils.getOrCreateDirectoryPath(DocumentType.IMAGE.toString());
        request.setDestinationInExternalPublicDir(directory, fileName + ext);
        request.setMimeType("image/jpeg");
        DownloadManager manager = (DownloadManager) getSystemService(Context.DOWNLOAD_SERVICE);



        if (manager != null) {
            return manager.enqueue(request);
        } else
            return null;
    }

    public boolean checkPermission() {
        return EasyPermissions.hasPermissions(this, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    /**
     * Read external storage file
     */
    @AfterPermissionGranted(RC_READ_EXTERNAL_STORAGE)
    public void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            permissionGranted();
        } else {
            EasyPermissions.requestPermissions(this, getString(R.string.vw_rationale_storage),
                    RC_READ_EXTERNAL_STORAGE, "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // Forward results to EasyPermissions
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    /**
     * Read external storage file
     */
//    @AfterPermissionGranted(RC_READ_EXTERNAL_STORAGE)
//    private void readExternalStorage() {
//        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
//        if (isGranted) {
//            permissionGranted();
//        } else {
//            EasyPermissions.requestPermissions(this, getString(com.easyfilepicker.R.string.hippo_rationale_storage),
//                    RC_READ_EXTERNAL_STORAGE, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
//        }
//    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> perms) {
        android.util.Log.d(TAG, "onPermissionsGranted:" + requestCode + ":" + perms.size());
        permissionGranted();
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> perms) {
        android.util.Log.d(TAG, "onPermissionsDenied:" + requestCode + ":" + perms.size());
        // If Permission permanently denied, ask user again
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            new AppSettingsDialog.Builder(this).build().show();
        } else {
            finish();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == AppSettingsDialog.DEFAULT_SETTINGS_REQ_CODE) {
            // Do something after user returned from app settings screen, like showing a Toast.
            if (EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                permissionGranted();
            } else {
                finish();
            }
        }
    }

    private void permissionGranted() {
        downloadFile(image.getImageUrl());
    }
}
