package com.hippoagent.activities

import android.app.Activity
import android.content.DialogInterface
import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.os.Handler
import com.google.android.material.snackbar.Snackbar
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import android.text.TextUtils
import android.view.View
import android.widget.Button
import android.widget.TextView
import com.hippoagent.MyApplication
import com.hippoagent.R
import com.hippoagent.appData.AppManager.USER_ONBOARD_VALUE
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.dialogs.ConfirmationDialog
import com.hippoagent.eventbus.*
import com.hippoagent.fragments.LauncherFragment
import com.hippoagent.helper.BusEvents
import com.hippoagent.helper.ConnectionManager
import com.hippoagent.helper.ConversationApiHelper
import com.hippoagent.helper.FayeMessage
import com.hippoagent.model.Conversation
import com.hippoagent.model.GetConversationResponse
import com.hippoagent.services.HippoService
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Log
import com.google.gson.Gson
import com.hippoagent.HippoConfig
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.home_activity.*
import org.json.JSONObject

/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class HomeActivity: BaseActivity() {

    private fun subscribeChannels() {
        if (MyApplication.getInstance().userData != null && !TextUtils.isEmpty(MyApplication.getInstance().userData.userChannel)) {
            ConnectionManager.subScribeChannel("/" + MyApplication.getInstance().userData.userChannel.toString())
            ConnectionManager.subScribeChannel("/" + MyApplication.getInstance().userData.appSecretKey.toString() + "/agentsRefresh")
            ConnectionManager.subScribeChannel("/" + MyApplication.getInstance().userData.appSecretKey.toString() + "/agentRefresh")
            ConnectionManager.subScribeChannel("/" + MyApplication.getInstance().userData.appSecretKey.toString() + "/userMigration")
        }
    }

    private fun onReceivedMessage(msg: String?, channel: String?) {
        Log.e("MainActivity", ">>>>>>>>>>>>>>>>>>>>>>>>FuguMessage: $msg")
        if (TextUtils.isEmpty(msg))
            return

        try {
            val jsonObject = JSONObject(msg)
            if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.TEXT_MESSAGE) {
                if(channel.equals("/" + MyApplication.getInstance().userData.userChannel.toString())) {
                    if (jsonObject.optInt("message_type", 0) == 15 || jsonObject.optInt("message_type", 0) == 17) {
                        val intent = Intent("custom-event-name")
                        // You can also include some extra data.
                        intent.putExtra("message", msg)
                        intent.putExtra("channel_id", channel)
                        intent.putExtra("message_type", jsonObject.optInt("message_type", 0))
                        androidx.localbroadcastmanager.content.LocalBroadcastManager.getInstance(this).sendBroadcast(intent)

                    }
                    BusProvider.getInstance().post(ReceivedMessage(1, jsonObject))
                }
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.ASSIGN_CHAT) {
                BusProvider.getInstance().post(ReceivedMessage(5, jsonObject))
                //getHomeFragment().setControlChannelData(jsonObject)
                val iRec = Intent(FuguChatActivity.RECIEVER_MSG)
                iRec.putExtra(FuguAppConstant.NOTIFICATION_TYPE, 3)
                iRec.putExtra("msgData", msg)
                //iRec.putExtra("data", tvTitle.getText().toString())
                sendBroadcast(iRec)
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.AGENT_STATUS_CHANGED || jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.NEW_AGENT_ADDED) {
                val iRec = Intent(FuguChatActivity.RECIEVER_MSG_AGENT_REFRESH)
                sendBroadcast(iRec)
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.READ_MESSAGE && jsonObject.optInt("user_id") != MyApplication.getInstance().userData.userId!!.toInt()) {
                val iRec = Intent(FuguChatActivity.RECIEVER_MSG)
                iRec.putExtra(FuguAppConstant.NOTIFICATION_TYPE, 6)
                sendBroadcast(iRec)
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.USER_MIGRATION) {
                //getHomeFragment().updateList(jsonObject)
                BusProvider.getInstance().post(ReceivedMessage(2, jsonObject))
                val iRec = Intent(FuguChatActivity.MIGRATE_USER)
                iRec.putExtra(FuguAppConstant.NOTIFICATION_TYPE, 7)
                iRec.putExtra("msgData", msg)
                sendBroadcast(iRec)
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.USER_ONLINE) {
                //getHomeFragment().setInRideTill(jsonObject)
                BusProvider.getInstance().post(ReceivedMessage(3, jsonObject))
            } else if (jsonObject.optInt(FuguAppConstant.NOTIFICATION_TYPE) == FuguAppConstant.BOT_ENDED) {
                val intent = Intent("custom-event-name")
                intent.putExtra("message", msg)
                intent.putExtra("channel_id", channel)
                intent.putExtra("message_type", jsonObject.optInt("message_type", 0))
                androidx.localbroadcastmanager.content.LocalBroadcastManager.getInstance(this).sendBroadcast(intent)

                BusProvider.getInstance().post(ReceivedMessage(4, jsonObject))
                //getHomeFragment().setBotInProgress(jsonObject)
            }

        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    var notifiacrionClicked: Boolean = false

    public fun isNotifiacrionClicked() :Boolean {
        return notifiacrionClicked;
    }

    public fun setNotifiacrionClick(flag: Boolean) {
        this.notifiacrionClicked = flag
    }

    fun onPongReceived() {
        try {
            BusProvider.getInstance().post(ConnectionMessage(0))
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    var channelId: String? = ""
    var isFromFilter: Boolean = false
    var conversation: Conversation? = null



    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.home_activity)

        /*try {
            if (HippoConfig.getInstance().getAttributes().isWhitelabel) {
                if (MyApplication.getInstance().userData.isIncompleteTemplate) {
                    startActivity(Intent(this@HomeActivity, SignupOnBoard::class.java))
                    finish()
                } else if (!MyApplication.getInstance().userData.isVerified) {
                    val intent = Intent(this@HomeActivity, SignupOnBoard::class.java)
                    intent.putExtra("unverified", true)
                    startActivity(intent)
                    finish()
                }
            }
        } catch (e: Exception) {
        }*/

        isFromFilter = false

        startHippoService()
        MyApplication.getInstance().isAppOpen = 1
        //setToolbar()

//        if (MyApplication.getInstance().userData.userProperties.termsAndConditions == 0) {
//            showTnCPopup()
//        }

        /*if (MyApplication.getInstance().userData.isAgentOnboardingCompleted) {
            val profileIntent = Intent(this@HomeActivity, ProfileActivity::class.java)
            profileIntent.putExtra(USER_ONBOARD_VALUE, MyApplication.getInstance().userData.agentOnboardingComplete)
            startActivity(profileIntent)
        }*/

        ConnectionManager.initFayeConnection()
        subscribeChannels()

        if (intent.hasExtra(Constants.CONVERSATION)) {
            conversation = Gson().fromJson(intent.getStringExtra(Constants.CONVERSATION), Conversation::class.java)
            if (conversation != null && conversation!!.getChannelId() > 0) {
                notifiacrionClicked = true
                val intent = Intent(this@HomeActivity, FuguChatActivity::class.java)
                intent.putExtra(Constants.CONVERSATION, Gson().toJson(conversation, Conversation::class.java))
                intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_NEW_TASK
                //TODO: 2019-12-30
                //intent.putExtra(GAEvents.CHAT_CLICKED, tvTitle.getText().toString())
                startActivity(intent)
            }
        }

        if (!TextUtils.isEmpty(CommonData.getDeepLinkURI())) {
            val data = CommonData.getDeepLinkURI()
            try {
                val channelsTemp = data.split("/".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()
                channelId = channelsTemp[channelsTemp.size - 1]
                try {
                    val temp = Integer.parseInt(channelId!!)
                } catch (e: Exception) {
                    channelId = ""
                }
            } catch (e: Exception) {
                channelId = ""
            }
        }

        if (savedInstanceState == null) {
            supportFragmentManager.beginTransaction()
                    .replace(R.id.container, LauncherFragment.newInstance())
                    .commitNow()
        }
    }

    override fun updateOnActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {

    }

    override fun getDrawerLayout(): View {
        return mainLayout
    }

    override fun showUpdate(flag: Boolean) {

    }

    override fun onStart() {
        super.onStart()
        BusProvider.getInstance().register(this);
    }

    override fun onStop() {
        super.onStop()
        BusProvider.getInstance().unregister(this);
    }

    override fun onResume() {
        super.onResume()
        BusProvider.getInstance().post(OnResume())
    }

    override fun onBackPressed() {
        if(pagerPosition == 0) {
            super.onBackPressed()
            //finishAffinity()
        } else {
            BusProvider.getInstance().post(FragmentEvent(3, 0))
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        MyApplication.getInstance().isAppOpen = null
    }

    @Subscribe public fun onUpdateEvent(event: UpdateEvent) {
        when(event.type) {
            //1 -> showForceUpdate()
            //2 -> softupdate()
            //3 -> showTnCPopup()
            4 -> pagerPosition(event.position)
            else -> {

            }
        }
    }

    var pagerPosition = 0
    private fun pagerPosition(pagerPosition: Int) {
        this.pagerPosition = pagerPosition
    }


    private fun startHippoService() {
        try {
            startService(HippoService.createIntent(this))
        } catch (e: Exception) {
            try {
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                    startForegroundService(HippoService.createIntent(this))
                }
            } catch (e1: Exception) {
                e1.printStackTrace()
            }

        }
    }

    fun reconnect() {

    }

    fun openChannelConversation(getConversationResponse: GetConversationResponse) {
        try {
            for (i in 0 until getConversationResponse.data.conversation.size) {
                if (channelId.equals(getConversationResponse.data.conversation[i].channelId.toString(), ignoreCase = true)) {
                    conversation = getConversationResponse.data.conversation[i]
                    val chatIntent = Intent(this@HomeActivity, FuguChatActivity::class.java)
                    chatIntent.putExtra(Constants.CONVERSATION, Gson().toJson(conversation, Conversation::class.java))
                    startActivityForResult(chatIntent, 100)
                    break
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

        channelId = null
    }

    @Subscribe
    public fun onFayeMessage(events: FayeMessage) {
        when(events.type) {
            BusEvents.CONNECTED_SERVER.toString()       -> subscribeChannels()
            BusEvents.RECEIVED_MESSAGE.toString()       -> onReceivedMessage(events.message, events.channelId)
            BusEvents.PONG_RECEIVED.toString()          -> onPongReceived()
        }
    }

}