package com.hippoagent.activities

import android.os.Bundle
import com.hippoagent.R
import com.hippoagent.fragments.HistoryFragment
import kotlinx.android.synthetic.main.activity_payment.*

/**
 * Created by gurmail on 15/05/19.
 * @author gurmail
 */
class HistoryActivity : FuguBaseActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_payment)

        setSupportActionBar(my_toolbar)
        setToolbar(my_toolbar, "History")

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        onHistoryFragment(intent.getIntExtra("channelId", 0),
                intent.getIntExtra("searchUserId", 0))
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onDestroy() {
        super.onDestroy()

    }

    override fun onBackPressed() {
        if(supportFragmentManager.backStackEntryCount < 2) {
            finish()
        } else {
            super.onBackPressed()
        }

    }

    private fun onHistoryFragment(channelId: Int, searchUserId: Int) {
        var fragment = HistoryFragment()
        val bundle = Bundle()
        bundle.putInt("channelId", channelId)
        bundle.putInt("searchUserId", searchUserId)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, HistoryFragment::class.java.simpleName)
                .addToBackStack(HistoryFragment::class.java.simpleName)
                .commitAllowingStateLoss()
    }
}