package com.hippoagent.activities

import android.os.Bundle
import android.view.View
import com.hippoagent.R
import com.hippoagent.fragments.LoggerFragment
import kotlinx.android.synthetic.main.activity_database_logs.*

/**
 * Created by gurmail on 21/05/19.
 * @author gurmail
 */
class DatabaseLogs : FuguBaseActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_database_logs)

        setSupportActionBar(my_toolbar)
        setToolbar(my_toolbar, "Log Info")

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        logsBtn.setOnClickListener {
            loadLoggerFiles()
        }

        dataBtn.setOnClickListener {
            loadDataFolder()
        }

    }

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onBackPressed() {
        if(supportFragmentManager.backStackEntryCount < 2) {
            finish()
        } else {
            btnLayout.visibility = View.VISIBLE
            super.onBackPressed()
        }

    }

    private fun loadLoggerFiles() {
        var fragment = LoggerFragment()
        val bundle = Bundle()
        bundle.putInt("type", 1)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, LoggerFragment::class.java.simpleName)
                .addToBackStack(LoggerFragment::class.java.simpleName)
                .commitAllowingStateLoss()

        btnLayout.visibility = View.GONE
    }



    private fun loadDataFolder() {
        var fragment = LoggerFragment()
        val bundle = Bundle()
        bundle.putInt("type", 2)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, LoggerFragment::class.java.simpleName)
                .addToBackStack(LoggerFragment::class.java.simpleName)
                .commitAllowingStateLoss()


        btnLayout.visibility = View.GONE
    }
}