package com.hippoagent;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;

import androidx.core.app.NotificationCompat;

import com.google.gson.Gson;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.utils.SPLabels;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

import io.paperdb.Paper;
import kotlin.jvm.Synchronized;

import static com.hippoagent.fcm.NotificationUtils.NOTIFICATION_CHANNEL_ID;

/**
 * Created by gurmail on 2020-05-01.
 *
 * @author gurmail
 */
public class HippoNotificationConfig {
    private static String TAG = HippoNotificationConfig.class.getSimpleName();
    UserData userData;

    private NotificationUtils notificationUtils;
    Context mcontext;

    public boolean isHippoNotification(@NotNull Context applicationContext, @NotNull Map<String, String> data) {
        mcontext= applicationContext;
        if (data.containsKey("push_source") && data.get("push_source").equalsIgnoreCase("FUGU")) {
            return true;
        } else
            return false;
    }

    public void showNotification(@Nullable Context applicationContext, @NotNull Map<String, String> data) {
        JSONObject object = null;
        try {
            object = new JSONObject(data.get("message"));
            handleDataMessage(applicationContext, object);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle != null) {
            new Handler().postDelayed(() -> {
                FuguConversation conversation = new Gson().fromJson(bundle.getString(FuguAppConstant.CONVERSATION), FuguConversation.class);
                if (conversation != null && HippoConfig.getInstance() != null) {
                    Log.e(TAG, "conversation: " + new Gson().toJson(conversation));
                    Intent conversationIntent = new Intent(context, FuguChatActivity.class);
                    if (conversation.getChannelId() < 0 && conversation.getLabelId() < 0) {
                        conversationIntent = new Intent(context, HomeActivity.class);
                    }
                    conversationIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    context.startActivity(conversationIntent);
                }
            }, 400);
        }
    }

    private UserData getUserData() {
        if (userData == null) {
            userData = Paper.book(CommonData.name).read(SPLabels.USER_DATA);
        }
        return userData;
    }


    private void handleDataMessage(android.content.@Nullable Context context, JSONObject data) {
        try {
            //JSONObject data = json.getJSONObject("message");

            try {
                if (getUserData() != null && getUserData().isVideoCallEnabled() && data.optInt("notification_type") == 14
                        && (data.optString("video_call_type").equalsIgnoreCase("START_CALL")
                        || (data.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP")))) {
                    videoCallPush(context, data);
                    return;
                } else if(data.optInt("notification_type") == 14) {
                    return;
                }  else if(getUserData() != null && getUserData().isVideoCallEnabled() && data.optInt("notification_type") == 20) {
                    HippoConfCallPush(context, data);
                } else if(data.optInt("notification_type") == 21) {
                    int channedId = data.optInt("channel_id", -1);
                    if(channedId>0)
                        NotificationUtils.clearNotifications(context, channedId);
                    checkConnection(context);
                } else if(data.optInt("notification_type") == 23) {
                    new PushHandler().notificationMissedCall(context, data);
                    checkConnection(context);
                } else {
                    int channedId = data.optInt("channel_id", -1);
                    if (FuguChatActivity.pushChannelId != channedId && channedId > 0) {
                        new PushHandler().notificationHelper(context, data);
                    }
                    checkConnection(context);
                    return;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        } catch (Exception e) {
            Log.e(TAG, "Json Exception: " + e.getMessage());
        }
    }

    @Synchronized
    private void checkConnection(Context context) {
        if(ConnectionUtils.INSTANCE.isAppRunning(context)) {
            ConnectionManager.INSTANCE.onInitialized();
        }
    }

    /**
     * Showing notification with text only
     */
    private void showNotificationMessage(Context context, String title, String message,
                                         String timeStamp, Intent intent, int channedId, int userId, int disableReply) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        if (channedId != -1)
            intent.putExtra("channed_id", channedId);
        if (userId != -1)
            intent.putExtra("user_id", userId);
        intent.putExtra("disable_reply", disableReply);
        notificationUtils.showNotificationMessage(title, message, timeStamp, intent, channedId);
    }

    /**
     * Showing notification with text and image
     */
    private void showNotificationMessageWithBigImage(Context context, String title, String message,
                                                     String timeStamp, Intent intent, String imageUrl,
                                                     int channedId, int userId, int disableReply) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        if (channedId != -1)
            intent.putExtra("channed_id", channedId);
        if (userId != -1)
            intent.putExtra("user_id", userId);
        intent.putExtra("disable_reply", disableReply);
        notificationUtils.showNotificationMessage(title, message, timeStamp, intent, imageUrl, channedId);
    }


    private void playSound() {
        /*if (CommonData.isBkUser()) {
            Intent intent = new Intent(this, AudioPlay.class);
            intent.putExtra("type", AppManager.AudioType.START);
            intent.putExtra("time", BK_SOUND_TIME);
            startService(intent);
        }*/
    }

    private void videoCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onNotificationReceived(context, jsonObject);
    }

    private void HippoConfCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onConfNotificationReceived(context, jsonObject);
    }

    public void setNotificationSoundEnabled(boolean isSoundEnbled) {
        if (isSoundEnbled){
            notificationUtils = new NotificationUtils(mcontext);
            notificationUtils.playNotificationSound();
        }


    }

    public void setPriority(int priority) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(mcontext, NOTIFICATION_CHANNEL_ID);
        builder.setPriority(priority);
    }

    public void setSmallIcon(int icLauncher) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(mcontext, NOTIFICATION_CHANNEL_ID);
        builder.setSmallIcon(icLauncher);
    }
}

