package com.hippoagent;

import android.app.Activity;
import android.content.Intent;
import android.text.TextUtils;

import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.LoginApi;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.apis.HippoLogout;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.database.CommonData;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import io.paperdb.Paper;


/**
 * Created by gurmail on 2020-04-30.
 *
 * @author gurmail
 */
public class HippoConfig {
    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private final static String PAPER_BOOK = "hippo_agent_sdk";
    private Activity activity;

    public HippoConfig() {

    }

    public static HippoConfig getInstance() {
        if(hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    public static void initHippoConfig(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        HippoConfig.getInstance().configAttributes = configAttributes;
        CommonData.saveAttributes(configAttributes);
        HippoConfig.getInstance().activity = activity;

        //Paper.book(CommonData.name).write(SPLabels.SERVER_SELECTED, FAYE_ALPHA_SERVER_URL);
        MyApplication.getInstance().initializeServerURL();


        loginHippoAgent(activity, configAttributes, callback);
    }

    public void openMainScreen(@NotNull Activity activity) {
        if(MyApplication.getInstance().getUserData() != null)
            activity.startActivity(new Intent(activity, HomeActivity.class));
        else
            Log.e("HippoConfig", "Need to login first");
    }

    public void openSavedReply(Activity activity) {
        if(MyApplication.getInstance().getUserData() != null && MyApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed()) {
            Intent planIntent = new Intent(activity, PlansActivity.class);
            activity.startActivity(planIntent);
        } else {
            Log.e("Error", "Feature not available");
        }
    }

    public void openBroadcast(@NotNull Activity activity) {
        if(MyApplication.getInstance().getUserData() != null)
            activity.startActivity(new Intent(activity, BroadcastListActivity.class));
        else
            Log.e("HippoConfig", "Need to login first");
    }

    public void logoutHippo(Activity activity) {
        HippoLogout.INSTANCE.logout(activity);
    }

    private HippoConfigAttributes configAttributes;

    public HippoConfigAttributes getAttributes() {
        if(configAttributes == null) {
            configAttributes = CommonData.getConfigAttributes();
        }
        return configAttributes;
    }

    private static void loginHippoAgent(Activity activity, HippoConfigAttributes configAttributes, LoginCallback callback) {
        LoginApi.INSTANCE.login(activity, configAttributes, new LoginApiCallBack() {
            @Override
            public void onErrorMessage(@NotNull LoginResponse t) {
                callback.onError();
            }

            @Override
            public void onApiSuccess(@NotNull LoginResponse t) {
                openChannel();
                callback.success();
            }

            @Override
            public void onApiFailed(@Nullable APIError error) {
                callback.failed();
            }

            @Override
            public void singleBtnUpdateWindow(@NotNull LoginResponse t) {
                openChannel();
                callback.success();
            }

            @Override
            public void showUpdateWindowTwoBtns(@NotNull LoginResponse t) {
                openChannel();
                callback.success();
            }
        }, false, true);
    }

    private static void openChannel() {
        ConnectionManager.INSTANCE.initFayeConnection();
        if (MyApplication.getInstance().getUserData() != null && !TextUtils.isEmpty(MyApplication.getInstance().getUserData().getUserChannel())) {
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getUserChannel());
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/agentsRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/agentRefresh");
            ConnectionManager.INSTANCE.subScribeChannel("/" + MyApplication.getInstance().getUserData().getAccessToken() + "/userMigration");
        }
    }

}
