/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.widget.TextView;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.filepicker.FolderListHelper;
import java.util.List;

public abstract class BaseActivity
extends AppCompatActivity
implements FuguAppConstant,
EasyPermissions.PermissionCallbacks {
    private static final String TAG = BaseActivity.class.getName();
    protected FolderListHelper mFolderHelper;
    protected boolean isNeedFolderList;
    public static final String IS_NEED_FOLDER_LIST = "isNeedFolderList";

    protected abstract void permissionGranted();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isNeedFolderList = this.getIntent().getBooleanExtra(IS_NEED_FOLDER_LIST, false);
        if (this.isNeedFolderList) {
            this.mFolderHelper = new FolderListHelper();
            this.mFolderHelper.initFolderListView((Context)this);
        }
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.readExternalStorage();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @AfterPermissionGranted(value=123)
    private void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            this.permissionGranted();
        } else {
            EasyPermissions.requestPermissions((Activity)this, this.getString(R.string.vw_rationale_storage), 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + requestCode + ":" + perms.size()));
        this.permissionGranted();
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + requestCode + ":" + perms.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, perms)) {
            new AppSettingsDialog.Builder((Activity)this).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 16061) {
            if (EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1) {
                ab.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());
            }
            ab.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }
}

