/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public abstract class EndlessScrollListener
extends RecyclerView.OnScrollListener {
    RecyclerView.LayoutManager mLayoutManager;
    private int visibleThreshold = 5;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private int startingPageIndex = 0;

    public EndlessScrollListener(LinearLayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        int lastVisibleItemPosition = 0;
        int totalItemCount = this.mLayoutManager.getItemCount();
        lastVisibleItemPosition = ((LinearLayoutManager)this.mLayoutManager).findFirstVisibleItemPosition();
        if (totalItemCount < this.previousTotalItemCount) {
            this.currentPage = this.startingPageIndex;
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
        }
        if (!this.loading && lastVisibleItemPosition - this.visibleThreshold == 0) {
            ++this.currentPage;
            this.onLoadMore(this.currentPage, totalItemCount);
            this.loading = true;
        }
    }

    public abstract void onLoadMore(int var1, int var2);
}

