/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.hippo.R;

public class CustomAlertDialog {
    public CustomAlertDialog(Builder builder) {
    }

    public static class Builder {
        private final Context mContext;
        private final LayoutInflater mInflater;
        private CharSequence mTitle;
        private CharSequence mMessage;
        private CharSequence mPositiveButtonText;
        private CustomDialogInterface.OnClickListener mPositiveButtonListener;
        private CharSequence mNegativeButtonText;
        private CustomDialogInterface.OnClickListener mNegativeButtonListener;
        private boolean mCancelable;
        private CustomDialogInterface.OnCancelListener mOnCancelListener;
        private CustomDialogInterface.OnDismissListener mOnDismissListener;
        private AlertDialog.Builder mBuilder;
        private AlertDialog mAlertDialog;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getText(messageId);
            return this;
        }

        public Builder setMessage(@Nullable CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public Builder setPositiveButton(@StringRes int textId, CustomDialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = this.mContext.getText(textId);
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, CustomDialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = text;
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int textId, CustomDialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = this.mContext.getText(textId);
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, CustomDialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = text;
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public Builder setOnCancelListener(CustomDialogInterface.OnCancelListener onCancelListener) {
            this.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(CustomDialogInterface.OnDismissListener onDismissListener) {
            this.mOnDismissListener = onDismissListener;
            return this;
        }

        public AlertDialog create() {
            this.mBuilder = new AlertDialog.Builder(this.mContext);
            View dialogView = this.mInflater.inflate(R.layout.hippo_dialog_custom, null);
            this.mBuilder.setView(dialogView);
            this.mAlertDialog = this.mBuilder.create();
            TextView tvTitle = (TextView)dialogView.findViewById(R.id.tvTitle);
            TextView tvMessage = (TextView)dialogView.findViewById(R.id.tvMessage);
            Button btnNegative = (Button)dialogView.findViewById(R.id.btnNegative);
            Button btnPositive = (Button)dialogView.findViewById(R.id.btnPositive);
            if (this.mTitle != null) {
                tvTitle.setText(this.mTitle);
            } else {
                tvTitle.setVisibility(8);
            }
            if (this.mMessage != null) {
                tvMessage.setText(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                btnPositive.setText(this.mPositiveButtonText);
                btnPositive.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Builder.this.mAlertDialog.dismiss();
                        if (Builder.this.mPositiveButtonListener != null) {
                            Builder.this.mPositiveButtonListener.onClick();
                        }
                    }
                });
            } else {
                btnPositive.setVisibility(8);
            }
            if (this.mNegativeButtonText != null) {
                btnNegative.setText(this.mNegativeButtonText);
                btnNegative.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Builder.this.mAlertDialog.dismiss();
                        if (Builder.this.mNegativeButtonListener != null) {
                            Builder.this.mNegativeButtonListener.onClick();
                        }
                    }
                });
            } else {
                btnNegative.setVisibility(8);
            }
            this.mAlertDialog.setCancelable(this.mCancelable);
            this.mAlertDialog.setCanceledOnTouchOutside(this.mCancelable);
            if (this.mOnCancelListener != null) {
                this.mAlertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        if (Builder.this.mOnCancelListener != null) {
                            Builder.this.mOnCancelListener.onCancel();
                        }
                    }
                });
            }
            if (this.mOnDismissListener != null) {
                this.mAlertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        if (Builder.this.mOnDismissListener != null) {
                            Builder.this.mOnDismissListener.onDismiss();
                        }
                    }
                });
            }
            return this.mAlertDialog;
        }

        public AlertDialog show() {
            AlertDialog dialog = this.create();
            dialog.show();
            return dialog;
        }

        public CustomAlertDialog build() {
            return new CustomAlertDialog(this);
        }
    }

    public static interface CustomDialogInterface {

        public static interface OnCancelListener {
            public void onCancel();
        }

        public static interface OnDismissListener {
            public void onDismiss();
        }

        public static interface OnClickListener {
            public void onClick();
        }
    }
}

