/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import java.io.IOException;

public class CommonMediaPlayer {
    private static CommonMediaPlayer instance;
    private static MediaPlayer mediaPlayer;

    private CommonMediaPlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonMediaPlayer getInstance() {
        if (instance != null) return instance;
        Class<CommonMediaPlayer> clazz = CommonMediaPlayer.class;
        synchronized (CommonMediaPlayer.class) {
            if (instance != null) return instance;
            instance = new CommonMediaPlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void playMediaPlayer(Context context, String fileUrl, final MediaPlayerStatus mediaPlayerStatus) {
        Uri myUri = Uri.parse((String)fileUrl);
        if (mediaPlayer != null) {
            if (mediaPlayer.isPlaying()) {
                mediaPlayer.stop();
            }
            mediaPlayer.release();
            mediaPlayer = null;
        }
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(3);
        try {
            mediaPlayer.setDataSource(context, myUri);
            mediaPlayer.prepareAsync();
            mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    mediaPlayer = mp;
                    mediaPlayer.start();
                    mediaPlayerStatus.onPlaying();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                mediaPlayerStatus.onCompletion(mp);
            }
        });
        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                mediaPlayerStatus.onError(mp, what, extra);
                return true;
            }
        });
    }

    public void stopMedia() {
        try {
            if (mediaPlayer != null) {
                mediaPlayer.stop();
                mediaPlayer.reset();
                mediaPlayer.release();
                mediaPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface MediaPlayerStatus {
        public void onPlaying();

        public void onCompletion(MediaPlayer var1);

        public void onError(MediaPlayer var1, int var2, int var3);
    }
}

