/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.database;

import com.hippo.agent.database.AgentPaperDbConstant;
import com.hippo.agent.model.FuguAgentGetMessageResponse;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.LoginModel.Tag;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.Message;
import com.hippo.agent.model.UnreadCountData;
import com.hippo.model.FuguConversation;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONObject;

public final class AgentCommonData
implements AgentPaperDbConstant {
    public static final String PACKAGENAME = "HIPPO_PACKAGENAME";
    public static List<FuguConversation> CONVERSATION_LIST = Collections.emptyList();
    public static HashMap<Integer, FuguAgentGetMessageResponse> GET_MESSAGE_RESPONSE_MAP = new HashMap();
    public static UserData userData;
    private static HashMap<String, UnreadCountData> UNREAD_COUNT;
    private static HashMap<Integer, Integer> TOTAL_UNREAD_COUNT;
    public static HashMap<Long, LinkedHashMap<String, JSONObject>> UNSENT_MESSAGE_JSON;
    public static HashMap<Long, LinkedHashMap<String, ListItem>> SENT_MESSAGES;
    public static HashMap<Long, LinkedHashMap<String, ListItem>> UNSENT_MESSAGES;

    private AgentCommonData() {
    }

    public static void setMainTitle(String title) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_title", (Object)title);
    }

    public static String getMainTitle() {
        return (String)Paper.book((String)"hippo.paperdb").read("hippo_agent_title", (Object)"Support Chat");
    }

    public static void saveUserData(UserData userData1) {
        userData = new UserData();
        userData = userData1;
        Paper.book((String)"hippo.paperdb").write("hippo_user_data", (Object)userData1);
    }

    public static UserData getUserData() {
        if (userData == null) {
            try {
                userData = (UserData)Paper.book((String)"hippo.paperdb").read("hippo_user_data");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userData;
    }

    public static void saveTags(List<Tag> tags) {
        Paper.book((String)"hippo.paperdb").write("hippo_tags", tags);
    }

    public static void setAgentLoginInit(boolean init) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_login_init", (Object)init);
    }

    public static boolean isAgentFlow() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_agent_login_init", (Object)false);
    }

    public static void setAgentMessageResponse(Integer channelId, FuguAgentGetMessageResponse getMessageResponse) {
        GET_MESSAGE_RESPONSE_MAP.put(channelId, getMessageResponse);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_get_message_response_map", GET_MESSAGE_RESPONSE_MAP);
    }

    public static void setAgentMessagesToMessageMap(Integer channelId, ArrayList<Message> messages) {
        if (GET_MESSAGE_RESPONSE_MAP.get(channelId) != null && GET_MESSAGE_RESPONSE_MAP.get(channelId).getData() != null) {
            GET_MESSAGE_RESPONSE_MAP.get(channelId).getData().setMessages(messages);
            Paper.book((String)"hippo.paperdb").write("hippo_agent_get_message_response_map", GET_MESSAGE_RESPONSE_MAP);
        }
    }

    public static FuguAgentGetMessageResponse getAgentMessageResponse(Integer channelId) {
        try {
            if (GET_MESSAGE_RESPONSE_MAP.isEmpty()) {
                GET_MESSAGE_RESPONSE_MAP = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_get_message_response_map", new HashMap());
            }
            return GET_MESSAGE_RESPONSE_MAP.get(channelId);
        }
        catch (Exception e) {
            Paper.book((String)"hippo.paperdb").delete("hippo_agent_get_message_response_map");
            return new FuguAgentGetMessageResponse();
        }
    }

    public static void setAgentConversationList(Integer fragmentType, ArrayList<Object> conversationChatList) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_conversation_list" + fragmentType, conversationChatList);
    }

    public static ArrayList<Object> getAgentConversationList(Integer fragmentType) {
        try {
            return (ArrayList)Paper.book((String)"hippo.paperdb").read("hippo_agent_conversation_list" + fragmentType, new ArrayList());
        }
        catch (Exception e) {
            Paper.book((String)"hippo.paperdb").delete("hippo_agent_conversation_list" + fragmentType);
            return new ArrayList<Object>();
        }
    }

    public static boolean getPagerOrder() {
        return (Boolean)Paper.book((String)"hippo.paperdb").read("hippo_agent_pager_order", (Object)false);
    }

    public static void setPagerOrder(boolean order) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_pager_order", (Object)order);
    }

    public static HashMap<String, UnreadCountData> getUnreadCount() {
        UNREAD_COUNT = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_unread_count", new HashMap());
        return UNREAD_COUNT;
    }

    public static void addAllUnreadCount(HashMap<String, UnreadCountData> hashMap) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_unread_count", hashMap);
    }

    public static UnreadCountData getUnreadCount(String userUniqueKey) {
        return AgentCommonData.getUnreadCount().get(userUniqueKey);
    }

    public static HashMap<String, UnreadCountData> addUnreadCount(String userUniqueKey, UnreadCountData unreadCountData) {
        UNREAD_COUNT = AgentCommonData.getUnreadCount();
        UNREAD_COUNT.put(userUniqueKey, unreadCountData);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_unread_count", UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static HashMap<String, UnreadCountData> removeUnreadCount(String userUniqueKey) {
        UNREAD_COUNT = AgentCommonData.getUnreadCount();
        UNREAD_COUNT.remove(userUniqueKey);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_unread_count", UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static void clearUnreadCount() {
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_unread_count");
    }

    public static HashMap<Integer, Integer> getTotalUnreadCount() {
        TOTAL_UNREAD_COUNT = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_all_unread_count", new HashMap());
        return TOTAL_UNREAD_COUNT;
    }

    public static void addTotalUnreadCount(HashMap<Integer, Integer> hashMap) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_all_unread_count", hashMap);
    }

    public static Integer getTotalUnreadCount(Integer channelId) {
        return AgentCommonData.getTotalUnreadCount().get(channelId);
    }

    public static HashMap<Integer, Integer> addTotalUnreadCount(Integer channelId, Integer count) {
        TOTAL_UNREAD_COUNT = AgentCommonData.getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.put(channelId, count);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_all_unread_count", TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static HashMap<Integer, Integer> removeTotalUnreadCount(Integer channelId) {
        TOTAL_UNREAD_COUNT = AgentCommonData.getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.remove(channelId);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_all_unread_count", TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static void clearTotalUnreadCount() {
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_all_unread_count");
    }

    public static ArrayList<String> getAgentUniqueKey() {
        return (ArrayList)Paper.book((String)"hippo.paperdb").read("hippo_agent_list", null);
    }

    public static void setAgentUniqueKey(ArrayList<String> strings) {
        Paper.book((String)"hippo.paperdb").write("hippo_agent_list", strings);
    }

    public static void clearAgentData() throws Exception {
        CONVERSATION_LIST = Collections.emptyList();
        GET_MESSAGE_RESPONSE_MAP = new HashMap();
        userData = new UserData();
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_conversation_list");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_get_message_response_map");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_unsent_message_map");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_login_init");
        Paper.book((String)"hippo.paperdb").delete("hippo_user_data");
        Paper.book((String)"hippo.paperdb").delete("hippo_tags");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_list");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_title");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_pager_order");
        Paper.book((String)"hippo.paperdb").delete("hippo_agent_unread_count");
        Paper.book((String)"hippo.paperdb").destroy();
    }

    public static void setUnsentMessageMapByChannel(Long uniqueId, LinkedHashMap<String, JSONObject> unsentMessageMap) {
        UNSENT_MESSAGE_JSON = AgentCommonData.getUnsentMessageMap();
        if (unsentMessageMap != null && unsentMessageMap.values().size() > 0) {
            UNSENT_MESSAGE_JSON.put(uniqueId, unsentMessageMap);
            Paper.book((String)"hippo.paperdb").write("hippo_agent_unsent_message_map", UNSENT_MESSAGE_JSON);
        }
    }

    public static void removeUnsentMessageMapChannel(Long channelId) {
        UNSENT_MESSAGE_JSON = AgentCommonData.getUnsentMessageMap();
        UNSENT_MESSAGE_JSON.remove(channelId);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_unsent_message_map", UNSENT_MESSAGE_JSON);
    }

    public static LinkedHashMap<String, JSONObject> getUnsentMessageMapByChannel(Long channelId) {
        UNSENT_MESSAGE_JSON = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_unsent_message_map", new HashMap());
        return UNSENT_MESSAGE_JSON.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, JSONObject>> getUnsentMessageMap() {
        UNSENT_MESSAGE_JSON = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_unsent_message_map", new HashMap());
        return UNSENT_MESSAGE_JSON;
    }

    public static void setAllUnsentMessageByChannel(LinkedHashMap<String, ListItem> unsentMessage) {
        Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", unsentMessage);
    }

    public static void setUnsentMessageByChannel(Long channelId, LinkedHashMap<String, ListItem> unsentMessage) {
        UNSENT_MESSAGES = AgentCommonData.getUnsentMessages();
        if (unsentMessage != null && unsentMessage.values().size() > 0) {
            UNSENT_MESSAGES.put(channelId, unsentMessage);
            Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", UNSENT_MESSAGES);
        }
    }

    public static void removeUnsentMessageChannel(Long channelId) {
        UNSENT_MESSAGES = AgentCommonData.getUnsentMessages();
        UNSENT_MESSAGES.remove(channelId);
        Paper.book((String)"hippo.paperdb").write("hippo_unsent_messages", UNSENT_MESSAGES);
    }

    public static LinkedHashMap<String, ListItem> getUnsentMessageByChannel(Long channelId) {
        UNSENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_unsent_messages", new HashMap());
        return UNSENT_MESSAGES.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, ListItem>> getUnsentMessages() {
        UNSENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_unsent_messages", new HashMap());
        return UNSENT_MESSAGES;
    }

    public static void addExistingMessages(Long channelId, LinkedHashMap<String, ListItem> sentMessage) {
        LinkedHashMap<String, ListItem> allSentMessages = AgentCommonData.getSentMessageByChannel(channelId);
        allSentMessages.putAll(sentMessage);
        AgentCommonData.setSentMessageByChannel(channelId, allSentMessages);
    }

    public static void setSentMessageByChannel(Long channelId, LinkedHashMap<String, ListItem> sentMessage) {
        SENT_MESSAGES = AgentCommonData.getSentMessages();
        SENT_MESSAGES.put(channelId, sentMessage);
        Paper.book((String)"hippo.paperdb").write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static void removeSentMessageChannel(Long channelId) {
        SENT_MESSAGES = AgentCommonData.getSentMessages();
        SENT_MESSAGES.remove(channelId);
        Paper.book((String)"hippo.paperdb").write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static LinkedHashMap<String, ListItem> getSentMessageByChannel(Long channelId) {
        SENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_sent_messages", new HashMap());
        return SENT_MESSAGES.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, ListItem>> getSentMessages() {
        SENT_MESSAGES = (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_sent_messages", new HashMap());
        return SENT_MESSAGES;
    }

    public static HashMap<Long, ArrayList<Integer>> getAllNotificationChannels() {
        return (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_sdk_notifications", new HashMap());
    }

    public static ArrayList<Integer> getNotificationArray(Long channelId) {
        HashMap<Long, ArrayList<Integer>> hashMap = AgentCommonData.getAllNotificationChannels();
        return hashMap.get(channelId);
    }

    public static void saveNotificationId(Long channelId, Integer notificationChannel) {
        ArrayList<Integer> ids = AgentCommonData.getNotificationArray(channelId);
        if (ids == null || ids.size() == 0) {
            ids = new ArrayList();
        }
        ids.add(notificationChannel);
        HashMap<Long, ArrayList<Integer>> hashMap = AgentCommonData.getAllNotificationChannels();
        hashMap.put(channelId, ids);
        Paper.book((String)"hippo.paperdb").write("hippo_sdk_notifications", hashMap);
    }

    public static void removeNotificationChannel(Long channelId) {
        HashMap<Long, ArrayList<Integer>> hashMap = AgentCommonData.getAllNotificationChannels();
        hashMap.remove(channelId);
        Paper.book((String)"hippo.paperdb").write("hippo_sdk_notifications", hashMap);
    }

    public static void removeAllNotificationChannel() {
        Paper.book((String)"hippo.paperdb").delete("hippo_sdk_notifications");
    }

    public static HashMap<Long, FuguAgentGetMessageResponse> getAgentData() {
        return (HashMap)Paper.book((String)"hippo.paperdb").read("hippo_agent_name_data", new HashMap());
    }

    public static FuguAgentGetMessageResponse getSingleAgentData(Long channelId) {
        HashMap<Long, FuguAgentGetMessageResponse> agentNameData = AgentCommonData.getAgentData();
        return agentNameData.get(channelId);
    }

    public static void saveVideoCallAgent(Long channelId, FuguAgentGetMessageResponse agentName) {
        HashMap<Long, FuguAgentGetMessageResponse> agentNameData = AgentCommonData.getAgentData();
        agentNameData.put(channelId, agentName);
        Paper.book((String)"hippo.paperdb").write("hippo_agent_name_data", agentNameData);
    }

    public static boolean getVideoCallStatus() {
        try {
            return AgentCommonData.getUserData().isVideoCallEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getAudioCallStatus() {
        try {
            return AgentCommonData.getUserData().isAudioCallEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        UNREAD_COUNT = new HashMap();
        TOTAL_UNREAD_COUNT = new HashMap();
        UNSENT_MESSAGE_JSON = new HashMap();
        SENT_MESSAGES = new HashMap();
        UNSENT_MESSAGES = new HashMap();
    }
}

