/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.model.broadcastResponse.Tag;
import com.hippo.database.CommonData;
import java.util.List;

public class ListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<Tag> arrayList;
    private LayoutInflater inflater;
    private SelectedId selectedId;
    private HippoColorConfig hippoColorConfig;

    public ListAdapter(Context context, List<Tag> arrayList, SelectedId selectedId) {
        this.arrayList = arrayList;
        this.selectedId = selectedId;
        this.inflater = LayoutInflater.from((Context)context);
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Tag data = this.arrayList.get(position);
        holder.textView.setText((CharSequence)data.getTagName());
        holder.textView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        holder.radioButton.setChecked(data.isSelected());
        holder.textView.setTypeface(null, 0);
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public static interface SelectedId {
        public void selectedTeamId(int var1, Tag var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RadioButton radioButton;
        LinearLayout mainLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)itemView.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.main_layout);
            this.radioButton.setVisibility(0);
            this.checkBox.setVisibility(8);
            this.radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (buttonView.isPressed()) {
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = ViewHolder.this.getAdapterPosition();
                    boolean isFlag = false;
                    int id2 = -2;
                    if (pos == 0) {
                        isFlag = true;
                        if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                            isFlag = false;
                        }
                        for (int i = 0; i < ListAdapter.this.arrayList.size(); ++i) {
                            ((Tag)ListAdapter.this.arrayList.get(i)).setSelected(isFlag);
                        }
                        if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                            id2 = -1;
                        }
                        if (ListAdapter.this.selectedId != null) {
                            ListAdapter.this.selectedId.selectedTeamId(id2, (Tag)ListAdapter.this.arrayList.get(0));
                        }
                    } else {
                        if (((Tag)ListAdapter.this.arrayList.get(pos)).isSelected()) {
                            if (((Tag)ListAdapter.this.arrayList.get(0)).isSelected()) {
                                isFlag = true;
                            }
                            for (int i = 0; i < ListAdapter.this.arrayList.size(); ++i) {
                                ((Tag)ListAdapter.this.arrayList.get(i)).setSelected(false);
                            }
                            if (isFlag) {
                                ((Tag)ListAdapter.this.arrayList.get(pos)).setSelected(!((Tag)ListAdapter.this.arrayList.get(pos)).isSelected());
                                id2 = ((Tag)ListAdapter.this.arrayList.get(pos)).getTagId();
                            } else {
                                id2 = -2;
                            }
                        } else {
                            for (int i = 0; i < ListAdapter.this.arrayList.size(); ++i) {
                                ((Tag)ListAdapter.this.arrayList.get(i)).setSelected(false);
                            }
                            ((Tag)ListAdapter.this.arrayList.get(pos)).setSelected(!((Tag)ListAdapter.this.arrayList.get(pos)).isSelected());
                            id2 = ((Tag)ListAdapter.this.arrayList.get(pos)).getTagId();
                        }
                        if (ListAdapter.this.selectedId != null) {
                            ListAdapter.this.selectedId.selectedTeamId(id2, (Tag)ListAdapter.this.arrayList.get(ViewHolder.this.getAdapterPosition()));
                        }
                    }
                    ListAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }
}

