/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.model.broadcastResponse.User;
import com.hippo.database.CommonData;
import java.util.List;

public class FleetListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<User> arrayList;
    private LayoutInflater inflater;
    private int type = 1;
    private HippoColorConfig hippoColorConfig;

    public FleetListAdapter(Context context, int type, List<User> arrayList) {
        this.arrayList = arrayList;
        this.type = type;
        this.inflater = LayoutInflater.from((Context)context);
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.hippo_textview_for_spinner, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        User data = this.arrayList.get(position);
        holder.textView.setText((CharSequence)data.getFullName());
        holder.textView.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
        if (this.type == 3) {
            holder.checkBox.setVisibility(8);
        }
        holder.textView.setTypeface(null, 0);
        holder.checkBox.setChecked(data.isSelected());
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        CheckBox checkBox;
        RadioButton radioButton;
        LinearLayout mainLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)itemView.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.main_layout);
            this.radioButton.setVisibility(8);
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = ViewHolder.this.getAdapterPosition();
                    if (pos == 0) {
                        boolean flag = !((User)FleetListAdapter.this.arrayList.get(0)).isSelected();
                        for (int i = 0; i < FleetListAdapter.this.arrayList.size(); ++i) {
                            ((User)FleetListAdapter.this.arrayList.get(i)).setSelected(flag);
                        }
                    } else {
                        ((User)FleetListAdapter.this.arrayList.get(pos)).setSelected(!((User)FleetListAdapter.this.arrayList.get(pos)).isSelected());
                        if (!((User)FleetListAdapter.this.arrayList.get(pos)).isSelected()) {
                            ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(false);
                        } else {
                            for (int i = 1; i < FleetListAdapter.this.arrayList.size(); ++i) {
                                if (!((User)FleetListAdapter.this.arrayList.get(i)).isSelected()) {
                                    ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(false);
                                    break;
                                }
                                ((User)FleetListAdapter.this.arrayList.get(0)).setSelected(true);
                            }
                        }
                    }
                    FleetListAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }
}

