package com.hippo.utils;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.provider.OpenableColumns;
import android.renderscript.Allocation;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.adapter.FuguAttachmentAdapter;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguFileDetails;
import com.hippo.utils.filepicker.Constant;
import com.hippo.utils.filepicker.Util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;


public class FuguImageUtils implements FuguAppConstant {

    private static final String TAG = FuguImageUtils.class.getSimpleName();
    private Activity activity;

    public FuguImageUtils(Activity activity) {
        this.activity = activity;
    }

    /**
     * Method to start the Camera
     */
    public void startCamera() {
        HippoLog.e(TAG, "startCamera");

        /*  Check whether the Camera feature is available or not    */
        if (!isCameraAvailable()) {
            Toast.makeText(activity, "Camera feature unavailable!", Toast.LENGTH_SHORT).show();
            return;
        }

        /*  Check for the SD CARD or External Storage   */
        if (!isExternalStorageAvailable()) {
            Toast.makeText(activity, "External storage unavailable!", Toast.LENGTH_SHORT).show();
            return;
        }

        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
            String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            String fileName = "Hippochat_" + muid + ".jpg";
            File fileToBeWritten = new File(Util.getDirectoryPath(FOLDER_TYPE.get(IMAGE_FOLDER)), fileName);
            HippoLog.d(TAG, "Path: "+fileToBeWritten.getPath());
            HippoLog.d(TAG, "AbsolutePath: "+fileToBeWritten.getAbsolutePath());
            CommonData.setTime(fileToBeWritten.getAbsolutePath());
            CommonData.setImageMuid(muid);
            try {
                File file = fileToBeWritten.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
//                File fileToBeWritten = new File(Util.getDirectoryPath(FOLDER_TYPE.get(IMAGE_FOLDER)), fileName);
                fileToBeWritten.createNewFile();
                //File image = File.createTempFile(fileName, ".jpg", new File(Util.getDirectoryPath(FOLDER_TYPE.get(IMAGE_FOLDER))));
            } catch (Exception e) {
                e.printStackTrace();
            }
//            if (!fileToBeWritten.exists()) {
//                try {
//                    fileToBeWritten.createNewFile();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
            takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(activity, CommonData.getProvider(), fileToBeWritten));
            activity.startActivityForResult(takePictureIntent, Constant.REQUEST_CODE_TAKE_IMAGE);
        }
    }

    /**
     * Method to check whether the Camera feature
     * is Available or not
     *
     * @return
     */
    private boolean isCameraAvailable() {

        HippoLog.e(TAG, "isCameraAvailable");

        return activity.getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA);
    }

    /**
     * Method to check whether the Camera feature
     * is Available or not
     *
     * @return
     */
    private boolean isExternalStorageAvailable() {

        HippoLog.e(TAG, "isExternalStorageAvailable");

        return Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState());
    }

}
