package com.hippo.agent.adapter;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.media.MediaPlayer;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.widget.*;
import android.text.Html;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.*;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.downloader.*;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.ImageDisplayActivity;
import com.hippo.activity.VideoPlayerActivity;
import com.hippo.adapter.CustomActionButtonsAdapter;
import com.hippo.adapter.CustomActionDescriptionAdapter;
import com.hippo.adapter.FuguMessageAdapter;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.Util.TagContainerLayout;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.CustomAction;
import com.hippo.model.Image;
import com.hippo.utils.*;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.hippo.utils.zoomview.ZoomageView;

import java.io.File;
import java.lang.Error;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.hippo.constant.FuguAppConstant.MESSAGE_DELIVERED;
import static com.hippo.constant.FuguAppConstant.MESSAGE_IMAGE_RETRY;
import static com.hippo.constant.FuguAppConstant.MESSAGE_READ;
import static com.hippo.constant.FuguAppConstant.MESSAGE_SENT;
import static com.hippo.constant.FuguAppConstant.MESSAGE_UNSENT;
import static com.hippo.constant.FuguAppConstant.PRIVATE_NOTE;

/**
 * Created by Bhavya Rattan on 02/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguAgentMessageAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements FuguAppConstant, OnRecyclerListener {

    private static final String TAG = FuguAgentMessageAdapter.class.getSimpleName();
    //private ArrayList<Message> fuguMessageList = new ArrayList<>();
    private AgentChatActivity context;

    private final int TYPE_HEADER = 0;
    private final int ITEM_TYPE_SELF = 2;
    private final int ITEM_ASSIGNMENT = 3;
    private final int FUGU_VIDEO_CALL_VIEW = 18;
    private final int HIPPO_FILE_SENT_VIEW = 10;
    private final int HIPPO_VIDEO_MESSGAE_SELF = 12;
    private final int HIPPO_UNKNOWN_MESSAGE_SELF = -2;

    private final int HIPPO_UNKNOWN_MESSAGE_OTHER = -1;
    private final int ITEM_TYPE_OTHER = 1;
    private final int FUGU_OTHER_VIDEO_CALL_VIEW = 19;
    private final int HIPPO_FILE_RECEIVED_VIEW = 11;
    private final int HIPPO_VIDEO_MESSGAE_OTHER = 13;
    private final int HIPPO_USER_CONCENT_VIEW = 20;

    private DateUtils dateUtil = DateUtils.getInstance();
    private OnRetryListener mOnRetry;
    private HippoColorConfig hippoColorConfig;
    private Conversation conversation;
    private FuguMessageAdapter.onVideoCall onVideoCall;

    private String customerName;
    private String agentName;
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnabled = true;
    private int agentId;

    @NonNull
    private List<ListItem> items = Collections.emptyList();
    private RecyclerView recyclerView;

    public FuguAgentMessageAdapter(AgentChatActivity context, @NonNull List<ListItem> items, RecyclerView recyclerView, Conversation conversation) {

        this.items = items;
        this.recyclerView = recyclerView;
        // this.fuguMessageList = fuguMessageList;
        this.context = context;
        this.hippoColorConfig = CommonData.getColorConfig();
        this.conversation = conversation;
        //removeDefaultMsgTime();
    }

    public void updateList(@NonNull List<ListItem> items) {
        this.items = items;
        //  removeDefaultMsgTime();
    }

    public void setCustomeName(String customeName) {
        this.customerName = customeName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setIsChatAssignToMe(boolean isChatAssignToMe) {
        this.isChatAssignToMe = isChatAssignToMe;
    }

    public void isVideoCallEnabled(boolean isVideoCallEnabled) {
        this.isVideoCallEnabled = isVideoCallEnabled;
    }

    public void setOnVideoCallListener(FuguMessageAdapter.onVideoCall onVideoCall) {
        this.onVideoCall = onVideoCall;
    }

    public void setOnRetryListener(OnRetryListener OnRetryListener) {
        mOnRetry = OnRetryListener;
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = recyclerView.getChildLayoutPosition(parentView);
        if(positionInList!=RecyclerView.NO_POSITION) {
            if(!Utils.preventMultipleClicks()) {
                return;
            }
            Message otherVideoMessage = ((EventItem) items.get(positionInList)).getEvent();
            String fname = Util.getFileName(otherVideoMessage.getFileName(), otherVideoMessage.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(otherVideoMessage.getDocumentType()));
            Intent intent = new Intent(context, VideoPlayerActivity.class);
            intent.putExtra("url", localPath);
            intent.putExtra("title", otherVideoMessage.getFileName());
            context.startActivity(intent);
        }
    }

    public interface OnRetryListener {
        public void onRetry(String file, String fileType, final int messageIndex, String muid);
        public void onMessageRetry(String muid, int position);
        public void onMessageCancel(String muid, int position);
        void onFileMessageRetry(String muid, int position);
    }

//    public void setAgentName(String agentName) {
//        this.agentName = agentName;
//    }

    private void removeDefaultMsgTime() {
        for (int i = 0; i < 2; i++) {

            if (i > items.size()) {
                break;
            }

            if (items.get(i).getType() == ITEM_TYPE_OTHER) {
                ((EventItem) items.get(i)).getEvent().setSentAtUtc("");
                break;
            }
        }
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View normalView;
        switch (viewType) {
            case TYPE_HEADER:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_date, parent, false);
                return new DateViewHolder(normalView);
            case ITEM_TYPE_OTHER:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            case ITEM_ASSIGNMENT:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_assignment, parent, false);
                return new AssignmentViewHolder(normalView);
            case ITEM_TYPE_SELF:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            case FUGU_VIDEO_CALL_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_video_self_side, parent, false);
                return new SelfVideoViewHolder(normalView);
            case FUGU_OTHER_VIDEO_CALL_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_video_other_side, parent, false);
                return new VideoViewHolder(normalView);
            case HIPPO_FILE_SENT_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_file_sent, parent, false);
                return new SentFileViewHolder(normalView);
            case HIPPO_FILE_RECEIVED_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_file_received, parent, false);
                return new ReceivedFileViewHolder(normalView);
            case HIPPO_VIDEO_MESSGAE_SELF:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView);
            case HIPPO_VIDEO_MESSGAE_OTHER:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            case HIPPO_UNKNOWN_MESSAGE_SELF:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            case HIPPO_UNKNOWN_MESSAGE_OTHER:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            case HIPPO_USER_CONCENT_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_agent_bot_item, parent, false);
                return new UserConcentViewHolder(normalView);
            default:
                return null;
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        final int itemType = getItemViewType(position);

        switch (itemType) {
            case FUGU_VIDEO_CALL_VIEW:
                final SelfVideoViewHolder videoViewHolder = (SelfVideoViewHolder) holder;
                final Message videoMessage = ((EventItem) items.get(position)).getEvent();
                videoViewHolder.tvMsg.setText(getMessage(videoMessage, FUGU_VIDEO_CALL_VIEW));
                if (videoMessage.getSentAtUtc().isEmpty()) {
                    videoViewHolder.tvTime.setVisibility(View.GONE);
                } else {
                    videoViewHolder.tvTime.setText(DateUtils.getTime(dateUtil.convertToLocal(videoMessage.getSentAtUtc())));
                    videoViewHolder.tvTime.setVisibility(View.VISIBLE);
                }
                if(videoMessage.getVideoCallDuration()>0) {
                    videoViewHolder.ivCallIcon.setVisibility(View.VISIBLE);
                    videoViewHolder.tvDuration.setVisibility(View.VISIBLE);
                    videoViewHolder.tvDuration.setText(convertSeconds(videoMessage.getVideoCallDuration())+" at ");
                } else {
                    videoViewHolder.ivCallIcon.setVisibility(View.GONE);
                    videoViewHolder.tvDuration.setVisibility(View.GONE);
                }

                if(!isChatAssignToMe || !AgentCommonData.getUserData().isVideoCallEnabled()
                        || !isVideoCallEnabled) {
                    videoViewHolder.callAgain.setVisibility(View.GONE);
                }
                videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if(onVideoCall != null) {
                            int callType = FuguAppConstant.VIDEO_CALL_VIEW;
                            if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = FuguAppConstant.AUDIO_CALL_VIEW;
                            }
                            onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            case FUGU_OTHER_VIDEO_CALL_VIEW:
                final VideoViewHolder videoOtherViewHolder = (VideoViewHolder) holder;
                final Message videoOtherMessage = ((EventItem) items.get(position)).getEvent();
                videoOtherViewHolder.tvMsg.setText(getMessage(videoOtherMessage, FUGU_OTHER_VIDEO_CALL_VIEW));
                if (videoOtherMessage.getSentAtUtc().isEmpty()) {
                    videoOtherViewHolder.tvTime.setVisibility(View.GONE);
                } else {
                    videoOtherViewHolder.tvTime.setText(DateUtils.getTime(dateUtil.convertToLocal(videoOtherMessage.getSentAtUtc())));
                    videoOtherViewHolder.tvTime.setVisibility(View.VISIBLE);
                }

                videoOtherViewHolder.userImage.setVisibility(View.GONE);

                if(videoOtherMessage.getVideoCallDuration()>0) {
                    videoOtherViewHolder.ivCallIcon.setVisibility(View.VISIBLE);
                    videoOtherViewHolder.tvDuration.setVisibility(View.VISIBLE);
                    videoOtherViewHolder.tvDuration.setText(convertSeconds(videoOtherMessage.getVideoCallDuration())+" at ");
                } else {
                    videoOtherViewHolder.ivCallIcon.setVisibility(View.GONE);
                    videoOtherViewHolder.tvDuration.setVisibility(View.GONE);
                }


                NinePatchDrawable drawable2 = (NinePatchDrawable) videoOtherViewHolder.llMessage.getBackground();
                drawable2.setColorFilter(hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);

                videoOtherViewHolder.llRoot.setPadding(pxToDp(17),
                        pxToDp(1),
                        0,
                        pxToDp(1));
                videoOtherViewHolder.tvMsg.setPadding(pxToDp(8),
                        pxToDp(7),
                        pxToDp(2),
                        pxToDp(7));

                videoOtherViewHolder.callAgain.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if(onVideoCall != null) {
                            int callType = FuguAppConstant.VIDEO_CALL_VIEW;
                            if (!TextUtils.isEmpty(videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = FuguAppConstant.AUDIO_CALL_VIEW;
                            }
                            onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            case TYPE_HEADER:
                final DateViewHolder dateViewHolder = (DateViewHolder) holder;
                HeaderItem headerItem = (HeaderItem) items.get(position);
                if (headerItem.getDate().isEmpty()) {
                    dateViewHolder.tvDate.setVisibility(View.GONE);
                } else {
                    String date = DateUtils.getInstance().getDate(headerItem.getDate());
                    dateViewHolder.tvDate.setText(date);
                    dateViewHolder.tvDate.setVisibility(View.VISIBLE);
                }
                GradientDrawable drawable = (GradientDrawable) dateViewHolder.tvDate.getBackground();
                drawable.setStroke((int) context.getResources().getDimension(R.dimen.fugu_border_width), hippoColorConfig.getHippoBorderColor()); // set stroke width and stroke color
                dateViewHolder.tvDate.setTextColor(hippoColorConfig.getHippoChatDateText());
                break;
            case ITEM_TYPE_OTHER:
                final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder) holder;
                final Message currentOrderItem = ((EventItem) items.get(position)).getEvent();
                otherMessageViewHolder.tvUserName.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherMessageViewHolder.tvMsg.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setLinkTextColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setAutoLinkMask(Linkify.ALL);
                otherMessageViewHolder.tvTime.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFrom());

                otherMessageViewHolder.userImage.setVisibility(View.GONE);

                if (currentOrderItem.getMessage().isEmpty()) {
                    otherMessageViewHolder.tvMsg.setVisibility(View.INVISIBLE);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
                    params2.weight = 1.0f;
                    params2.gravity = Gravity.END;
                    otherMessageViewHolder.rlMessages.setLayoutParams(params2);
                    //otherMessageViewHolder.tvMsg.setTextSize(pxToDp(3));
                } else {
                    otherMessageViewHolder.tvMsg.setText(currentOrderItem.getMessage());
                    //otherMessageViewHolder.tvMsg.setTextSize(17);
                    String msg = currentOrderItem.getMessage().replace(" ", "&nbsp;");
                    otherMessageViewHolder.tvMsg.setText(Html.fromHtml(msg.replace("\n", "<br /> ")));
                    otherMessageViewHolder.tvMsg.setVisibility(View.VISIBLE);
                }
                otherMessageViewHolder.tvUserName.setText(currentOrderItem.getfromName());

                if (currentOrderItem.getSentAtUtc().isEmpty()) {
                    otherMessageViewHolder.tvTime.setVisibility(View.GONE);
                } else {
                    otherMessageViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                    otherMessageViewHolder.tvTime.setVisibility(View.VISIBLE);
                }

                String userNameText = "";

                if (!TextUtils.isEmpty(currentOrderItem.getfromName())) {
                    userNameText = currentOrderItem.getfromName().trim();
                }

                setOtherTypeView(position, currentOrderItem, userNameText, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.tvUserName,
                        otherMessageViewHolder.llRoot, otherMessageViewHolder.tvMsg);

                setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, currentOrderItem.getIntegrationSource());

                if (!currentOrderItem.getThumbnailUrl().isEmpty()) {
                    new RequestOptions();
                    RequestOptions myOptions = RequestOptions
                            .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                            .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                            .dontAnimate()
                            .diskCacheStrategy(DiskCacheStrategy.ALL)
                            .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
                    Glide.with(context).load(currentOrderItem.getThumbnailUrl())
                            .apply(myOptions)
                            .into(otherMessageViewHolder.ivMsgImage);

                    otherMessageViewHolder.rlImageMessage.setVisibility(View.VISIBLE);
                } else {
                    otherMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
                }

                otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        showImageDialog(context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    }
                });

                customViewUI(currentOrderItem, context, otherMessageViewHolder.llChatLeft, otherMessageViewHolder.rlCustomAction, otherMessageViewHolder.tvActionTitle,
                        otherMessageViewHolder.tvActionTitleDescription, otherMessageViewHolder.llTextualContent,
                        otherMessageViewHolder.ivActionImage, otherMessageViewHolder.rvActionDescription,
                        otherMessageViewHolder.rvActionButtons, otherMessageViewHolder.vwActionButtonDivider);

                break;
            case ITEM_TYPE_SELF:
                final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder) holder;
                final Message selfOrderItem = ((EventItem) items.get(position)).getEvent();

                selfMessageViewHolder.tvName.setVisibility(View.VISIBLE);
                selfMessageViewHolder.tvName.setText(selfOrderItem.getfromName());
                if (selfOrderItem.getMessage().isEmpty()) {
                    selfMessageViewHolder.tvMsg.setVisibility(View.INVISIBLE);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
                    params2.weight = 1.0f;
                    params2.gravity = Gravity.END;
                    selfMessageViewHolder.rlMessages.setLayoutParams(params2);
                    //selfMessageViewHolder.tvMsg.setTextSize(pxToDp(3));
                } else {
                    selfMessageViewHolder.tvMsg.setText(selfOrderItem.getMessage());
                    //selfMessageViewHolder.tvMsg.setTextSize(17);
                    String msg = selfOrderItem.getMessage().replace("  ", "&nbsp;");
                    selfMessageViewHolder.tvMsg.setText(Html.fromHtml(msg.replace("\n", "<br />")));
                    selfMessageViewHolder.tvMsg.setVisibility(View.VISIBLE);
                }

                if (selfOrderItem.getSentAtUtc().isEmpty()) {
                    selfMessageViewHolder.tvTime.setVisibility(View.GONE);
                } else {
                    selfMessageViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(selfOrderItem.getSentAtUtc())));
                    selfMessageViewHolder.tvTime.setVisibility(View.VISIBLE);
                }


                setSelfTypeView(position, selfOrderItem, selfMessageViewHolder.llRoot, selfMessageViewHolder.tvName, selfMessageViewHolder.llChat,
                        selfMessageViewHolder.rlMessages, selfMessageViewHolder.tvMsg, selfMessageViewHolder.tvTime);

                setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, selfOrderItem.getIntegrationSource());

                //if (!selfOrderItem.getThumbnailUrl().isEmpty()) {
                if (!TextUtils.isEmpty(selfOrderItem.getThumbnailUrl()) || !TextUtils.isEmpty(selfOrderItem.getLocalImagePath())) {
                    if (selfOrderItem.getMessageStatus() == MESSAGE_UNSENT
                            || selfOrderItem.getMessageStatus() == MESSAGE_IMAGE_RETRY
                            || selfOrderItem.getMessageStatus() == MESSAGE_FILE_RETRY) {
                        RequestOptions myOptions = RequestOptions
                                .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                                .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                                .dontAnimate()
                                .diskCacheStrategy(DiskCacheStrategy.ALL)
                                .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
                        Glide.with(context).load(new File(selfOrderItem.getLocalImagePath()))
                                .apply(myOptions)
                                .into(selfMessageViewHolder.ivMsgImage);

                        if (selfOrderItem.getMessageStatus() == MESSAGE_IMAGE_RETRY
                                || selfOrderItem.getMessageStatus() == MESSAGE_FILE_RETRY) {
                            selfMessageViewHolder.pbLoading.setVisibility(View.GONE);
                            selfMessageViewHolder.btnRetry.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.btnCancel.setVisibility(View.VISIBLE);
                        } else {
                            selfMessageViewHolder.pbLoading.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.btnRetry.setVisibility(View.GONE);
                            selfMessageViewHolder.btnCancel.setVisibility(View.GONE);
                        }

                    } else {
                        RequestOptions myOptions = RequestOptions
                                .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                                .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                                .dontAnimate()
                                .diskCacheStrategy(DiskCacheStrategy.ALL)
                                .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
                        Glide.with(context).load(selfOrderItem.getThumbnailUrl())
                                .apply(myOptions)
                                .into(selfMessageViewHolder.ivMsgImage);

                        selfMessageViewHolder.pbLoading.setVisibility(View.GONE);
                        selfMessageViewHolder.btnRetry.setVisibility(View.GONE);
                        selfMessageViewHolder.btnCancel.setVisibility(View.GONE);
                    }
                    selfMessageViewHolder.rlImageMessage.setVisibility(View.VISIBLE);
                } else {
                    selfMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
                }

                selfMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (selfOrderItem.getMessageStatus() == MESSAGE_UNSENT || selfOrderItem.getMessageStatus() == MESSAGE_IMAGE_RETRY) {
                            return;
                        }
                        showImageDialog(context, selfOrderItem.getImageUrl(), selfMessageViewHolder.ivMsgImage, selfOrderItem);
                    }
                });

                if(selfOrderItem.getIsMessageExpired() == 1 && selfOrderItem.getMessageType() != 10) {
                    selfMessageViewHolder.llRetry.setVisibility(View.VISIBLE);
                    selfMessageViewHolder.tvCancel.setVisibility(View.VISIBLE);
                    selfMessageViewHolder.tvTryAgain.setTag(position);
                    selfMessageViewHolder.tvCancel.setTag(position);
                    selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            if(mOnRetry != null) {
                                String muid = selfOrderItem.getMuid();
                                int pos = selfMessageViewHolder.getAdapterPosition();
                                mOnRetry.onMessageRetry(muid, pos);
                            }
                        }
                    });

                    selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            //int pos = (int) view.getTag();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            if(mOnRetry != null) {
                                String muid = selfOrderItem.getMuid();
                                mOnRetry.onMessageCancel(muid, pos);
                            }
                        }
                    });
                } else {
                    selfMessageViewHolder.llRetry.setVisibility(View.GONE);
                    selfMessageViewHolder.tvCancel.setVisibility(View.GONE);
                }

                try {
                    switch (selfOrderItem.getMessageStatus()) {
                        case MESSAGE_UNSENT:
                        case MESSAGE_IMAGE_RETRY:
                        case MESSAGE_FILE_RETRY:
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                            selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.ivMessageState.getDrawable()
                                    .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        case MESSAGE_READ:
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.getDrawable()
                                    .setColorFilter(hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                            selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
                            break;
                        case MESSAGE_SENT:
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.ivMessageState.getDrawable()
                                    .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        case MESSAGE_DELIVERED:
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                            selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.ivMessageState.getDrawable()
                                    .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                        default:
                            selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                            selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.ivMessageState.getDrawable()
                                    .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                            break;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (mOnRetry != null) {
                            selfMessageViewHolder.pbLoading.setVisibility(View.VISIBLE);
                            selfMessageViewHolder.btnRetry.setVisibility(View.GONE);
                            String muid = selfOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            if(mOnRetry != null)
                                mOnRetry.onFileMessageRetry(muid, pos);
                            //mOnRetry.onRetry(selfOrderItem.getImageUrl(), "image/*", selfOrderItem.getMessageIndex(), muid);
                        }
                    }
                });

                selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mOnRetry != null) {
                            String muid = selfOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            mOnRetry.onMessageCancel(muid, pos);
                        }
                    }
                });

                customViewUI(selfOrderItem, context, selfMessageViewHolder.llChat, selfMessageViewHolder.rlCustomAction, selfMessageViewHolder.tvActionTitle,
                        selfMessageViewHolder.tvActionTitleDescription, selfMessageViewHolder.llTextualContent,
                        selfMessageViewHolder.ivActionImage, selfMessageViewHolder.rvActionDescription,
                        selfMessageViewHolder.rvActionButtons, selfMessageViewHolder.vwActionButtonDivider);

                break;
            case ITEM_ASSIGNMENT:
                final AssignmentViewHolder assignmentViewHolder = (AssignmentViewHolder) holder;
                final Message currentAssignemntItem = ((EventItem) items.get(position)).getEvent();
                assignmentViewHolder.tvAssignment.setText(Html.fromHtml(currentAssignemntItem.getMessage()));
                break;
            case HIPPO_FILE_SENT_VIEW:
                final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder) holder;
                final Message fileSentMessage = ((EventItem) items.get(position)).getEvent();
                setSelfMessageBackground(sentFileViewHolder.llRoot, sentFileViewHolder.llMessage, position);
                NinePatchDrawable drawable4 = (NinePatchDrawable) sentFileViewHolder.llMessage.getBackground();
                drawable4.setColorFilter(hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                sentFileViewHolder.circleProgress.setBarColor(hippoColorConfig.getHippoThemeColorPrimary());
                //String fileExt = Util.getExtension(fileSentMessage.getFileUrl());
                String fileExt = Util.getExtension(fileSentMessage.getFileName());
                if(TextUtils.isEmpty(fileExt))
                    fileExt = Util.getExtension(fileSentMessage.getFileUrl());
                Integer dimage = IMAGE_MAP.get(fileExt.toLowerCase());
                if (dimage != null) {
                    sentFileViewHolder.ivFileImage.setImageResource(dimage);
                } else {
                    sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                sentFileViewHolder.tvFileName.setText(fileSentMessage.getFileName());
                if(fileExt.length() > 4) {
                    fileExt = fileExt.substring(0, 4) +"..";
                }
                sentFileViewHolder.tvFileExtension.setText(fileExt);
                if(!TextUtils.isEmpty(fileSentMessage.getFileSize())) {
                    try {
                        sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
                    } catch (Exception e) {
                        sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
                    }
                }

                setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, fileSentMessage.getIntegrationSource());

                messageStatusTick(context, sentFileViewHolder.ivMessageState, fileSentMessage);
                setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
                setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
                setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                if (!fileSentMessage.isAudioPlaying()) {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                setFileCLickListener(sentFileViewHolder.llMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
                sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int pos = sentFileViewHolder.getAdapterPosition();
                        if(mOnRetry != null)
                            mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
                    }
                });
                break;
            case HIPPO_FILE_RECEIVED_VIEW:
                final ReceivedFileViewHolder fHolder = (ReceivedFileViewHolder) holder;
                final Message fileReceivedMessage = ((EventItem) items.get(position)).getEvent();

                fHolder.userImage.setVisibility(View.GONE);
                fHolder.progressBar.setBarColor(hippoColorConfig.getHippoThemeColorPrimary());

                setIntegrationSource(fHolder.messageSourceType, fHolder.messageSourceType1, fileReceivedMessage.getIntegrationSource());

                String fuserNameText = "";
                if (!TextUtils.isEmpty(fileReceivedMessage.getfromName())) {
                    fuserNameText = fileReceivedMessage.getfromName().trim();
                }

                setFileMessageOther(fHolder.llRoot, fHolder.llMessage, position, fHolder.tvUserName, fuserNameText);
                NinePatchDrawable drawable6 = (NinePatchDrawable) fHolder.llMessage.getBackground();
                drawable6.setColorFilter(hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                String receivedFileExt = Util.getExtension(fileReceivedMessage.getFileUrl());
                Integer dimage1 = IMAGE_MAP.get(receivedFileExt.toLowerCase());
                if (dimage1 != null) {
                    fHolder.ivFileImage.setImageResource(dimage1);
                } else {
                    fHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                fHolder.tvFileName.setText(fileReceivedMessage.getFileName());
                String fileExt1 = TextUtils.isEmpty(fileReceivedMessage.getFileExtension()) ? receivedFileExt : fileReceivedMessage.getFileExtension();
                if(fileExt1.length() > 4) {
                    fileExt1 = fileExt1.substring(0, 4) +"..";
                }
                fHolder.tvFileExtension.setText(fileExt1);
                fHolder.tvFileSize.setText(fileReceivedMessage.getFileSize());
                setFileDownLoadStatus(fHolder.ivFileImage, fHolder.ivFilePlay, fHolder.progressBar, fHolder.ivFileDownload, fHolder.ivFileUpload, fileReceivedMessage, position);
                setDownloadClick(fHolder.ivFileDownload, fHolder.progressBar, fileReceivedMessage, position);
                if (!fileReceivedMessage.isAudioPlaying()) {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                setFileCLickListener(fHolder.llMessage, fileReceivedMessage, fHolder.ivFilePlay, position);

                break;
            case HIPPO_VIDEO_MESSGAE_SELF:
                final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder) holder;
                final Message selfVideoMessage = ((EventItem) items.get(position)).getEvent();
                setSelfMessageBackground(selfVideoMessageViewHolder.llRoot, selfVideoMessageViewHolder.llImageMessage, position);
                NinePatchDrawable drawable5 = (NinePatchDrawable) selfVideoMessageViewHolder.llImageMessage.getBackground();
                drawable5.setColorFilter(hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);

                selfVideoMessageViewHolder.circle_progress.setBarColor(hippoColorConfig.getHippoThemeColorPrimary());
                setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessage.getIntegrationSource());

                setTime(selfVideoMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
                setMessageStatus(selfVideoMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
                if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl())) {
                    setImage(context, selfVideoMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
                } else {
                    selfVideoMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
                }
                setImageHeightAndWidth(selfVideoMessageViewHolder.ivImageMsg, selfVideoMessageViewHolder.rlImageMessage, selfVideoMessageViewHolder.llImageMessage, selfVideoMessage, true);
                selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if(!Utils.preventMultipleClicks()) {
                            return;
                        }

                        String fname = Util.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                        String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                        if(TextUtils.isEmpty(localPath))
                            localPath = selfVideoMessage.getFileUrl();
                        Intent intent = new Intent(context, VideoPlayerActivity.class);
                        intent.putExtra("url", localPath);
                        intent.putExtra("title", selfVideoMessage.getFileName());
                        context.startActivity(intent);
                    }
                });

                setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay,
                        selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress);

                selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if(mOnRetry != null)
                            mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                    }
                });

                selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if(mOnRetry != null)
                            mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                    }
                });
                selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        selfVideoMessageViewHolder.circle_progress.setVisibility(View.VISIBLE);
                        selfVideoMessageViewHolder.llDownload.setVisibility(View.GONE);

                        String docType = "video";
                        if(selfVideoMessage.getMessageType() == FILE_MESSAGE) {
                            docType = selfVideoMessage.getDocumentType();
                        }

                        String fileName = selfVideoMessage.getFileName();



                        if(TextUtils.isEmpty(fileName)) {
                            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            fileName = "Hippochat_" + timeStamp + ".jpg";
                        }

                        String fullPath = Util.getDirectoryPath(FOLDER_TYPE.get(docType));
                        File file = new File(fullPath);
                        if(!file.exists()) {
                            file.mkdir();
                        }
                        int downloadId = downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position);

                        selfVideoMessage.setDownloadId(downloadId);
                    }
                });
                break;
            case HIPPO_VIDEO_MESSGAE_OTHER:
                final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder) holder;
                final Message otherVideoMessage = ((EventItem) items.get(position)).getEvent();

                otherVideoMessageViewHolder.userImage.setVisibility(View.GONE);
                otherVideoMessageViewHolder.progressBar.setBarColor(hippoColorConfig.getHippoThemeColorPrimary());
                setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
                if (!TextUtils.isEmpty(otherVideoMessage.getThumbnailUrl())) {
                    setImage(context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
                } else {
                    otherVideoMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
                }
                setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessage.getIntegrationSource());
                setImageHeightAndWidth(otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, otherVideoMessage, true);
                setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);

                String vuserNameText = "";
                if (!TextUtils.isEmpty(otherVideoMessage.getfromName())) {
                    vuserNameText = otherVideoMessage.getfromName().trim();
                }

                setFileMessageOther(otherVideoMessageViewHolder.llRoot, otherVideoMessageViewHolder.llImageMessage, position,
                        otherVideoMessageViewHolder.tvUserName, vuserNameText);


                otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if(context.isNetworkAvailable()) {
                            otherVideoMessageViewHolder.progressBar.setVisibility(View.VISIBLE);
                            otherVideoMessageViewHolder.llDownload.setVisibility(View.GONE);

                            String docType = "video";
                            if (otherVideoMessage.getMessageType() == FILE_MESSAGE) {
                                docType = otherVideoMessage.getDocumentType();
                            }

                            String fileName = otherVideoMessage.getFileName();

                            if (TextUtils.isEmpty(fileName)) {
                                String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                                fileName = "Hippochat_" + timeStamp + ".jpg";
                            }

                            String fullPath = Util.getDirectoryPath(FOLDER_TYPE.get(docType));
                            File file = new File(fullPath);
                            if (!file.exists()) {
                                file.mkdir();
                            }
                            int downloadId = downloadFileFromUrl(fullPath, fileName, otherVideoMessage, position);

                            otherVideoMessage.setDownloadId(downloadId);
                        } else {
                            Toast.makeText(context, context.getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                        }
                    }
                });
                break;
            case HIPPO_UNKNOWN_MESSAGE_OTHER:
                final OtherMessageViewHolder otherUnknownView = (OtherMessageViewHolder) holder;
                final Message unknownItemOther = ((EventItem) items.get(position)).getEvent();

                otherUnknownView.userImage.setVisibility(View.GONE);

                otherUnknownView.tvUserName.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherUnknownView.tvMsg.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setLinkTextColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setAutoLinkMask(Linkify.ALL);
                otherUnknownView.tvTime.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFrom());

                String message = context.getString(R.string.unknown_message);
                if(!TextUtils.isEmpty(AgentCommonData.getUserData().getUnsupportedMessage())) {
                    message = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                otherUnknownView.tvMsg.setText(message);
                //otherUnknownView.tvMsg.setTextSize(17);
                otherUnknownView.tvMsg.setVisibility(View.VISIBLE);

                otherUnknownView.tvUserName.setText(unknownItemOther.getfromName());

                if (unknownItemOther.getSentAtUtc().isEmpty()) {
                    otherUnknownView.tvTime.setVisibility(View.GONE);
                } else {
                    otherUnknownView.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(unknownItemOther.getSentAtUtc())));
                    otherUnknownView.tvTime.setVisibility(View.VISIBLE);
                }

                String userNameText1 = "";
                if (!TextUtils.isEmpty(unknownItemOther.getfromName())) {
                    userNameText1 = unknownItemOther.getfromName().trim();
                }

                setOtherTypeView(position, unknownItemOther, userNameText1, otherUnknownView.llChatLeft, otherUnknownView.tvUserName,
                        otherUnknownView.llRoot, otherUnknownView.tvMsg);


                break;
            case HIPPO_UNKNOWN_MESSAGE_SELF:
                final SelfMessageViewHolder selfUnknownView = (SelfMessageViewHolder) holder;
                final Message unknownItemSelf = ((EventItem) items.get(position)).getEvent();

                selfUnknownView.tvName.setVisibility(View.VISIBLE);
                selfUnknownView.tvName.setText(unknownItemSelf.getfromName());
                String selfMsg = context.getString(R.string.unknown_message);
                if(!TextUtils.isEmpty(AgentCommonData.getUserData().getUnsupportedMessage())) {
                    selfMsg = AgentCommonData.getUserData().getUnsupportedMessage();
                }
                selfUnknownView.tvMsg.setText(selfMsg);
                //selfUnknownView.tvMsg.setTextSize(17);
                selfUnknownView.tvMsg.setVisibility(View.VISIBLE);

                if (unknownItemSelf.getSentAtUtc().isEmpty()) {
                    selfUnknownView.tvTime.setVisibility(View.GONE);
                } else {
                    selfUnknownView.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(unknownItemSelf.getSentAtUtc())));
                    selfUnknownView.tvTime.setVisibility(View.VISIBLE);
                }


                setSelfTypeView(position, unknownItemSelf, selfUnknownView.llRoot, selfUnknownView.tvName, selfUnknownView.llChat,
                        selfUnknownView.rlMessages, selfUnknownView.tvMsg, selfUnknownView.tvTime);
                break;
            case HIPPO_USER_CONCENT_VIEW:
                final UserConcentViewHolder userConcentViewHolder = (UserConcentViewHolder) holder;
                final Message userConcentMessage = ((EventItem) items.get(position)).getEvent();

                setBotSelfView(position, userConcentViewHolder, userConcentMessage);

                String selectedBtnId = "";
                if(!TextUtils.isEmpty(userConcentMessage.getSelectedBtnId())) {
                    selectedBtnId = userConcentMessage.getSelectedBtnId();
                }

                if(TextUtils.isEmpty(selectedBtnId)) {
                    userConcentViewHolder.tagLayout.setVisibility(View.VISIBLE);
                    userConcentViewHolder.tvTagsTime.setVisibility(View.VISIBLE);
                    userConcentViewHolder.leftrootview.setVisibility(View.GONE);

                    ArrayList<String> tagList = new ArrayList<>();
                    ArrayList<Integer> colorsTag = new ArrayList<>();
                    for (int i = 0; i < userConcentMessage.getContentValue().size(); i++) {
                        tagList.add(userConcentMessage.getContentValue().get(i).getBtnTitle());
                        colorsTag.add(hippoColorConfig.getHippoBgMessageYou());
                    }

                    userConcentViewHolder.tagLayout.setTagBorderColor(hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTagTextColor(hippoColorConfig.getHippoThemeColorPrimary());
                    userConcentViewHolder.tagLayout.setTags(tagList, colorsTag);

                } else {
                    userConcentViewHolder.leftrootview.setVisibility(View.VISIBLE);
                    userConcentViewHolder.tagLayout.setVisibility(View.GONE);
                    userConcentViewHolder.tvTagsTime.setVisibility(View.GONE);

                    int selectedPosition = 0;
                    for(int i=0;i<userConcentMessage.getContentValue().size();i++) {
                        if(selectedBtnId.equalsIgnoreCase(userConcentMessage.getContentValue().get(i).getBtnId())) {
                            selectedPosition = i;
                            break;
                        }
                    }

                    setBotOtherView(position, selectedPosition, userConcentViewHolder, userConcentMessage);
                }
                break;
            default:

                break;
        }
    }

    private void setBotOtherView(int position, int selectedBtn, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {

        userConcentViewHolder.tvMsg.setText(userConcentMessage.getContentValue().get(selectedBtn).getBtnTitle());
        userConcentViewHolder.tvUserName.setText(userConcentMessage.getfromName());

        userConcentViewHolder.tvUserName.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFromName());
        userConcentViewHolder.tvMsg.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
        userConcentViewHolder.tvTime.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgFrom());

        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTime.setVisibility(View.GONE);
        } else {
            userConcentViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTime.setVisibility(View.VISIBLE);
        }

        String userNameText = userConcentMessage.getRepliedBy();
        if (position != 0 && getItemViewType(position - 1) == ITEM_TYPE_OTHER) {
            Message lastOrderItem = ((EventItem) items.get(position - 1)).getEvent();
            if (userConcentMessage.getUserId().compareTo(lastOrderItem.getUserId()) != 0) {
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                userConcentViewHolder.tvUserName.setVisibility(View.VISIBLE);
                userConcentViewHolder.tvUserName.setText(userNameText);
                userConcentViewHolder.leftrootview.setPadding(pxToDp(10),
                        pxToDp(8), 0, pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(pxToDp(15),
                        pxToDp(7), pxToDp(10), pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(pxToDp(15), pxToDp(7), pxToDp(2), pxToDp(7));
            } else if (position != 0 && (position + 1 != items.size())
                    && (getItemViewType(position + 1) != ITEM_TYPE_OTHER)) {
                userConcentViewHolder.tvUserName.setVisibility(View.GONE);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(pxToDp(17),
                        pxToDp(1), pxToDp(0), pxToDp(2));
                userConcentViewHolder.tvUserName.setPadding(pxToDp(8),
                        pxToDp(7), pxToDp(10), pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(pxToDp(8), pxToDp(7), pxToDp(2), pxToDp(7));
            } else {
                userConcentViewHolder.tvUserName.setVisibility(View.GONE);
                userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                userConcentViewHolder.leftrootview.setPadding(pxToDp(17),
                        pxToDp(1), 0, pxToDp(1));
                userConcentViewHolder.tvUserName.setPadding(pxToDp(8),
                        pxToDp(7), pxToDp(10), pxToDp(0));
                userConcentViewHolder.tvMsg.setPadding(pxToDp(8), pxToDp(7), pxToDp(2), pxToDp(7));
            }
        } else if (position != 0 && (position + 1 != items.size())
                && (getItemViewType(position + 1) == ITEM_TYPE_OTHER)) {
            userConcentViewHolder.tvUserName.setVisibility(View.VISIBLE);
            userConcentViewHolder.tvUserName.setText(userNameText);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(pxToDp(10),
                    pxToDp(4), pxToDp(0), pxToDp(1));
            userConcentViewHolder.tvUserName.setPadding(pxToDp(15),
                    pxToDp(7), pxToDp(10), pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(pxToDp(15), pxToDp(0), pxToDp(2), pxToDp(7));
        } else {
            userConcentViewHolder.tvUserName.setVisibility(View.VISIBLE);
            userConcentViewHolder.tvUserName.setText(userNameText);
            userConcentViewHolder.llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            userConcentViewHolder.leftrootview.setPadding(pxToDp(10),
                    pxToDp(4), 0, pxToDp(2));
            userConcentViewHolder.tvUserName.setPadding(pxToDp(15),
                    pxToDp(7), pxToDp(10), pxToDp(0));
            userConcentViewHolder.tvMsg.setPadding(pxToDp(15), pxToDp(0), pxToDp(2), pxToDp(7));
        }

        NinePatchDrawable drawable2 = (NinePatchDrawable) userConcentViewHolder.llChatLeft.getBackground();
        drawable2.setColorFilter(hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }

    private void setBotSelfView(int position, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {


        userConcentViewHolder.tvNameRight.setText(userConcentMessage.getfromName());
        userConcentViewHolder.tvMsgRight.setText(userConcentMessage.getMessage());

        userConcentViewHolder.tvNameRight.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgFromName());
        userConcentViewHolder.tvMsgRight.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgYou());
        userConcentViewHolder.tvTimeRight.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgYou());

        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTimeRight.setVisibility(View.GONE);
        } else {
            userConcentViewHolder.tvTimeRight.setText(dateUtil.getTime(dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTimeRight.setVisibility(View.VISIBLE);
        }
        if (position != 0
                && (getItemViewType(position - 1) == ITEM_TYPE_SELF)
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
            userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                    pxToDp(1), pxToDp(17), pxToDp(1));

        } else if (position != 0
                && ((getItemViewType(position - 1) == ITEM_TYPE_SELF)
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) != ITEM_TYPE_SELF))
                || (!(position - 1 < 0) && (getItemViewType(position - 1) == ITEM_TYPE_SELF))) {
            if (position == items.size() - 1) {
                userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                        pxToDp(1), pxToDp(17), pxToDp(1));
            } else {
                userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                        pxToDp(1), pxToDp(17), pxToDp(2));
            }
        } else if (position != 0
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
            userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                    pxToDp(4), pxToDp(10), pxToDp(1));
        } else {
            if (position == items.size() - 1) {
                userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                        pxToDp(4), pxToDp(10), pxToDp(1));
            } else {
                userConcentViewHolder.llRootRight.setPadding(pxToDp(0),
                        pxToDp(4), pxToDp(10), pxToDp(2));
            }
        }

        //add new//
        if (position != 0 && isNotSelfViewType(position - 1)) {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            userConcentViewHolder.rlMessagesRight.setPadding(pxToDp(0),
                    pxToDp(0), pxToDp(12), pxToDp(0));
        } else {
            userConcentViewHolder.llChatRight.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            userConcentViewHolder.rlMessagesRight.setPadding(pxToDp(0),
                    pxToDp(0), pxToDp(6), pxToDp(0));
        }


        NinePatchDrawable drawable3 = (NinePatchDrawable) userConcentViewHolder.llChatRight.getBackground();
        drawable3.setColorFilter(hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);

    }

    private boolean isNotSelfViewType(int position) {
        int itemType = getItemViewType(position);
        if(itemType == ITEM_TYPE_SELF || itemType == HIPPO_FILE_SENT_VIEW ||
                itemType == HIPPO_VIDEO_MESSGAE_SELF || //itemType == HIPPO_USER_CONCENT_VIEW ||
                itemType == FUGU_VIDEO_CALL_VIEW) {
            return false;
        }
        return true;
    }


    private void customViewUI(Message currentOrderItem2, Context context, LinearLayout llChatLeft, RelativeLayout rlCustomAction, TextView tvActionTitle,
                              TextView tvActionTitleDescription, LinearLayout llTextualContent, ImageView ivActionImage, RecyclerView rvActionDescription,
                              RecyclerView rvActionButtons, View vwActionButtonDivider) {
        if (currentOrderItem2.getMessageType() == ACTION_MESSAGE || currentOrderItem2.getMessageType() == ACTION_MESSAGE_NEW) {
            rlCustomAction.setVisibility(View.VISIBLE);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) rlCustomAction.getLayoutParams();

            // increase left margin if background is chat_bg_left
            if (llChatLeft.getBackground().getConstantState() == ContextCompat.getDrawable(context, R.drawable.hippo_chat_bg_left).getConstantState()) {
                layoutParams.setMargins(pxToDp(13), pxToDp(10), pxToDp(10), pxToDp(10));
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    layoutParams.setMarginStart(pxToDp(13));
                    layoutParams.setMarginEnd(pxToDp(10));
                }
            } else {
                layoutParams.setMargins(pxToDp(10), pxToDp(10), pxToDp(10), pxToDp(10));
            }

            CustomAction customAction = currentOrderItem2.getCustomAction();
            if (customAction != null) {
                // title
                if (customAction.getTitle() != null && !TextUtils.isEmpty(customAction.getTitle())) {
                    tvActionTitle.setVisibility(View.VISIBLE);
                    tvActionTitle.setText(customAction.getTitle());
                } else {
                    tvActionTitle.setVisibility(View.GONE);
                }

                // title description
                if (customAction.getTitleDescription() != null && !TextUtils.isEmpty(customAction.getTitleDescription())) {
                    tvActionTitleDescription.setVisibility(View.VISIBLE);
                    tvActionTitleDescription.setText(customAction.getTitleDescription());
                } else {
                    tvActionTitleDescription.setVisibility(View.GONE);
                }

                // image
                if (customAction.getImageUrl() != null && !TextUtils.isEmpty(customAction.getImageUrl())) {
                    llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                    ivActionImage.setVisibility(View.VISIBLE);
                    RequestOptions myOptions = RequestOptions
                            .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                            .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                            .dontAnimate()
                            .diskCacheStrategy(DiskCacheStrategy.ALL)
                            .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
                    Glide.with(context).load(customAction.getImageUrl())
                            .apply(myOptions)
                            .into(ivActionImage);
                } else {
                    ivActionImage.setVisibility(View.GONE);
                    llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                }



                // description
                if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                    rvActionDescription.setVisibility(View.VISIBLE);
                    rvActionDescription.setLayoutManager(new LinearLayoutManager(context));
                    rvActionDescription.setNestedScrollingEnabled(false);
                    rvActionDescription.setAdapter(new CustomActionDescriptionAdapter(context,
                            customAction.getDescriptionObjects()));
                } else {
                    rvActionDescription.setVisibility(View.GONE);
                }
                // buttons
                if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                    vwActionButtonDivider.setVisibility(View.VISIBLE);
                    rvActionButtons.setVisibility(View.VISIBLE);
                    rvActionButtons.setNestedScrollingEnabled(false);

                    // set span size of grid
                    int span = 2;
                    int size = customAction.getActionButtons().size();
                    if (size == 1) {
                        span = 1;
                    } else if (size % 3 == 0) {
                        span = 3;
                    } else {
                        span = 2;
                    }

                    boolean disAbleClick = false;
                    if(currentOrderItem2.getUserId().intValue() == AgentCommonData.getUserData().getUserId().intValue()) {
                        disAbleClick = true;
                    }

                    rvActionButtons.setLayoutManager(new GridLayoutManager(context, span));
                    rvActionButtons.addItemDecoration(new GridDividerItemDecoration(context));
                    rvActionButtons.setAdapter(new CustomActionButtonsAdapter(context, customAction.getActionButtons(), disAbleClick));
                } else {
                    vwActionButtonDivider.setVisibility(View.GONE);
                    rvActionButtons.setVisibility(View.GONE);
                }
            }
        } else {
            rlCustomAction.setVisibility(View.GONE);
        }
    }

    private void setSelfTypeView(int position, Message currentOrderItem, LinearLayout llRoot, TextView tvName, LinearLayout llChat,
                                 RelativeLayout rlMessages, TextView tvMsg, TextView tvTime) {
        if (position != 0
                && (getSelfViewType(position - 1))
                && (position + 1 != items.size())
                && (getSelfViewType(position + 1))) {
            llRoot.setPadding(pxToDp(0),
                    pxToDp(1),
                    pxToDp(17),
                    pxToDp(1));
            tvName.setVisibility(View.GONE);
        } else if (position != 0 && ((getSelfViewType(position - 1)) && (position + 1 != items.size())
                && (getSelfViewType(position + 1)))
                || (!(position - 1 < 0) && (getSelfViewType(position - 1)))) {
            if (position == items.size() - 1) {
                llRoot.setPadding(pxToDp(0),
                        pxToDp(1),
                        pxToDp(17),
                        pxToDp(1));
            } else {
                llRoot.setPadding(pxToDp(0),
                        pxToDp(1),
                        pxToDp(17),
                        pxToDp(2));
            }
            tvName.setVisibility(View.GONE);
        } else if (position != 0 && (position + 1 != items.size()) && (getSelfViewType(position + 1))) {
            llRoot.setPadding(pxToDp(0),
                    pxToDp(4),
                    pxToDp(10),
                    pxToDp(1));
        } else {
            if (position == items.size() - 1) {
                llRoot.setPadding(pxToDp(0),
                        pxToDp(4),
                        pxToDp(10),
                        pxToDp(1));
            } else {
                llRoot.setPadding(pxToDp(0),
                        pxToDp(4),
                        pxToDp(10),
                        pxToDp(2));
            }
        }

        //add new//
        if (position != 0 && (!getSelfViewType(position - 1))) {
            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            rlMessages.setPadding(pxToDp(0),
                    pxToDp(0),
                    pxToDp(12),
                    pxToDp(0));
        } else {
            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            rlMessages.setPadding(pxToDp(0),
                    pxToDp(0),
                    pxToDp(6),
                    pxToDp(0));
        }


//        if (position != 0
//                && (getItemViewType(position - 1) == ITEM_TYPE_SELF)
//                && (position + 1 != items.size())
//                && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
//            llRoot.setPadding(pxToDp(0),
//                    pxToDp(1),
//                    pxToDp(17),
//                    pxToDp(1));
//            tvName.setVisibility(View.GONE);
//        } else if (position != 0 && ((getItemViewType(position - 1) == ITEM_TYPE_SELF) && (position + 1 != items.size())
//                && (getItemViewType(position + 1) != ITEM_TYPE_SELF))
//                || (!(position - 1 < 0) && (getItemViewType(position - 1) == ITEM_TYPE_SELF))) {
//            if (position == items.size() - 1) {
//                llRoot.setPadding(pxToDp(0),
//                        pxToDp(1),
//                        pxToDp(17),
//                        pxToDp(1));
//            } else {
//                llRoot.setPadding(pxToDp(0),
//                        pxToDp(1),
//                        pxToDp(17),
//                        pxToDp(2));
//            }
//            tvName.setVisibility(View.GONE);
//        } else if (position != 0 && (position + 1 != items.size()) && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
//            llRoot.setPadding(pxToDp(0),
//                    pxToDp(4),
//                    pxToDp(10),
//                    pxToDp(1));
//        } else {
//            if (position == items.size() - 1) {
//                llRoot.setPadding(pxToDp(0),
//                        pxToDp(4),
//                        pxToDp(10),
//                        pxToDp(1));
//            } else {
//                llRoot.setPadding(pxToDp(0),
//                        pxToDp(4),
//                        pxToDp(10),
//                        pxToDp(2));
//            }
//        }
//
//        //add new//
//        if (position != 0 && (getItemViewType(position - 1) != ITEM_TYPE_SELF)) {
//            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right);
//            rlMessages.setPadding(pxToDp(0),
//                    pxToDp(0),
//                    pxToDp(12),
//                    pxToDp(0));
//        } else {
//            llChat.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
//            rlMessages.setPadding(pxToDp(0),
//                    pxToDp(0),
//                    pxToDp(6),
//                    pxToDp(0));
//        }
//
//
//

        NinePatchDrawable drawable3 = (NinePatchDrawable) llChat.getBackground();
        if (currentOrderItem.getMessageType() == PRIVATE_NOTE) {
            drawable3.setColorFilter(hippoColorConfig.getHippoPrivateMsg(), PorterDuff.Mode.MULTIPLY);
        } else {
            drawable3.setColorFilter(hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
        }

        tvName.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgFromName());
        tvMsg.setTextColor(hippoColorConfig.getHippoPrimaryTextMsgYou());
        tvMsg.setLinkTextColor(hippoColorConfig.getHippoPrimaryTextMsgYou());
        tvMsg.setAutoLinkMask(Linkify.ALL);
        tvTime.setTextColor(hippoColorConfig.getHippoSecondaryTextMsgYou());
    }

    private boolean getSelfViewType(int position) {
        int type = getItemViewType(position);
        return type == ITEM_TYPE_SELF || type == HIPPO_VIDEO_MESSGAE_SELF
                || type == HIPPO_FILE_SENT_VIEW || type == HIPPO_VIDEO_MESSGAE_SELF || type == HIPPO_UNKNOWN_MESSAGE_SELF;
    }

    private void setOtherTypeView(int position, Message currentOrderItem, String userNameText, LinearLayout llChatLeft,
                                  TextView tvUserName, LinearLayout llRoot, TextView tvMsg) {

        int previousViewType = getItemViewType(position - 1);
        int viewType = getItemViewType(position);
        int nextViewType = getItemViewType(position);
        if(position + 1 != items.size()) {
            nextViewType = getItemViewType(position + 1);
        }

        if (position != 0 && (previousViewType == ITEM_TYPE_OTHER
                || previousViewType == HIPPO_USER_CONCENT_VIEW
                           || previousViewType == HIPPO_UNKNOWN_MESSAGE_OTHER)) {
            Message lastOrderItem = ((EventItem) items.get(position - 1)).getEvent();
            if (currentOrderItem.getUserId().compareTo(lastOrderItem.getUserId()) != 0
            && previousViewType != HIPPO_USER_CONCENT_VIEW) {
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                tvUserName.setVisibility(View.VISIBLE);
                tvUserName.setText(userNameText);
                llRoot.setPadding(pxToDp(10),
                        pxToDp(8),
                        0,
                        pxToDp(1));
                tvUserName.setPadding(pxToDp(15),
                        pxToDp(7),
                        pxToDp(10),
                        pxToDp(0));
                tvMsg.setPadding(pxToDp(15),
                        pxToDp(7),
                        pxToDp(2),
                        pxToDp(7));
            } else if (position != 0 && (position + 1 != items.size())
                    && (nextViewType != ITEM_TYPE_OTHER
                    || nextViewType != HIPPO_USER_CONCENT_VIEW
                     || nextViewType != HIPPO_UNKNOWN_MESSAGE_OTHER)) {
                tvUserName.setVisibility(View.GONE);
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                llRoot.setPadding(pxToDp(17),
                        pxToDp(1),
                        pxToDp(0),
                        pxToDp(2));
                tvUserName.setPadding(pxToDp(8),
                        pxToDp(7),
                        pxToDp(10),
                        pxToDp(0));
                tvMsg.setPadding(pxToDp(8),
                        pxToDp(7),
                        pxToDp(2),
                        pxToDp(7));
            } else {
                tvUserName.setVisibility(View.GONE);
                llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                llRoot.setPadding(pxToDp(17),
                        pxToDp(1),
                        0,
                        pxToDp(1));
                tvUserName.setPadding(pxToDp(8),
                        pxToDp(7),
                        pxToDp(10),
                        pxToDp(0));
                tvMsg.setPadding(pxToDp(8),
                        pxToDp(7),
                        pxToDp(2),
                        pxToDp(7));
            }
        } else if (position != 0 && (position + 1 != items.size()) && (nextViewType == ITEM_TYPE_OTHER
                || nextViewType == HIPPO_USER_CONCENT_VIEW
                || nextViewType == HIPPO_UNKNOWN_MESSAGE_OTHER)) {
            tvUserName.setVisibility(View.VISIBLE);
            tvUserName.setText(userNameText);
            llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            llRoot.setPadding(pxToDp(10),
                    pxToDp(4),
                    pxToDp(0),
                    pxToDp(1));
            tvUserName.setPadding(pxToDp(15),
                    pxToDp(7),
                    pxToDp(10),
                    pxToDp(0));
            tvMsg.setPadding(pxToDp(15),
                    pxToDp(0),
                    pxToDp(2),
                    pxToDp(7));
        } else {
            tvUserName.setVisibility(View.VISIBLE);
            tvUserName.setText(userNameText);
            llChatLeft.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            llRoot.setPadding(pxToDp(10),
                    pxToDp(4),
                    0,
                    pxToDp(2));
            tvUserName.setPadding(pxToDp(15),
                    pxToDp(7),
                    pxToDp(10),
                    pxToDp(0));
            tvMsg.setPadding(pxToDp(15),
                    pxToDp(0),
                    pxToDp(2),
                    pxToDp(7));
        }


        NinePatchDrawable drawable2 = (NinePatchDrawable) llChatLeft.getBackground();
        drawable2.setColorFilter(hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
    }
    private void setMargins(View view, int left, int top, int right, int bottom) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            view.requestLayout();
        }
    }

    private int pxToDp(int dpParam) {
        int dpValue = dpParam; // margin in dips
        float d = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * d); // margin in pixels
    }


    @Override
    public int getItemViewType(int position) {
        return items.get(position).getType();
    }

    @Override
    public int getItemCount() {
//        FuguLog.e("fuguMessageList count", "************==  " + items.size());
        return items.size();
    }

    private void setIntegrationSource(ImageView source, ImageView messenger, int type) {
        source.setVisibility(View.GONE);
        messenger.setVisibility(View.GONE);
        int color = hippoColorConfig.getHippoSourceType();
        switch (type) {
            case 5:
                source.setImageResource(R.drawable.hippo_ic_email);
                source.setVisibility(View.VISIBLE);
                source.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                break;
            case 6:
                messenger.setVisibility(View.VISIBLE);
                break;
            case 7:
                source.setImageResource(R.drawable.hippo_ic_sms);
                source.setVisibility(View.VISIBLE);
                source.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                break;
            default:
                source.setVisibility(View.GONE);
                messenger.setVisibility(View.GONE);
                break;
        }
    }

    class OtherMessageViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llRoot, llChatLeft;
        private TextView tvUserName, tvMsg, tvTime;
        private RelativeLayout rlImageMessage, rlMessages;
        private ImageView ivMsgImage;
        // custom action components
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType, messageSourceType1;
        private ImageView userImage;


        public OtherMessageViewHolder(View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llChatLeft = itemView.findViewById(R.id.llMessageBg);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            rlMessages = itemView.findViewById(R.id.rlMessages);
            ivMsgImage = itemView.findViewById(R.id.ivMsgImage);
            rlCustomAction = itemView.findViewById(R.id.layoutCustomAction);
            tvActionTitle = itemView.findViewById(R.id.tvActionTitle);
            rvActionDescription = itemView.findViewById(R.id.rvActionDescription);
            rvActionButtons = itemView.findViewById(R.id.rvActionButtons);
            ivActionImage = itemView.findViewById(R.id.ivActionImage);
            vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            tvActionTitleDescription = itemView.findViewById(R.id.tvActionDescription);
            llTextualContent = itemView.findViewById(R.id.llTextualContent);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            userImage = itemView.findViewById(R.id.user_image);
        }
    }

    class SelfMessageViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llRoot, llTime;
        private TextView tvMsg, tvTime, tvName;
        private RelativeLayout rlImageMessage, rlMessages;
        private LinearLayout llChat;
        private ImageView ivMessageState, ivMsgImage;
        private ProgressBar pbLoading;
        private Button btnRetry, btnCancel;
        private TextView tvTryAgain;
        private TextView tvCancel;
        private LinearLayout llRetry;
        // custom action components
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType, messageSourceType1;

        public SelfMessageViewHolder(View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llTime = itemView.findViewById(R.id.llTime);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvName = itemView.findViewById(R.id.tvName);
            tvTime = itemView.findViewById(R.id.tvTime);
            llChat = itemView.findViewById(R.id.llMessageBg);
            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            rlMessages = itemView.findViewById(R.id.rlMessages);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);
            ivMsgImage = itemView.findViewById(R.id.ivMsgImage);
            pbLoading = itemView.findViewById(R.id.pbLoading);
            btnRetry = itemView.findViewById(R.id.btnRetry);
            btnCancel = itemView.findViewById(R.id.btnCancel);
            tvTryAgain = itemView.findViewById(R.id.tvTryAgain);
            tvCancel = itemView.findViewById(R.id.tvCancel);
            llRetry = itemView.findViewById(R.id.llRetry);

            rlCustomAction = itemView.findViewById(R.id.layoutCustomAction);
            tvActionTitle = itemView.findViewById(R.id.tvActionTitle);
            rvActionDescription = itemView.findViewById(R.id.rvActionDescription);
            rvActionButtons = itemView.findViewById(R.id.rvActionButtons);
            ivActionImage = itemView.findViewById(R.id.ivActionImage);
            vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            tvActionTitleDescription = itemView.findViewById(R.id.tvActionDescription);
            llTextualContent = itemView.findViewById(R.id.llTextualContent);

            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
        }
    }

    class UserConcentViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout main_root;

        //for right side view
        private LinearLayout llRootRight, llChatRight, llTimeRight;
        private RelativeLayout rlMessagesRight;
        private TextView tvNameRight, tvMsgRight, tvTimeRight;
        private ImageView ivMessageStateRight;

        //for tags
        private TagContainerLayout tagLayout;
        private TextView tvTagsTime;

        //for left side view
        private LinearLayout llChatLeft, llTime;
        private TextView tvUserName, tvMsg, tvTime;
        private LinearLayout leftrootview;

        public UserConcentViewHolder(@NonNull View itemView) {
            super(itemView);
            main_root = itemView.findViewById(R.id.main_root);

            llRootRight = itemView.findViewById(R.id.llRootRight);
            llChatRight = itemView.findViewById(R.id.llChatRight);
            llTimeRight = itemView.findViewById(R.id.llTimeRight);
            rlMessagesRight = itemView.findViewById(R.id.rlMessagesRight);
            tvNameRight = itemView.findViewById(R.id.tvNameRight);
            tvMsgRight = itemView.findViewById(R.id.tvMsgRight);
            tvTimeRight = itemView.findViewById(R.id.tvTimeRight);
            ivMessageStateRight = itemView.findViewById(R.id.ivMessageStateRight);


            tagLayout = itemView.findViewById(R.id.tagLayout);
            tvTagsTime = itemView.findViewById(R.id.tvTagsTime);


            llChatLeft = itemView.findViewById(R.id.llChatLeft);
            llTime = itemView.findViewById(R.id.llTime);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            leftrootview = itemView.findViewById(R.id.leftrootview);
        }
    }

    class SelfVideoViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMsg, tvTime, callAgain, tvDuration;
        private ImageView ivCallIcon;
        public SelfVideoViewHolder(View itemView) {
            super(itemView);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            callAgain = itemView.findViewById(R.id.callAgain);
            tvDuration = itemView.findViewById(R.id.tvDuration);

            ivCallIcon = itemView.findViewById(R.id.ivCallIcon);
        }
    }

    class VideoViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMsg, tvTime, callAgain, tvDuration;
        private ImageView ivCallIcon, userImage;
        private LinearLayout llMessage;
        private LinearLayout llRoot;

        public VideoViewHolder(View itemView) {
            super(itemView);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            callAgain = itemView.findViewById(R.id.callAgain);
            tvDuration = itemView.findViewById(R.id.tvDuration);

            userImage = itemView.findViewById(R.id.user_image);
            ivCallIcon = itemView.findViewById(R.id.ivCallIcon);

            llMessage = itemView.findViewById(R.id.llMessage);
            llRoot = itemView.findViewById(R.id.llMessage);
        }
    }

    class ReceivedFileViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llMessage, llFile, llImages;
        private TextView tvUserName, tvFileName, tvFileSize, tvFileExtension, tvFileTime;
        private ImageView ivFileImage;
        private AppCompatImageView ivFileDownload, ivFilePlay, ivFileUpload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType, messageSourceType1;
        private ImageView userImage;


        public ReceivedFileViewHolder(@NonNull View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llMessage = itemView.findViewById(R.id.llMessage);
            llFile = itemView.findViewById(R.id.llFile);
            llImages = itemView.findViewById(R.id.llImages);

            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvFileName = itemView.findViewById(R.id.tvFileName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvFileExtension = itemView.findViewById(R.id.tvFileExtension);
            tvFileTime = itemView.findViewById(R.id.tvFileTime);

            ivFileImage = itemView.findViewById(R.id.ivFileImage);
            ivFilePlay = itemView.findViewById(R.id.ivFilePlay);
            ivFileDownload = itemView.findViewById(R.id.ivFileDownload);
            ivFileUpload = itemView.findViewById(R.id.ivFileUpload);

            progressBar = itemView.findViewById(R.id.circle_progress);

            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            userImage = itemView.findViewById(R.id.user_image);
        }
    }

    class SentFileViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llMessage, llImages;
        private TextView tvFileName, tvFileSize, tvFileExtension, tvFileTime;
        private AppCompatImageView ivFilePlay, ivFileDownload, ivFileUpload;
        private ImageView ivFileImage, ivMessageState;
        private ProgressWheel circleProgress;
        private ImageView messageSourceType, messageSourceType1;

        public SentFileViewHolder(@NonNull View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llMessage = itemView.findViewById(R.id.llMessage);
            llImages = itemView.findViewById(R.id.llImages);

            tvFileName = itemView.findViewById(R.id.tvFileName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvFileExtension = itemView.findViewById(R.id.tvFileExtension);
            tvFileTime = itemView.findViewById(R.id.tvFileTime);

            ivFileImage = itemView.findViewById(R.id.ivFileImage);
            ivFilePlay = itemView.findViewById(R.id.ivFilePlay);
            ivFileDownload = itemView.findViewById(R.id.ivFileDownload);
            ivFileUpload = itemView.findViewById(R.id.ivFileUpload);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);

            circleProgress = itemView.findViewById(R.id.circle_progress);

            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
        }
    }

    class SelfVideoMessageViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout        llDownload;
        private LinearLayoutCompat  llRoot, llImageMessage;
        private RelativeLayout      rlImageMessage;
        private AppCompatImageView  ivImageMsg, ivMessageState;
        private ImageView           ivPlay, ivDownload;
        private AppCompatTextView tvImageTime;
        private TextView            tvFileSize, tvImgWithText;
        private AppCompatButton btnRetry, btnCancel;
        private ProgressWheel         circle_progress;
        private ImageView messageSourceType, messageSourceType1;

        public SelfVideoMessageViewHolder(View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llImageMessage = itemView.findViewById(R.id.llImageMessage);
            llDownload = itemView.findViewById(R.id.llDownload);

            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            ivImageMsg = itemView.findViewById(R.id.ivImageMsg);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivDownload = itemView.findViewById(R.id.ivDownload);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);

            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvImageTime = itemView.findViewById(R.id.tvImageTime);
            tvImgWithText = itemView.findViewById(R.id.tvImgWithText);
            circle_progress = itemView.findViewById(R.id.circle_progress);
            btnRetry = itemView.findViewById(R.id.btnRetry);
            btnCancel = itemView.findViewById(R.id.btnCancel);

            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);

        }
    }

    class OtherVideoMessageViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llImageMessage;
        private LinearLayout llDownload;
        private TextView tvUserName, tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime, tvImgWithText;
        private ImageView ivPlay, ivDownload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType, messageSourceType1;
        private ImageView userImage;

        public OtherVideoMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llImageMessage = itemView.findViewById(R.id.llImageMessage);
            llDownload = itemView.findViewById(R.id.llDownload);

            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);

            ivImageMsg = itemView.findViewById(R.id.ivImageMsg);
            tvImageTime = itemView.findViewById(R.id.tvImageTime);
            tvImgWithText = itemView.findViewById(R.id.tvImgWithText);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivDownload = itemView.findViewById(R.id.ivDownload);

            progressBar = itemView.findViewById(R.id.circle_progress);

            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);

            userImage = itemView.findViewById(R.id.user_image);

            ivPlay.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.onItemClick(llRoot, itemView, getAdapterPosition());
                }
            });
        }
    }

    class AssignmentViewHolder extends RecyclerView.ViewHolder {
        private TextView tvAssignment;

        public AssignmentViewHolder(View itemView) {
            super(itemView);
            tvAssignment = itemView.findViewById(R.id.tvAssignment);
        }
    }

    class DateViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDate;

        public DateViewHolder(View itemView) {
            super(itemView);
            tvDate = (TextView) itemView.findViewById(R.id.tvDate);
        }


    }

    private void showImageDialog(Context activity, String imgUrl, ImageView imageView, Message message) {

        try {

            if(!Utils.preventMultipleClicks()) {
                return;
            }

            Intent imageIntent = new Intent(context, ImageDisplayActivity.class);
            Image image = new Image(message.getImageUrl(), message.getThumbnailUrl(), message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", image);
            activity.startActivity(imageIntent);
//            ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation(fuguChatActivity, imageView, message.getMuid());
//            activity.startActivity(imageIntent, options.toBundle());
//                showImageDialog(mContext, message.image_url, (selfImageMessageViewHolder.ivImageMessage.drawable as BitmapDrawable).bitmap)
        } catch (Exception e) {
            e.printStackTrace();
        }

        /*try {
            final Dialog dialog = new Dialog(context, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.fugu_image_dialog);
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = 1.0f; // Dim level. 0.0 - no dim, 1.0 - completely opaque
            dialog.getWindow().setAttributes(lp);
            dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);

            //adding text dynamically
            ZoomageView ivImage = dialog.findViewById(R.id.ivImage);
            RequestOptions myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                    .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
            Glide.with(context).load(imgUrl)
                    .apply(myOptions)
                    .into(ivImage);
            //adding button click event
            TextView tvCross = (TextView) dialog.findViewById(R.id.tvCross);
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }*/

    }

    private void setTimeView(TextView tvMsg, RelativeLayout rlMessages, View time, int itemType, Message message, int position) {
        View vTime;
        if (itemType == ITEM_TYPE_OTHER) {
            vTime = (TextView) time;
        } else {
            vTime = (LinearLayout) time;
        }
        int lineCount = 0;
        int difference = 0;
        lineCount = tvMsg.getLineCount();
        String stringInLastLine;
        if (lineCount != 0) {
            difference = tvMsg.getLayout().getLineStart(lineCount) - tvMsg.getLayout().getLineStart(lineCount - 1);
        }
        String completeString = tvMsg.getText().toString();
        boolean lineCountGreater = lineCount > 1;

        if (lineCountGreater) {
            stringInLastLine = completeString.substring(tvMsg.getText().toString().length() - difference, tvMsg.getText().toString().length());
        } else {
            stringInLastLine = tvMsg.getText().toString();
        }

        float emptySpaceLeft = rlMessages.getMeasuredWidth() - tvMsg.getPaint().measureText(stringInLastLine);
        RelativeLayout.LayoutParams layout = (RelativeLayout.LayoutParams) vTime.getLayoutParams();
        if (emptySpaceLeft > context.getResources().getDimensionPixelSize(R.dimen.height_ll_time)) {
            if (lineCountGreater) {
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                layout.addRule(RelativeLayout.RIGHT_OF, -1);
                message.setTimeIndex(2);
            } else {
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
                layout.addRule(RelativeLayout.RIGHT_OF, tvMsg.getId());
                message.setTimeIndex(3);
            }
            layout.addRule(RelativeLayout.BELOW, -1);
            layout.addRule(RelativeLayout.ALIGN_BOTTOM, tvMsg.getId());
        } else {
            if (!tvMsg.getText().toString().contains("/n")) {
                layout.addRule(RelativeLayout.ALIGN_BOTTOM, -1);
                layout.addRule(RelativeLayout.RIGHT_OF, -1);
                layout.addRule(RelativeLayout.BELOW, tvMsg.getId());
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                message.setTimeIndex(1);
            }
        }
        vTime.setLayoutParams(layout);
    }

    private String convertSeconds(int seconds) {
        int h = seconds / 3600;
        int m = (seconds % 3600) / 60;
        int s = seconds % 60;
        String sh = (h > 0 ? String.valueOf(h) + " " + "h" : "");
        String sm = (m < 10 && m > 0 && h > 0 ? "0" : "") + (m > 0 ? (h > 0 && s == 0 ? String.valueOf(m) : String.valueOf(m) + " " + "min") : "");
        String ss = (s == 0 && (h > 0 || m > 0) ? "" : (s < 10 && (h > 0 || m > 0) ? "0" : "") + String.valueOf(s) + " " + "sec");
        return sh + (h > 0 ? " " : "") + sm + (m > 0 ? " " : "") + ss;
    }

    private String getMessage(Message videoMessage, int userType) {
        String message = "The video call ended";
        String agentType = "you";
        if(userType == FUGU_VIDEO_CALL_VIEW) {
            if(videoMessage.getUserId().intValue() != AgentCommonData.getUserData().getUserId().intValue())
                agentType = videoMessage.getfromName();
            if (videoMessage.getMessageState() != null && videoMessage.getMessageState().intValue() == 2) {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = customerName + " missed a voice call with "+agentType;
                else
                    message = customerName + " missed a video call with "+agentType;
            } else {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "The voice call ended";
                else
                    message = "The video call ended";
            }
        } else {
            agentType = "You";
            if(!isChatAssignToMe)
                agentType = agentName;

            if(videoMessage.getMessageState() != null && videoMessage.getMessageState().intValue() == 2) {
                if(!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = agentType+" missed a voice call with "+videoMessage.getfromName();
                else
                    message = agentType+" missed a video call with "+videoMessage.getfromName();
            } else {
                if(!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "The voice call ended";
                else
                    message = "The video call ended";
            }
        }
        return message;
    }


    private void setTime(AppCompatTextView tvImageTime, String sentAtUtc) {
        tvImageTime.setText(DateUtils.getTime(dateUtil.convertToLocal(sentAtUtc)));
    }

    private void showImageView(ImageView imageView, Message message) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(DocumentType.IMAGE.toString()));
        HippoLog.e("localPath", "localPath = "+localPath);
        RequestOptions myOptions = RequestOptions
                .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));

        Glide.with(context).load(TextUtils.isEmpty(localPath) ? message.getThumbnailUrl() : new File(localPath))
                .apply(myOptions)
                .into(imageView);
    }

    private void setMessageStatus(AppCompatImageView ivMessageState, int messageStatus, Boolean isImage) {
        if (isImage) {
            switch (messageStatus) {
                case MESSAGE_SENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single_white));
                    break;
                case MESSAGE_UNSENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                case MESSAGE_DELIVERED:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                    break;
                case MESSAGE_READ:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                    break;
                case MESSAGE_FILE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                case MESSAGE_IMAGE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                default:

                    break;
            }
        } else {
            switch (messageStatus) {
                case MESSAGE_SENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                    break;
                case MESSAGE_UNSENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;
                case MESSAGE_DELIVERED:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                    break;
                case MESSAGE_READ:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_double));
                    break;
                case MESSAGE_FILE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;
                case MESSAGE_IMAGE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;

                default:

                    break;
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout rlImageMessage, LinearLayoutCompat llImageMessage, Message message, Boolean isSpiked) {
        int imageHeight = message.getImageHeight();
        int imageWidth = message.getImageWidth();
        if (imageHeight != 0 && message.getImageWidth() != 0) {
            float ratio = (float) (imageHeight / imageWidth);
            if (ratio < 1) {
                rlImageMessage.getLayoutParams().height = (int)(pxToDp(FuguAppConstant.MAX_HEIGHT) * ratio);
                rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
                if (isSpiked) {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
                } else {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
                }
            } else {
                rlImageMessage.getLayoutParams().height = pxToDp(FuguAppConstant.MAX_HEIGHT);
                rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
                if (isSpiked) {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
                } else {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
                }
            }
        } else {
            rlImageMessage.getLayoutParams().height = pxToDp(FuguAppConstant.MAX_HEIGHT);
            rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
            if (isSpiked) {
                llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
            } else {
                llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
            }
        }
    }

    private void setVideoDownloadStatus(final LinearLayout videoDownloadStatus, ImageView playBtn, TextView fileSize, final ProgressWheel progressBar, final Message message, final int position) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(message.getDocumentType()));
        videoDownloadStatus.setVisibility(View.GONE);
        progressBar.setVisibility(View.GONE);
        playBtn.setVisibility(View.GONE);

        if(!TextUtils.isEmpty(localPath) &&
                (message.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                        || message.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                        || message.getMessageStatus() == FuguAppConstant.MESSAGE_SENT)) {
            playBtn.setVisibility(View.VISIBLE);
        } else {
            switch (message.getDownloadStatus()) {
                case 1:
                    progressBar.setVisibility(View.VISIBLE);
                    break;
                case 3:
                    playBtn.setVisibility(View.VISIBLE);
                    break;
                default:
                    videoDownloadStatus.setVisibility(View.VISIBLE);
                    fileSize.setText(message.getFileSize());
                    break;
            }
        }
    }

    private void setVideoUiStatus(boolean isSelf, Message message, LinearLayout download, ImageView playBtn,
                                  AppCompatButton btnRetry, AppCompatButton btnCancel, ProgressWheel progress) {

        if(isSelf) {

            download.setVisibility(View.GONE);
            playBtn.setVisibility(View.GONE);
            btnRetry.setVisibility(View.GONE);
            btnCancel.setVisibility(View.GONE);
            progress.setVisibility(View.GONE);

            if(message.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                    || message.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                    || message.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
                //sent
                String fname = Util.getFileName(message.getFileName(), message.getMuid());
                final String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(message.getDocumentType()));
                if(TextUtils.isEmpty(localPath)) {
                    // show download
                    download.setVisibility(View.VISIBLE);
                } else {
                    //show play button
                    playBtn.setVisibility(View.VISIBLE);
                }
            } else {
                //unsent
                if(message.getUploadStatus() == FuguAppConstant.UPLOAD_IN_PROGRESS) {
                    // show loader
                    progress.setVisibility(View.VISIBLE);

                    //message.setUploadStatus(FuguAppConstant.UPLOAD_FAILED);

                } else if(message.getIsMessageExpired() == 1) {
                    //retry
                    btnRetry.setVisibility(View.VISIBLE);
                    btnCancel.setVisibility(View.VISIBLE);
                }
            }
        } else {

        }
    }

    private void setVideoUploadStatus(AppCompatTextView tvImageTime, ProgressWheel circleProgress, AppCompatButton fuguBtnRetry,
                                      ImageView ivPlay, Message currentOrderItem2, ImageView ivDownload) {
        switch (currentOrderItem2.getUploadStatus()) {
            case FuguAppConstant.UPLOAD_FAILED:
                if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
                    circleProgress.setVisibility(View.GONE);
                    fuguBtnRetry.setVisibility(View.GONE);
                    ivPlay.setVisibility(View.VISIBLE);

                } else {
                    fuguBtnRetry.setVisibility(View.VISIBLE);
                    circleProgress.setVisibility(View.GONE);
                    ivPlay.setVisibility(View.GONE);
                }
                break;
            case FuguAppConstant.UPLOAD_IN_PROGRESS:
                circleProgress.setVisibility(View.VISIBLE);
                fuguBtnRetry.setVisibility(View.GONE);
                ivPlay.setVisibility(View.GONE);
                break;
            case FuguAppConstant.UPLOAD_COMPLETED:
                circleProgress.setVisibility(View.GONE);
                fuguBtnRetry.setVisibility(View.GONE);

                if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
                    ivPlay.setVisibility(View.VISIBLE);
                } else {
                    ivPlay.setVisibility(View.GONE);
                }
                break;
            default:
                // TODO: 17/01/19 update here.
                tvImageTime.append("10");
                circleProgress.setVisibility(View.GONE);
                fuguBtnRetry.setVisibility(View.GONE);

                if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                        || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
                    ivPlay.setVisibility(View.VISIBLE);
                } else {
                    ivPlay.setVisibility(View.GONE);
                }
                break;
        }
        if (currentOrderItem2.getIsMessageExpired() == 1) {
            fuguBtnRetry.setVisibility(View.VISIBLE);
        } else if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                || currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
            circleProgress.setVisibility(View.GONE);
            fuguBtnRetry.setVisibility(View.GONE);
            ivPlay.setVisibility(View.VISIBLE);
            String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname,
                    FOLDER_TYPE.get(DocumentType.VIDEO.toString()));
            if(TextUtils.isEmpty(localPath)) {
                ivDownload.setVisibility(View.VISIBLE);
                ivPlay.setVisibility(View.GONE);
            }
        }
    }

    private void setFileCLickListener(LinearLayoutCompat llFile, final Message message, final AppCompatImageView ivFilePlay,
                                      final int position) {
        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(message, ivFilePlay, position);
            }
        });

        llFile.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    if(message.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString())) {

                        return;
                    }
                    String fname = Util.getFileName(message.getFileName(), message.getMuid());
                    final String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(message.getDocumentType()));
                    if(!TextUtils.isEmpty(localPath)) {
                        FileManager.getInstance().openFileInDevice(context, localPath, new FileManager.FileCopyListener() {
                            @Override
                            public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {

                            }

                            @Override
                            public void largeFileSize() {

                            }

                            @Override
                            public void onError() {
                                Toast.makeText(context, context.getString(R.string.no_handler), Toast.LENGTH_LONG).show();
                            }
                        });
                    }
                } catch (Exception e) {
                    if(HippoConfig.DEBUG)
                        e.printStackTrace();
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload,
                                       AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        ivFileDownload.setVisibility(View.GONE);
        circleProgress.setVisibility(View.GONE);
        ivFileUpload.setVisibility(View.GONE);
        ivFilePlay.setVisibility(View.GONE);

        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        HippoLog.v("localPath", "localPath ********* = "+localPath);
        if (!TextUtils.isEmpty(localPath)) {
            if(currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                ivFilePlay.setVisibility(View.VISIBLE);
        } else {
            switch (currentOrderItem2.getDownloadStatus()) {
                case 1:
                    circleProgress.setVisibility(View.VISIBLE);
                    break;
                case 3:
                    if(currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                        ivFilePlay.setVisibility(View.VISIBLE);
                    break;
                default:
                    ivFileDownload.setVisibility(View.VISIBLE);
                    break;
            }
        }

        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void setFileUploadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload,
                                     AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {

        ivFileDownload.setVisibility(View.GONE);
        circleProgress.setVisibility(View.GONE);
        ivFileUpload.setVisibility(View.GONE);
        ivFilePlay.setVisibility(View.GONE);
        if (currentOrderItem2.getIsMessageExpired() == 1) {
            ivFileUpload.setVisibility(View.VISIBLE);
        } else {
            if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_UNSENT) {
                switch (currentOrderItem2.getUploadStatus()) {
                    case FuguAppConstant.UPLOAD_FAILED:
                        ivFileUpload.setVisibility(View.VISIBLE);
                        break;
                    case FuguAppConstant.UPLOAD_IN_PROGRESS:
                        circleProgress.setVisibility(View.VISIBLE);
                        break;
                    case FuguAppConstant.UPLOAD_COMPLETED:
                        if(currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                            ivFilePlay.setVisibility(View.VISIBLE);
                        break;
                    default:

                        break;
                }
            } else {
                String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
                String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
                HippoLog.v("localPath", "localPath ********* = "+currentOrderItem2.getFileName());
                if (!TextUtils.isEmpty(localPath)) {
                    if(currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                        ivFilePlay.setVisibility(View.VISIBLE);
                } else {
                    ivFileDownload.setVisibility(View.VISIBLE);
                }
            }
        }

        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void onPlaySound(final Message currentOrderItem2, final AppCompatImageView ivFilePlay, final int position) {
        if (!TextUtils.isEmpty(context.audioMuid)) {
            if(context.audioMuid.equalsIgnoreCase(currentOrderItem2.getMuid())) {
                context.audioMuid = "";
                currentOrderItem2.setAudioPlaying(false);
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
                return;
            } else {
                ListItem listItem = items.get(context.playingItem);
                ((EventItem) listItem).getEvent().setAudioPlaying(false);
                notifyItemChanged(context.playingItem);

            }
            //return;
        }

        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer(context, localPath, new CommonMediaPlayer.MediaPlayerStatus() {
            @Override
            public void onPlaying() {
                currentOrderItem2.setAudioPlaying(true);
                context.audioMuid = currentOrderItem2.getMuid();
                context.playingItem = position;
                ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                currentOrderItem2.setAudioPlaying(true);
                notifyItemChanged(position);
            }

            @Override
            public void onCompletion(MediaPlayer mp) {
                context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
            }
        });
    }


    private void setDownloadClick(final AppCompatImageView ivFileDownload, final ProgressWheel circleProgress, final Message message, final int position) {
        if(!context.isNetworkAvailable()) {

            return;
        }
        ivFileDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if(!context.checkPermission()) {
                    context.readExternalStorage();
                    return;
                }
                circleProgress.setVisibility(View.VISIBLE);

                //circleProgress.getProgressDrawable().setColorFilter(hippoColorConfig.getHippoThemeColorPrimary(), PorterDuff.Mode.SRC_IN);
                ivFileDownload.setVisibility(View.GONE);

                String docType = "image";
                if(message.getMessageType() == FILE_MESSAGE) {
                    docType = message.getDocumentType();
                }

                String fileName = message.getFileName();

                if(TextUtils.isEmpty(fileName)) {
                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    fileName = "Hippochat_" + timeStamp + ".jpg";
                }

                //fuguChatActivity.readExternalStorage();

                String fullPath = Util.getOrCreateDirectoryPath(FOLDER_TYPE.get(docType));
                int downloadId = downloadFileFromUrl(fullPath, fileName, message, position);

                message.setDownloadId(downloadId);
            }
        });
    }

    int currentProgress = -1;
    private int downloadFileFromUrl(String dirPath, String fileName, final Message message, final int position) {
        if(!fileName.contains(message.getMuid())) {
            String muid = message.getMuid();
            String ext = Util.getExtension(fileName);
            String name = Util.extractFileNameWithoutSuffix(fileName);
            fileName = name + "_" + muid + "." + ext;
        }
        currentProgress = -1;
        return PRDownloader.download(message.getFileUrl(), dirPath, fileName)
                .build()
                .setOnStartOrResumeListener(new OnStartOrResumeListener() {
                    @Override
                    public void onStartOrResume() {
                        HippoLog.v(TAG, "OnStartOrResumeListener");
                    }
                })
                .setOnPauseListener(new OnPauseListener() {
                    @Override
                    public void onPause() {
                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_PAUSED.downloadStatus);
                    }
                })
                .setOnProgressListener(new OnProgressListener() {
                    @Override
                    public void onProgress(Progress progress) {
                        int cProgress = (int)((progress.currentBytes * 100)/ progress.totalBytes);
                        if(currentProgress < cProgress) {
                            currentProgress++;
                            //Intent mIntent = getIntentExtraData(position, cProgress, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
                            //LocalBroadcastManager.getInstance(activity).sendBroadcast(mIntent);
                        }

                        message.setCurrentprogress(cProgress);
                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
                    }
                })
                .start(new OnDownloadListener() {
                    @Override
                    public void onDownloadComplete() {
                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                        Intent mIntent = getIntentExtraData(position, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                        LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);
                    }

                    @Override
                    public void onError(com.downloader.Error error) {
                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                        Intent mIntent = getIntentExtraData(position, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                        LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);
                    }
                });

    }

    private Intent getIntentExtraData(int position, int progress, String muid, int status) {
        Intent mIntent = new Intent(HIPPO_PROGRESS_INTENT);
        mIntent.putExtra(HIPPO_POSITION, position);
        mIntent.putExtra(HIPPO_PROGRESS, progress);
        mIntent.putExtra(MESSAGE_UNIQUE_ID, muid);
        mIntent.putExtra(HIPPO_STATUS_UPLOAD, status);
        return mIntent;
    }

    private void messageStatusTick(Activity activity, ImageView fuguIvMessageState, Message currentOrderItem2) {
        switch (currentOrderItem2.getMessageStatus()) {
            case MESSAGE_UNSENT:
            case MESSAGE_IMAGE_RETRY:
            case MESSAGE_FILE_RETRY:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.fugu_ic_waiting));
                fuguIvMessageState.setVisibility(View.VISIBLE);
                fuguIvMessageState.getDrawable()
                        .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            case MESSAGE_READ:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.fugu_tick_double));
                fuguIvMessageState.getDrawable()
                        .setColorFilter(hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                fuguIvMessageState.setVisibility(View.VISIBLE);
                break;
            case MESSAGE_SENT:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(View.VISIBLE);
                fuguIvMessageState.getDrawable()
                        .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            case MESSAGE_DELIVERED:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.fugu_tick_double));
                if (Build.VERSION.SDK_INT >= 21) {
                    fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor(activity, R.color.fugu_drawable_color));
                }
                fuguIvMessageState.setVisibility(View.VISIBLE);
                fuguIvMessageState.getDrawable()
                        .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            default:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(View.VISIBLE);
                fuguIvMessageState.getDrawable()
                        .setColorFilter(hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);

                break;
        }
    }

    private void setUploadClick(AppCompatImageView ivFileUpload, ProgressWheel circleProgress, Message message) {
        ivFileUpload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(context.isNetworkAvailable()) {
                    if (mOnRetry != null) {

                    }
                }
            }
        });
    }

    private boolean setOtherMessageBackground(View viewMessage, View viewBg, int position, TextView viewUsername){
        int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);
        int eight = pxToDp(8);

        if (items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eight, sevenDp, 0, oneDp);
            viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
            return true;
        } else {
            if (position == 0) {
                viewMessage.setPadding(eight, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
                if (viewUsername != null) {
                    viewUsername.setPadding(eight, 0, 0, 0);
                }
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);

                return true;
            } else if (getItemViewType(position - 1) == ITEM_TYPE_OTHER
                    || getItemViewType(position - 1) == FUGU_OTHER_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_OTHER) {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
                if (viewUsername != null) {
                    viewUsername.setVisibility(View.GONE);
                }
                viewMessage.setPadding(pxToDp(15), oneDp, 0, oneDp);
                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                return false;
            } else {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                viewMessage.setPadding(eight, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
                return true;
            }
        }
    }

    private boolean setSelfMessageBackground(View viewMessage, View viewBg, int position) {
        int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);

        if (items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
            viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
            return true;
        } else {
            if (position == 0) {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
                viewMessage.setPadding(0, sixDp, pxToDp(7), sevenDp);
                viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
                return true;
            } else if (getItemViewType(position - 1) == ITEM_TYPE_SELF
                    || getItemViewType(position - 1) == FUGU_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_FILE_SENT_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_SELF) {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
                viewMessage.setPadding(0, oneDp, pxToDp(15), oneDp);
                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                return false;
            } else {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
                viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
                viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
                return true;
            }
        }
    }

    private boolean setFileMessageOther(View viewMessage, View viewBg, int position, TextView userName, String name) {
        int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);
        int eightDp = pxToDp(8);
        if (items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
            if(userName != null) {
                userName.setVisibility(View.VISIBLE);
                userName.setText(name);
            } else if(TextUtils.isEmpty(name))
                userName.setVisibility(View.GONE);
            return true;
        } else {
            if (position == 0) {
                viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                if(userName != null) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if(TextUtils.isEmpty(name))
                    userName.setVisibility(View.GONE);
                return true;
            } else if (getItemViewType(position - 1) == ITEM_TYPE_OTHER
                    || getItemViewType(position - 1) == FUGU_OTHER_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_OTHER
                    || getItemViewType(position - 1) == HIPPO_FILE_RECEIVED_VIEW) {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                viewMessage.setPadding(pxToDp(15), oneDp, 0, oneDp);
                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                if(userName != null) {
                    userName.setVisibility(View.GONE);
                }
                return true;
            } else {
                viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);

                viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
                if(userName != null) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if(TextUtils.isEmpty(name))
                    userName.setVisibility(View.GONE);

                return true;
            }
        }
    }

    private void setImage(Activity activity, AppCompatImageView ivImageMessage, String thumbnailUrl) {
        try {
            HippoLog.e(TAG, "thumbnailUrl = "+thumbnailUrl);
            RequestOptions myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(activity, 7, 2))
                    .placeholder(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .error(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder));
            Glide.with(activity).load(thumbnailUrl)
                    .apply(myOptions)
                    .into(ivImageMessage);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}
