package com.hippo.agent.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.agent.model.broadcastStatus.BroadcastInfo;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;

import java.util.ArrayList;

/**
 * Created by gurmail on 30/07/18.
 *
 * @author gurmail
 */


public class BroadcastStatusAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = BroadcastStatusAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadCastObjectModel> arrayList = new ArrayList<>();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;

    public BroadcastStatusAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadCastObjectModel> arrayList) {
        this.arrayList = arrayList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        hippoColorConfig = CommonData.getColorConfig();
        if (viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.hippo_layout_loaddata, parent, false));
        } else {
            return new ViewHolder(LayoutInflater.from(context)
                    .inflate(R.layout.hippo_item_broadcast_status, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder) holder;
            BroadCastObjectModel objectModel = arrayList.get(position);
            viewHolder.textViewFromValue.setText(objectModel.getFullName());
            String localDate = DateUtils.getInstance().convertToLocal(objectModel.getCreatedAt(), STANDARD_DATE_FORMAT_TZ, OUTPUT_FORMAT);
            viewHolder.textViewDateValue.setText(localDate);
            viewHolder.textViewTitleValue.setText(objectModel.getBroadcastTitle());
            Utils.setColor(context, viewHolder.textViewMsgValue, objectModel.getMessage());
            if (!TextUtils.isEmpty(objectModel.getFallbackText())) {
                viewHolder.textViewFallbackValue.setText(objectModel.getFallbackText());
                viewHolder.rlFallback.setVisibility(View.VISIBLE);
            } else {
                viewHolder.rlFallback.setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(objectModel.getBroadcastType())) {
                viewHolder.layoutType.setVisibility(View.VISIBLE);
                if (objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                    viewHolder.textViewTypeValue.setText("Email");
                } else {
                    viewHolder.textViewTypeValue.setText("In App");
                }
            } else {
                viewHolder.layoutType.setVisibility(View.GONE);
            }
        }
    }


    @Override
    public int getItemCount() {
        return arrayList == null ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (arrayList.get(position).getChannelId().equals(-1)) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        private ImageView arrow;
        private RelativeLayout relative, rlFallback, layoutType;
        private TextView textViewFrom, textViewDate, textViewTitle, textViewMsg, textViewFallback, textViewType;
        private TextView textViewFromValue, textViewDateValue, textViewTitleValue, textViewMsgValue, textViewFallbackValue, textViewTypeValue;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            arrow = itemView.findViewById(R.id.arrow);

            relative = itemView.findViewById(R.id.relative);
            rlFallback = itemView.findViewById(R.id.rlFallback);
            layoutType = itemView.findViewById(R.id.layoutType);

            textViewFrom = itemView.findViewById(R.id.textViewFrom);
            textViewDate = itemView.findViewById(R.id.textViewDate);
            textViewTitle = itemView.findViewById(R.id.textViewTitle);
            textViewMsg = itemView.findViewById(R.id.textViewMsg);
            textViewFallback = itemView.findViewById(R.id.textViewFallback);
            textViewType = itemView.findViewById(R.id.textViewType);

            textViewFromValue = itemView.findViewById(R.id.textViewFromValue);
            textViewDateValue = itemView.findViewById(R.id.textViewDateValue);
            textViewTitleValue = itemView.findViewById(R.id.textViewTitleValue);
            textViewMsgValue = itemView.findViewById(R.id.textViewMsgValue);
            textViewFallbackValue = itemView.findViewById(R.id.textViewFallbackValue);
            textViewTypeValue = itemView.findViewById(R.id.textViewTypeValue);


            textViewFrom.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewDate.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewTitle.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewMsg.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewFallback.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewType.setTextColor(hippoColorConfig.getHippoTextColorSecondary());

            textViewFromValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewDateValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewTitleValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewMsgValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewFallbackValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewTypeValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());

            applyThemeToDrawable(hippoColorConfig.getHippoThemeColorPrimary(), arrow);
            relative.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (onItemClickListener != null)
                        onItemClickListener.onClickItem(getAdapterPosition());
                }
            });
        }
    }

    public void applyThemeToDrawable(int color, ImageView imageView) {
        final Resources.Theme theme = context.getResources().newTheme();
        final Drawable drawable = ResourcesCompat.getDrawable(context.getResources(), R.drawable.hippo_ic_arrow, theme);

        if (drawable != null) {
            PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(color,
                    PorterDuff.Mode.SRC_ATOP);

            drawable.setColorFilter(porterDuffColorFilter);
        }

        imageView.setImageDrawable(drawable);
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
//            loadmoreBinding = DataBindingUtil.bind(itemView);
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if (arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getChannelId() != null
                && arrayList.get(arrayList.size() - 1).getChannelId().intValue() == -1;
        if (show) {
            if (!isProgressBarExist) {
                arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        } else {
            if (arrayList.remove(ProgressBarModel.getInstance())) {
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }

        }

    }

    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (progressBarDisplayRunnable == null) {
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static BroadCastObjectModel progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadCastObjectModel getInstance() {
            if (progressBarModel == null)
                progressBarModel = new BroadCastObjectModel(-1);
            return progressBarModel;
        }
    }
}

