package com.hippo.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.promotional.Data;
import com.hippo.utils.DateUtils;
import com.hippo.utils.RoundedCornersTransformation;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-12-23.
 *
 * @author gurmail
 */
public class CampaignAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context mContext;
    private OnItemClickListener itemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<Data> arrayList;
    private RecyclerView recyclerView;

    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;


    private String outputFormat = "dd MMM, yy h:mm a";

    public CampaignAdapter(ArrayList<Data> arrayList, RecyclerView recyclerView, OnItemClickListener itemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        hippoColorConfig = CommonData.getColorConfig();
        if (HippoConfig.getInstance().getMobileCampaignBuilder() != null &&
                !TextUtils.isEmpty(HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat()))
            outputFormat = HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat();
    }

    public void setData(ArrayList<Data> arrayList) {
        this.arrayList = arrayList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        mContext = viewGroup.getContext();
        if (viewType == VIEW_TYPE_LOADING) {
            return new LoadMoreHolder(LayoutInflater.from(mContext)
                    .inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        } else {
            return new ViewHolder(LayoutInflater.from(mContext).inflate(R.layout.hippo_item_campaign, viewGroup, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int pos) {
        if (holder instanceof CampaignAdapter.ViewHolder) {
            CampaignAdapter.ViewHolder viewHolder = (ViewHolder) holder;
            viewHolder.title.setText(arrayList.get(pos).getTitle());
            //viewHolder.description.setShowingLine(2);
            viewHolder.description.setText(arrayList.get(pos).getDescription());

            String time = DateUtils.getInstance().convertToLocal(arrayList.get(pos).getCreatedAt(), outputFormat);
            viewHolder.dateTime.setText(time);

            String imagePath = "";

            try {
                imagePath = arrayList.get(pos).getCustomAttributes().getImage().getImageUrl();
            } catch (Exception e) {

            }

            if (TextUtils.isEmpty(imagePath)) {
                viewHolder.imageView.setVisibility(View.GONE);
            } else {
                viewHolder.imageView.setVisibility(View.VISIBLE);
                RequestOptions myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(mContext, 4, 1))
                        .placeholder(ContextCompat.getDrawable(mContext, R.drawable.hippo_placeholder))
                        .fitCenter()
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(mContext, R.drawable.hippo_placeholder));
                Glide.with(mContext).load(imagePath)
                        .apply(myOptions)
                        .into(viewHolder.imageView);

            }
        }
    }

    @Override
    public int getItemCount() {
        return (arrayList == null) ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (arrayList.get(position).getUserId() == -3) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);

        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private ImageView imageView;
        private TextView title;
        private TextView description;
        private TextView dateTime;
        private LinearLayout mainLayout;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            mainLayout = itemView.findViewById(R.id.mainLayout);
            imageView = itemView.findViewById(R.id.ivImage);
            title = itemView.findViewById(R.id.tvTitle);
            description = itemView.findViewById(R.id.tvDescription);
            dateTime = itemView.findViewById(R.id.tvDateTime);

            title.setTextColor(hippoColorConfig.getHippoPromotionalTitle());
            description.setTextColor(hippoColorConfig.getHippoPromotionalMessage());
            dateTime.setTextColor(hippoColorConfig.getHippoPromotionalTime());


            mainLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (itemClickListener != null) {
                        itemClickListener.onClickListener(getAdapterPosition());
                    }
                }
            });
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if(arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getUserId() == -3;
        if(show) {
            if (!isProgressBarExist) {
                arrayList.add(CampaignAdapter.ProgressBarModel.getInstance());
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        }else{
            if(arrayList.remove(CampaignAdapter.ProgressBarModel.getInstance())){
                if(notifyAdapter){
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }

        }

    }
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;
    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position){
        if(progressBarDisplayRunnable == null){
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static Data progressBarModel;
        private ProgressBarModel() {
        }
        public static Data getInstance(){
            if(progressBarModel ==null)
                progressBarModel = new Data(-3);
            return progressBarModel;
        }
    }
}