package com.hippo.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.model.ContentValue;
import com.hippo.model.Message;
import com.hippo.support.Utils.Constants;

import java.util.ArrayList;

/**
 * Created by gurmail on 11/02/19.
 *
 * @author gurmail
 */
public class ButtonsAdapter extends RecyclerView.Adapter<ButtonsAdapter.ViewHolder> implements OnRecyclerListener {

    private static final String TAG = ButtonsAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<ContentValue> arrayList;
    private String selectedBtnId;
    private UserConcentListener userConcentListener;
    private Message message;
    private RecyclerView recyclerView;
    private int isActive = 1;
    private String alpha = "#66";

    public ButtonsAdapter(Context context, Message message, ArrayList<ContentValue> arrayList,
                          UserConcentListener userConcentListener, RecyclerView recyclerView, int isActive) {
        this.context = context;
        this.arrayList = arrayList;
        this.userConcentListener = userConcentListener;
        this.recyclerView = recyclerView;
        this.isActive = isActive;
        this.message = message;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from(viewGroup.getContext())
                .inflate(R.layout.hippo_action_button, viewGroup, false), this);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int pos) {
        viewHolder.button.setText(arrayList.get(pos).getBtnTitle());
        viewHolder.button.setEnabled(isActive != 0);
        viewHolder.button.setClickable(isActive != 0);

        selectedBtnId = message.getSelectedBtnId();
        String textColor = arrayList.get(pos).getBtnTitleColor();
        String btnColor = arrayList.get(pos).getBtnColor();
        String btnStrokeColor = arrayList.get(pos).getBtnTitleColor();
//        if(!TextUtils.isEmpty(selectedBtnId) && selectedBtnId.equalsIgnoreCase(arrayList.get(pos).getBtnId())) {
//            textColor = arrayList.get(pos).getBtnTitleSelectedColor();
//            btnColor = arrayList.get(pos).getBtnSelectedColor();
//            btnStrokeColor = arrayList.get(pos).getBtnSelectedColor();
//        }

        if(!TextUtils.isEmpty(selectedBtnId)) {
            if(selectedBtnId.equalsIgnoreCase(arrayList.get(pos).getBtnId())) {
                textColor = arrayList.get(pos).getBtnTitleSelectedColor().replace("#", "");
                btnColor = arrayList.get(pos).getBtnSelectedColor().replace("#", "");
                btnStrokeColor = arrayList.get(pos).getBtnSelectedColor().replace("#", "");

                textColor = alpha+textColor;
                btnColor = alpha+btnColor;
                btnStrokeColor = alpha+btnStrokeColor;
            }  else {
                textColor = arrayList.get(pos).getBtnTitleColor().replace("#", "");
                btnColor = arrayList.get(pos).getBtnColor().replace("#", "");
                btnStrokeColor = arrayList.get(pos).getBtnTitleColor().replace("#", "");

                textColor = alpha+textColor;
                btnColor = alpha+btnColor;
                btnStrokeColor = alpha+btnStrokeColor;
            }
        }

        viewHolder.button.setTextColor(Color.parseColor(textColor));
        int radius = (int) Constants.convertDpToPixel(1);
        GradientDrawable drawable = (GradientDrawable) viewHolder.button.getBackground();
        drawable.setStroke(radius, Color.parseColor(btnStrokeColor));
        drawable.setColor(Color.parseColor(btnColor));
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = recyclerView.getChildLayoutPosition(parentView);
        if(positionInList!=RecyclerView.NO_POSITION) {
            String btnId = arrayList.get(positionInList).getBtnId();
            selectedBtnId = btnId;
            message.setSelectedBtnId(btnId);
            userConcentListener.onUserConcent(positionInList, btnId, message);
            isActive = 0;
            notifyDataSetChanged();
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        AppCompatButton button;
        public ViewHolder(@NonNull final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            button = itemView.findViewById(R.id.button);
            button.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.onItemClick(button, itemView, getAdapterPosition());
                }
            });
        }
    }
}
