/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.widget.ProgressBar;
import com.hippo.R;
import com.hippo.utils.filepicker.DividerGridItemDecoration;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.ImageDirectoryAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.adapter.VideoPickAdapter;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class VideoPickActivity
extends BaseActivity {
    public static final String THUMBNAIL_PATH = "FilePick";
    public static final String IS_NEED_CAMERA = "IsNeedCamera";
    public static final String IS_TAKEN_AUTO_SELECTED = "IsTakenAutoSelected";
    private final int COLUMN_NUMBER = 2;
    private RecyclerView mRecyclerView;
    private VideoPickAdapter mAdapter;
    private ImageDirectoryAdapter directoryAdapter;
    private boolean isNeedCamera;
    private boolean isTakenAutoSelected;
    private ArrayList<VideoFile> mSelectedList = new ArrayList();
    private ProgressBar mProgressBar;
    private GridLayoutManager layoutManager;
    private boolean isDirectory;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        this.loadData();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.isNeedCamera = this.getIntent().getBooleanExtra(IS_NEED_CAMERA, false);
        this.isTakenAutoSelected = this.getIntent().getBooleanExtra(IS_TAKEN_AUTO_SELECTED, true);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pb_file_pick);
        this.setSupportActionBar(this.myToolbar);
        this.setToolbar(this.myToolbar, "Video Picker");
        this.layoutManager = new GridLayoutManager((Context)this, 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerGridItemDecoration((Context)this));
        this.mAdapter = new VideoPickAdapter((Context)this, this.isNeedCamera);
        this.directoryAdapter = new ImageDirectoryAdapter((Context)this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        this.directoryAdapter.setOnSelectStateListener(new OnSelectStateListener<Directory>(){

            @Override
            public void OnSelectStateChanged(boolean state, Directory file) {
                VideoPickActivity.this.isDirectory = true;
                VideoPickActivity.this.layoutManager.setSpanCount(3);
                VideoPickActivity.this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)VideoPickActivity.this.layoutManager);
                ArrayList list = new ArrayList();
                list.addAll(file.getFiles());
                VideoPickActivity.this.mAdapter.refresh(list);
                VideoPickActivity.this.mRecyclerView.setAdapter((RecyclerView.Adapter)VideoPickActivity.this.mAdapter);
                VideoPickActivity.this.runLayoutAnimation(VideoPickActivity.this.mRecyclerView);
            }
        });
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<VideoFile>(){

            @Override
            public void OnSelectStateChanged(boolean state, VideoFile file) {
                VideoPickActivity.this.mSelectedList.add(file);
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra("ResultPickVideo", VideoPickActivity.this.mSelectedList);
                VideoPickActivity.this.setResult(-1, intent);
                VideoPickActivity.this.finish();
            }
        });
        File folder = new File(this.getExternalCacheDir().getAbsolutePath() + File.separator + THUMBNAIL_PATH);
        if (!folder.exists()) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
    }

    public void onBackPressed() {
        if (this.isDirectory) {
            this.isDirectory = false;
            this.layoutManager.setSpanCount(2);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 513: {
                if (resultCode != -1) break;
                Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                File file = new File(this.mAdapter.mVideoPath);
                Uri contentUri = Uri.fromFile((File)file);
                mediaScanIntent.setData(contentUri);
                this.sendBroadcast(mediaScanIntent);
                this.loadData();
            }
        }
    }

    private void loadData() {
        FileFilter.getVideos((FragmentActivity)this, new FilterResultCallback<VideoFile>(){

            @Override
            public void onResult(List<Directory<VideoFile>> directories) {
                VideoPickActivity.this.mProgressBar.setVisibility(8);
                if (VideoPickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> list = new ArrayList<Directory>();
                    Directory all = new Directory();
                    all.setName(VideoPickActivity.this.getResources().getString(R.string.vw_all));
                    list.add(all);
                    list.addAll(directories);
                    VideoPickActivity.this.mFolderHelper.fillData(list);
                }
                VideoPickActivity.this.refreshData(directories);
            }
        });
    }

    private void refreshData(List<Directory<VideoFile>> directories) {
        if (directories.size() > 4) {
            ArrayList<Directory<VideoFile>> directoryList = new ArrayList<Directory<VideoFile>>();
            directoryList.addAll(directories);
            this.directoryAdapter.refresh(directoryList);
        } else {
            boolean tryToFindTaken = this.isTakenAutoSelected;
            ArrayList<VideoFile> list = new ArrayList<VideoFile>();
            for (Directory<VideoFile> directory : directories) {
                list.addAll(directory.getFiles());
                if (!tryToFindTaken) continue;
                tryToFindTaken = this.findAndAddTaken(directory.getFiles());
            }
            for (VideoFile file : this.mSelectedList) {
                int index = list.indexOf(file);
                if (index == -1) continue;
                ((VideoFile)list.get(index)).setSelected(true);
            }
            this.mAdapter.refresh(list);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        }
        this.runLayoutAnimation(this.mRecyclerView);
    }

    private boolean findAndAddTaken(List<VideoFile> list) {
        for (VideoFile videoFile : list) {
            if (!videoFile.getPath().equals(this.mAdapter.mVideoPath)) continue;
            this.mSelectedList.add(videoFile);
            return true;
        }
        return false;
    }

    private void runLayoutAnimation(RecyclerView recyclerView) {
        Context context = recyclerView.getContext();
        LayoutAnimationController controller = AnimationUtils.loadLayoutAnimation((Context)context, (int)R.anim.hippo_layout_animation_from_bottom);
        recyclerView.setLayoutAnimation(controller);
        recyclerView.getAdapter().notifyDataSetChanged();
        recyclerView.scheduleLayoutAnimation();
    }
}

