/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.EventItem;
import com.hippo.agent.model.HeaderItem;
import com.hippo.agent.model.ListItem;
import com.hippo.agent.model.Message;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.fayeClient;
import com.hippo.model.FuguUploadImageResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.MultipartParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.fileUpload.ProgressRequestBody;
import faye.FayeClient;
import faye.FayeServiceListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class MyForeGroundService
extends Service
implements FayeServiceListener,
FuguAppConstant,
ProgressRequestBody.UploadCallbacks {
    private static final String TAG = MyForeGroundService.class.getSimpleName();
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private Handler h;
    private Runnable r;
    FayeClient mClient = null;
    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;
    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList();
    boolean apiInProgress;
    boolean isFirstTime;

    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        ++this.counter;
        Context context = this.getApplicationContext();
        this.manager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            String CHANNEL_ID = "hippo_file_uploading";
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)this.getString(R.string.app_name), 3);
            channel.setDescription("File uploading");
            this.manager.createNotificationChannel(channel);
            this.builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID);
        } else {
            this.builder = new NotificationCompat.Builder(context);
        }
        this.builder.setProgress(100, this.counter, false);
        return this.builder.setContentTitle((CharSequence)this.getString(R.string.uploading)).setTicker((CharSequence)"").setOnlyAlertOnce(true).setContentText((CharSequence)this.getString(R.string.uploading_in_progress)).setSmallIcon(R.drawable.hippo_default_notif_icon).setOngoing(true).build();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent.getAction().contains("start")) {
            this.startForeground(101, this.updateNotification());
            this.uploadFileServerCall();
        } else {
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
        return 1;
    }

    public void stopFayeClient() {
        if (this.mClient == null) {
            return;
        }
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable(){

                @Override
                public void run() {
                    MyForeGroundService.this.mClient.setServiceListener(null);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProgress(int uploaded, int total) {
        if (this.builder != null && this.manager != null) {
            this.builder.setProgress(total, uploaded, false);
            this.manager.notify(101, this.builder.build());
        } else {
            this.startForeground(101, this.updateNotification());
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    private void uploadFileServerCall() {
        try {
            if (this.apiInProgress) {
                HippoLog.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (this.isNetworkAvailable()) {
                String data = Prefs.with((Context)this).getString("pref_upload_data", "");
                HippoLog.v(TAG, "uploadFileServerCall 1: " + data);
                this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
                if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                    Prefs.with((Context)this).remove("pref_upload_data");
                    this.stopFayeClient();
                    this.stopForeground(true);
                    this.stopSelf();
                    return;
                }
                this.fileuploadModel = this.fileuploadModels.get(0);
                this.isFirstTime = true;
                ProgressRequestBody fileBody = new ProgressRequestBody(new File(this.fileuploadModel.getFilePath()), this, this.getMimeType(this.fileuploadModel.getFilePath()), this.fileuploadModel.getFilePath(), this.fileuploadModel.getMessageIndex(), this.fileuploadModel.getMuid());
                MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)this.fileuploadModel.getFileName(), (RequestBody)fileBody);
                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder.add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("app_version", "2.0.8").add("device_type", 1).add("allow_all_mime_type", true).add("file_name", this.fileuploadModel.getFileName()).build();
                this.apiInProgress = true;
                HippoLog.v("map = ", multipartParams.getMap().toString());
                HippoLog.v("app_secret_key", "---> " + HippoConfig.getInstance().getAppKey());
                RestClient.getApiInterface().uploadFile(HippoConfig.getInstance().getAppKey(), 1, 208, filePart, multipartParams.getMap()).enqueue((Callback)new ResponseResolver<FuguUploadImageResponse>(){

                    @Override
                    public void success(FuguUploadImageResponse fuguUploadImageResponse) {
                        JSONObject jsonObject;
                        String data;
                        String thumbnail_url;
                        String image_url;
                        block8: {
                            image_url = fuguUploadImageResponse.getData().getUrl();
                            thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();
                            data = Prefs.with((Context)MyForeGroundService.this).getString("pref_upload_data", "");
                            HippoLog.v(TAG, "In response: " + data);
                            MyForeGroundService.this.fileuploadModels = (ArrayList)new Gson().fromJson(data, MyForeGroundService.this.fileuploadType);
                            jsonObject = MyForeGroundService.this.fileuploadModels.get(0).getMessageObject();
                            try {
                                jsonObject.put("image_url", (Object)image_url);
                                jsonObject.put("thumbnail_url", (Object)thumbnail_url);
                                jsonObject.put("url", (Object)image_url);
                                jsonObject.remove("local_url");
                            }
                            catch (JSONException e) {
                                if (!HippoConfig.DEBUG) break block8;
                                e.printStackTrace();
                            }
                        }
                        MyForeGroundService.this.fileuploadModels.get(0).setFileUploaded(true);
                        MyForeGroundService.this.fileuploadModels.get(0).setMessageObject(jsonObject);
                        if (MyForeGroundService.this.fileuploadModels.get(0).getChannelId().intValue() < 1) {
                            Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                            mIntent.putExtra("broadcast_status", 4);
                            mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModels.get(0)));
                            LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                            MyForeGroundService.this.updatePref();
                        } else {
                            data = new Gson().toJson(MyForeGroundService.this.fileuploadModels, MyForeGroundService.this.fileuploadType);
                            HippoLog.e(TAG, "In response else case " + data);
                            Prefs.with((Context)MyForeGroundService.this).save("pref_upload_data", data);
                            MyForeGroundService.this.fileuploadModel = MyForeGroundService.this.fileuploadModels.get(0);
                            if (MyForeGroundService.this.isOpenedChatActivityMsg(MyForeGroundService.this.fileuploadModel.getChannelId())) {
                                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                                mIntent.putExtra("broadcast_status", 0);
                                mIntent.putExtra("channelId", (Serializable)MyForeGroundService.this.fileuploadModel.getChannelId());
                                mIntent.putExtra("muid", MyForeGroundService.this.fileuploadModel.getMuid());
                                mIntent.putExtra("messageIndex", MyForeGroundService.this.fileuploadModel.getMessageIndex());
                                mIntent.putExtra("image_url", image_url);
                                mIntent.putExtra("thumbnail_url", thumbnail_url);
                                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModel));
                                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                                MyForeGroundService.this.updatePref();
                            } else if (AgentCommonData.isAgentFlow()) {
                                MyForeGroundService.this.updateLocalAgentMessageObj(MyForeGroundService.this.fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject, new UpdateLocalMsgListener(){

                                    @Override
                                    public void onUpdation(JSONObject jsonObject) {
                                        MyForeGroundService.this.apiInProgress = false;
                                        MyForeGroundService.this.getClient(MyForeGroundService.this.fileuploadModel.getChannelId(), jsonObject);
                                    }
                                });
                            } else {
                                MyForeGroundService.this.updateLocalMessageObj(MyForeGroundService.this.fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject, new UpdateLocalMsgListener(){

                                    @Override
                                    public void onUpdation(JSONObject jsonObject) {
                                        MyForeGroundService.this.apiInProgress = false;
                                        MyForeGroundService.this.getClient(MyForeGroundService.this.fileuploadModel.getChannelId(), jsonObject);
                                    }
                                });
                            }
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        HippoLog.e(TAG, "In uploading failure");
                        MyForeGroundService.this.handleException();
                    }
                });
            } else {
                HippoLog.e(TAG, "In uploading else");
                this.handleException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HippoLog.e(TAG, "In uploading else 2");
            this.handleException();
        }
    }

    private void handleException() {
        Log.e((String)TAG, (String)"In handleException failure");
        try {
            String data = Prefs.with((Context)this).getString("pref_upload_data", "");
            Log.e((String)TAG, (String)("In response else case " + data));
            this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
            if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
                return;
            }
            this.fileuploadModel = this.fileuploadModels.get(0);
            this.apiInProgress = false;
            if (this.isOpenedChatActivityMsg(this.fileuploadModel.getChannelId())) {
                this.setMessageExpired();
                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                mIntent.putExtra("channelId", (Serializable)this.fileuploadModel.getChannelId());
                mIntent.putExtra("muid", this.fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", this.fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)this.fileuploadModel));
                mIntent.putExtra("broadcast_status", 1);
                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            } else {
                this.uploadingFailed(this.fileuploadModel.getChannelId());
                this.setMessageExpired();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    private void updatePref() {
        HippoLog.e(TAG, "updatePref: " + Prefs.with((Context)this).getString("pref_upload_data", ""));
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            this.fileuploadModels.remove(0);
            String data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            Prefs.with((Context)this).save("pref_upload_data", data);
            HippoLog.e(TAG, "int updatePref set data : " + data);
            if (this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
            } else {
                this.apiInProgress = false;
                this.uploadFileServerCall();
            }
        }
    }

    @Override
    public void onProgressUpdate(int percentage, int mMessageIndex, String muid) {
        if (this.isFirstTime && percentage == 10) {
            this.isFirstTime = false;
            return;
        }
        if (!this.isFirstTime && percentage == 10) {
            this.isFirstTime = true;
        }
        if (this.isFirstTime) {
            this.updateProgress(percentage, 100);
        }
    }

    @Override
    public void onError(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onFinish else 2");
    }

    private void getClient(final Long channelId, final JSONObject messageJson) {
        HippoConfig.getClient(new fayeClient(){

            @Override
            public void Listener(FayeClient client) {
                MyForeGroundService.this.mClient = client;
                MyForeGroundService.this.afterSetUpFayeConnection(channelId, messageJson);
            }
        });
    }

    private void afterSetUpFayeConnection(Long channelId, JSONObject messageJson) {
        this.mClient.setServiceListener(this);
        if (!this.mClient.isConnectedServer() && this.isNetworkAvailable()) {
            this.mClient.connectServer();
        } else if (this.mClient.isConnectedServer()) {
            HippoLog.e(TAG, "************publish*********");
            this.mClient.publish("/" + String.valueOf(channelId), messageJson);
            this.updatePref();
        } else if (!this.isNetworkAvailable()) {
            Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
            mIntent.putExtra("broadcast_status", 0);
            LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            this.updatePref();
        }
    }

    @Override
    public void onConnectedServer(FayeClient fc) {
        HippoLog.e(TAG, "************onConnectedServer*********");
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        for (FileuploadModel fileuploadModel : fileuploadModels) {
            if (!fileuploadModel.isFileUploaded()) continue;
            if (this.mClient.hasSubscribed("/" + String.valueOf(fileuploadModel.getChannelId()))) {
                this.mClient.subscribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
            }
            this.mClient.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
            break;
        }
    }

    @Override
    public void onDisconnectedServer(FayeClient fc) {
    }

    @Override
    public void onReceivedMessage(FayeClient fc, String msg, String channel) {
        try {
            JSONObject messageJson = new JSONObject(msg);
            if (messageJson.optInt("message_type", 0) == 10 || messageJson.optInt("message_type", 0) == 11) {
                String value = channel.replace("/", "");
                if (!this.isOpenedChatActivityMsg(Long.parseLong(value))) {
                    this.updateLocalMessageObj(Long.parseLong(value), true, "", "", null, null);
                }
                this.updatePref();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onWebSocketError() {
    }

    @Override
    public void onErrorReceived(FayeClient fc, String msg, String channel) {
    }

    private boolean isOpenedChatActivityMsg(Long channelId) {
        ActivityManager mngr = (ActivityManager)this.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        return ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippo.activity.FuguChatActivity") && FuguChatActivity.currentChannelId.compareTo(channelId) == 0;
    }

    private void uploadingFailed(long channelId) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            Log.v((String)TAG, (String)("data = " + data));
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, com.hippo.model.Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        com.hippo.model.Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        listItem.setUploadStatus(0);
        listItem.setIsMessageExpired(1);
        unsentMessages.put(fileuploadModel.getMuid(), listItem);
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
    }

    private void setAllMessageExpired() {
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            for (FileuploadModel fileuploadModel : this.fileuploadModels) {
                if (this.isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                    this.sendLocalBroadcast(fileuploadModel);
                    continue;
                }
                if (AgentCommonData.isAgentFlow()) {
                    this.updateAgentLocalMessage(this.fileuploadModels.get(0));
                    continue;
                }
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.clear();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    private void setMessageExpired() {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "");
        HippoLog.e(TAG, "In setMessageExpired: " + data);
        this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            if (this.isOpenedChatActivityMsg(this.fileuploadModels.get(0).getChannelId())) {
                this.sendLocalBroadcast(this.fileuploadModels.get(0));
            } else if (AgentCommonData.isAgentFlow()) {
                this.updateAgentLocalMessage(this.fileuploadModels.get(0));
            } else {
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.remove(0);
            data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            HippoLog.e(TAG, "In setMessageExpired after update: " + data);
            Prefs.with((Context)this).save("pref_upload_data", data);
            this.uploadFileServerCall();
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
        mIntent.putExtra("muid", fileuploadModel.getMuid());
        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        mIntent.putExtra("broadcast_status", 3);
        LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
    }

    private void updateLocalMessageObj(Long channelId, boolean isPublished, String url, String thumbnailUrl, JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            HippoLog.v(TAG, "data = " + data);
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, com.hippo.model.Message> sentMessages = CommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, com.hippo.model.Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        com.hippo.model.Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        if (isPublished) {
            listItem.setMessageStatus(1);
            ArrayList<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (!sentMessages.get(key).isDateView()) continue;
                tempSentAtUTC = key;
                break;
            }
            String time = listItem.getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new com.hippo.model.Message(localDate, true));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);
            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());
            CommonData.setSentMessageByChannel(channelId, sentMessages);
        } else {
            com.hippo.model.Message message = listItem;
            message.setFileUrl(url);
            message.setUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(3);
            unsentMessages.put(fileuploadModel.getMuid(), message);
            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put("image_url", (Object)url);
                object.put("thumbnail_url", (Object)thumbnailUrl);
                object.put("url", (Object)url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
        if (msgListener != null) {
            msgListener.onUpdation(jsonObject);
        }
    }

    private void updateLocalAgentMessageObj(Long channelId, boolean isPublished, String url, String thumbnailUrl, JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            HippoLog.v(TAG, "data = " + data);
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, ListItem> sentMessages = AgentCommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, ListItem> unsentMessages = AgentCommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(channelId);
        ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        if (isPublished) {
            ((EventItem)listItem).getEvent().setMessageStatus(1);
            ArrayList<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (!(sentMessages.get(key) instanceof HeaderItem)) continue;
                tempSentAtUTC = key;
                break;
            }
            String time = ((EventItem)listItem).getEvent().getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new HeaderItem(localDate));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);
            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());
            AgentCommonData.setSentMessageByChannel(channelId, sentMessages);
        } else {
            Message message = ((EventItem)listItem).getEvent();
            message.setFileUrl(url);
            message.setImageUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(3);
            unsentMessages.put(fileuploadModel.getMuid(), new EventItem(message));
            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put("image_url", (Object)url);
                object.put("thumbnail_url", (Object)thumbnailUrl);
                object.put("url", (Object)url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        AgentCommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        AgentCommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
        if (msgListener != null) {
            msgListener.onUpdation(jsonObject);
        }
    }

    private void updateLocalMessages(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();
        LinkedHashMap<String, com.hippo.model.Message> unsentMessages = CommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (unsentMessages == null) {
            unsentMessages = new LinkedHashMap();
        }
        unsentMessages.get(muid).setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        CommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);
    }

    private void updateAgentLocalMessage(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();
        LinkedHashMap<String, ListItem> unsentMessages = AgentCommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = AgentCommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (unsentMessages == null) {
            unsentMessages = new LinkedHashMap();
        }
        ListItem listItem = unsentMessages.get(muid);
        ((EventItem)listItem).getEvent().setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AgentCommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        AgentCommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);
    }

    public static interface UpdateLocalMsgListener {
        public void onUpdation(JSONObject var1);
    }
}

