/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions.helper;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.hippo.utils.easypermissions.RationaleDialogFragment;
import com.hippo.utils.easypermissions.helper.PermissionHelper;

class ActivityPermissionHelper
extends PermissionHelper<Activity> {
    private static final String TAG = "ActPermissionHelper";

    public ActivityPermissionHelper(Activity host) {
        super(host);
    }

    @Override
    public void directRequestPermissions(int requestCode, String ... perms) {
        ActivityCompat.requestPermissions((Activity)((Activity)this.getHost()), (String[])perms, (int)requestCode);
    }

    @Override
    public boolean shouldShowRequestPermissionRationale(@NonNull String perm) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.getHost()), (String)perm);
    }

    @Override
    public Context getContext() {
        return (Context)this.getHost();
    }

    @Override
    public void showRequestPermissionRationale(@NonNull String rationale, @NonNull String positiveButton, @NonNull String negativeButton, @StyleRes int theme, int requestCode, String ... perms) {
        FragmentManager fm = ((Activity)this.getHost()).getFragmentManager();
        Fragment fragment = fm.findFragmentByTag("RationaleDialogFragment");
        if (fragment instanceof RationaleDialogFragment) {
            Log.d((String)TAG, (String)"Found existing fragment, not showing rationale.");
            return;
        }
        RationaleDialogFragment.newInstance(positiveButton, negativeButton, rationale, theme, requestCode, perms).showAllowingStateLoss(fm, "RationaleDialogFragment");
    }
}

