/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.Adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Utils.SupportKeys;
import com.hippo.support.callback.OnItemListener;
import com.hippo.support.model.Item;
import java.util.ArrayList;

public class HippoSupportAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = HippoSupportAdapter.class.getSimpleName();
    private Context context;
    private OnItemListener onItemListener;
    private HippoColorConfig hippoColorConfig = CommonData.getColorConfig();
    private ArrayList<Item> supportResponses;

    public HippoSupportAdapter(OnItemListener onItemListener) {
        this.onItemListener = onItemListener;
    }

    public void setAdapterData(ArrayList<Item> supportResponses) {
        this.supportResponses = supportResponses;
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_layout_support, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.textView.setText((CharSequence)this.supportResponses.get(position).getTitle());
    }

    public int getItemCount() {
        return this.supportResponses == null ? 0 : this.supportResponses.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout mainLayout;
        private TextView textView;
        private View viewDivider;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.main_layout);
            this.textView = (TextView)itemView.findViewById(R.id.support_text_view);
            this.textView.setTextColor(HippoSupportAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.viewDivider = itemView.findViewById(R.id.viewDivider);
            this.viewDivider.setBackgroundColor(HippoSupportAdapter.this.hippoColorConfig.getHippoBorderColor());
            this.textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int actionType = ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getActionType();
                    switch (SupportKeys.SupportActionType.get(actionType)) {
                        case LIST: {
                            HippoSupportAdapter.this.onItemListener.onClick(((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getActionType(), ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getItems(), ((Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition())).getTitle());
                            break;
                        }
                        case DESCRIPTION: 
                        case CHAT_SUPPORT: 
                        case SHOW_CONVERSATION: {
                            HippoSupportAdapter.this.onItemListener.onOtherTypeClick(actionType, (Item)HippoSupportAdapter.this.supportResponses.get(ViewHolder.this.getAdapterPosition()));
                            break;
                        }
                    }
                }
            });
        }
    }
}

