/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent;

import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.Window;
import android.widget.TextView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.helper.UploadingService;
import com.hippo.database.CommonData;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class AgentBaseActivity
extends AppCompatActivity {
    private static final String TAG = AgentBaseActivity.class.getSimpleName();
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setStatusBarColor();
        }
    }

    @RequiresApi(api=21)
    private void setStatusBarColor() {
        Window window = this.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(CommonData.getColorConfig().getHippoStatusBar());
    }

    protected void checkAutoUpload() {
        if (!this.isMyServiceRunning(UploadingService.class)) {
            ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (fileuploadModels == null) {
                return;
            }
            if (fileuploadModels.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), UploadingService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            ab.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }

    public void showErrorMessage(String errorMessage, String positiveButtonText) {
        this.showErrorMessage(errorMessage, positiveButtonText, false);
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)AgentBaseActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (isFinish) {
                            AgentBaseActivity.this.finish();
                        }
                    }
                }).setCancelable(false).show();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onPause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onResume();
        }
    }
}

