/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.content.DialogInterface;
import android.support.v4.app.Fragment;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.easypermissions.RationaleDialogConfig;
import com.hippo.utils.easypermissions.RationaleDialogFragment;
import com.hippo.utils.easypermissions.RationaleDialogFragmentCompat;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.util.Arrays;

class RationaleDialogClickListener
implements DialogInterface.OnClickListener {
    private Object mHost;
    private RationaleDialogConfig mConfig;
    private EasyPermissions.PermissionCallbacks mCallbacks;
    private EasyPermissions.RationaleCallbacks mRationaleCallbacks;

    RationaleDialogClickListener(RationaleDialogFragmentCompat compatDialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks, EasyPermissions.RationaleCallbacks rationaleCallbacks) {
        this.mHost = compatDialogFragment.getParentFragment() != null ? compatDialogFragment.getParentFragment() : compatDialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
        this.mRationaleCallbacks = rationaleCallbacks;
    }

    RationaleDialogClickListener(RationaleDialogFragment dialogFragment, RationaleDialogConfig config, EasyPermissions.PermissionCallbacks callbacks, EasyPermissions.RationaleCallbacks dialogCallback) {
        this.mHost = dialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
        this.mRationaleCallbacks = dialogCallback;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClick(DialogInterface dialog, int which) {
        int requestCode = this.mConfig.requestCode;
        if (which == -1) {
            String[] permissions = this.mConfig.permissions;
            if (this.mRationaleCallbacks != null) {
                this.mRationaleCallbacks.onRationaleAccepted(requestCode);
            }
            if (this.mHost instanceof Fragment) {
                PermissionHelper.newInstance((Fragment)this.mHost).directRequestPermissions(requestCode, permissions);
                return;
            } else {
                if (!(this.mHost instanceof Activity)) throw new RuntimeException("Host must be an Activity or Fragment!");
                PermissionHelper.newInstance((Activity)this.mHost).directRequestPermissions(requestCode, permissions);
            }
            return;
        } else {
            if (this.mRationaleCallbacks != null) {
                this.mRationaleCallbacks.onRationaleDenied(requestCode);
            }
            this.notifyPermissionDenied();
        }
    }

    private void notifyPermissionDenied() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onPermissionsDenied(this.mConfig.requestCode, Arrays.asList(this.mConfig.permissions));
        }
    }
}

