/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.fragment;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.utils.HippoLog;

public abstract class BaseFragment
extends Fragment {
    void setTitle(String title) {
        HippoLog.d("Text", "text = " + title);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        ((AppCompatActivity)this.getActivity()).setSupportActionBar(toolbar);
        ActionBar ab = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            ab.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return ((AppCompatActivity)this.getActivity()).getSupportActionBar();
    }

    protected void setPoweredByText(TextView tvPoweredBy) {
        block7: {
            try {
                FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
                if (userData == null) {
                    return;
                }
                if (!userData.getWhiteLabel().booleanValue()) {
                    HippoColorConfig hippoColorConfig = CommonData.getColorConfig();
                    try {
                        this.doStyleSpanForSecondString(this.getString(R.string.fugu_powered_by), this.getString(R.string.hippo_text), tvPoweredBy, hippoColorConfig);
                    }
                    catch (Exception e) {
                        if (Build.VERSION.SDK_INT >= 24) {
                            String text = "<font color=" + String.format("#%06X", 0xFFFFFF & hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & hippoColorConfig.getHippoThemeColorPrimary()) + "> " + this.getString(R.string.hippo_text) + "</font>";
                            tvPoweredBy.setText((CharSequence)Html.fromHtml((String)text));
                        }
                        String text = "<font color=" + String.format("#%06X", 0xFFFFFF & hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & hippoColorConfig.getHippoThemeColorPrimary()) + "> " + this.getString(R.string.hippo_text) + "</font>";
                        tvPoweredBy.setText((CharSequence)Html.fromHtml((String)text));
                    }
                    tvPoweredBy.setVisibility(0);
                    tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
                    break block7;
                }
                tvPoweredBy.setVisibility(8);
            }
            catch (Exception e) {
                e.printStackTrace();
                tvPoweredBy.setVisibility(8);
            }
        }
    }

    private void doStyleSpanForSecondString(String firstString, String lastString, TextView txtSpan, HippoColorConfig hippoColorConfig) throws Exception {
        String changeString = lastString != null ? lastString : "";
        String totalString = firstString + " " + changeString;
        SpannableString spanText = new SpannableString((CharSequence)totalString);
        spanText.setSpan((Object)new StyleSpan(1), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new ForegroundColorSpan(hippoColorConfig.getHippoActionBarBg()), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new RelativeSizeSpan(0.8f), 0, String.valueOf(firstString).length(), 0);
        txtSpan.setText((CharSequence)spanText);
    }

    public void setupUI(View view) throws Exception {
        if (!(view instanceof EditText)) {
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    try {
                        InputMethodManager inputMethodManager = (InputMethodManager)BaseFragment.this.getActivity().getSystemService("input_method");
                        inputMethodManager.hideSoftInputFromWindow(BaseFragment.this.getActivity().getCurrentFocus().getWindowToken(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            });
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View innerView = ((ViewGroup)view).getChildAt(i);
                this.setupUI(innerView);
            }
        }
    }
}

