/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.v4.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.HippoNotificationConfig;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.campaign.CampaignActivity;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;

public class FuguPushIntentService
extends IntentService {
    private static final String TAG = "FuguPushIntentService";

    public FuguPushIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        boolean isPromotional = intent.getBooleanExtra("is_announcement_push", false);
        if (isPromotional) {
            if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                Intent broadcastIntent = new Intent((Context)this, CampaignActivity.class);
                broadcastIntent.putExtra("is_promotional_push", true);
                broadcastIntent.putExtra("is_announcement_push", true);
                broadcastIntent.setFlags(0x14000000);
                this.startActivity(broadcastIntent);
            } else {
                PackageManager pm = this.getPackageManager();
                Intent notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                notificationIntent.putExtra("is_announcement_push", true);
                this.startActivity(notificationIntent);
            }
        } else if (AgentCommonData.isAgentFlow()) {
            Long channelId = intent.getLongExtra("channelId", -1L);
            Conversation conversation = new Conversation();
            conversation.setChannelId(channelId);
            conversation.setUserId(intent.getIntExtra("userId", -1));
            conversation.setLabel(intent.getStringExtra("label"));
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(intent.getIntExtra("disable_reply", 0));
            if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                Intent backIntent = new Intent((Context)this, AgentListActivity.class);
                backIntent.addFlags(0x10000000);
                Intent notificationIntent = new Intent((Context)this, AgentChatActivity.class);
                notificationIntent.putExtra("is_from_push", true);
                if (channelId < 0L) {
                    notificationIntent = new Intent((Context)this, AgentListActivity.class);
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else if (HippoNotificationConfig.agentPushChannelId == -1L || HippoNotificationConfig.agentPushChannelId != -1L && HippoNotificationConfig.isChannelActivityOnPause) {
                    notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else {
                    Intent mIntent = new Intent("notification_tapped");
                    mIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(mIntent);
                }
            } else {
                PackageManager pm = this.getPackageManager();
                Intent notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                conversation.setLabel("");
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                notificationIntent.putExtra("is_from_push", true);
                this.startActivity(notificationIntent);
            }
        } else {
            long channelId = intent.getLongExtra("channelId", -1L);
            long labelId = intent.getLongExtra("labelId", -1L);
            FuguConversation conversation = new FuguConversation();
            conversation.setChannelId(channelId);
            conversation.setEnUserId(intent.getStringExtra("en_user_id"));
            conversation.setUserId(intent.getLongExtra("userId", -1L));
            conversation.setLabel(intent.getStringExtra("label"));
            conversation.setLabelId(labelId);
            conversation.setDisableReply(intent.getIntExtra("disable_reply", 0));
            if (channelId < 0L && labelId > 0L) {
                conversation.setOpenChat(true);
            }
            if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                Intent notificationIntent = new Intent((Context)this, FuguChatActivity.class);
                if (channelId < 0L && labelId < 0L) {
                    notificationIntent = new Intent((Context)this, FuguChannelsActivity.class);
                    notificationIntent.putExtra("title", CommonData.getChatTitle());
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else if (HippoNotificationConfig.pushChannelId.compareTo(-1L) == 0) {
                    notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else {
                    Intent mIntent = new Intent("notification_tapped");
                    mIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(mIntent);
                }
            } else {
                PackageManager pm = this.getPackageManager();
                Intent notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                conversation.setStartChannelsActivity(true);
                notificationIntent.putExtra("startChatActivity", true);
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                this.startActivity(notificationIntent);
            }
        }
    }
}

