/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.FragmentType;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.NotificationType;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.Util.WrapContentLinearLayoutManager;
import com.hippo.agent.adapter.ChatListAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.fragment.BaseFragment;
import com.hippo.agent.helper.ConversationListHelper;
import com.hippo.agent.listeners.AgentServerListener;
import com.hippo.agent.listeners.ConversationListerner;
import com.hippo.agent.listeners.OnUserChannelListener;
import com.hippo.agent.listeners.UnreadListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.agent.model.getConversationResponse.CustomerUniqueKey;
import com.hippo.agent.recylerviewAnimation.FadeInLeftAnimator;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.HippoLog;
import com.hippo.utils.Utils;
import com.hippo.utils.loadingBox.LoadingBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.json.JSONObject;

public class MyChatFragment
extends BaseFragment
implements AgentServerListener,
OnUserChannelListener,
SwipeRefreshLayout.OnRefreshListener,
ChatListAdapter.Callback {
    private static final String TAG = MyChatFragment.class.getSimpleName();
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView listView;
    private ChatListAdapter chatListAdapter;
    private LinearLayout llNoConversation;
    private WrapContentLinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private ConversationListerner listerner;
    private ChatListAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> conversationChatList = new ArrayList();
    private TextView title_error;
    private TextView detail_error;
    private boolean isPagingApiInProgress;
    private boolean isLastItemReached;
    private Snackbar snackbar;
    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};
    private int[] labelsIntArray = new int[0];
    private UserData userData;
    private int fragmentType = FragmentType.MY_CHAT.getOrdinal();
    private String userUniqueId;
    RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            HippoLog.v("scroll state ", "changed");
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dy > 0) {
                if (!MyChatFragment.this.isNetworkAvailable()) {
                    return;
                }
                MyChatFragment.this.visibleItemCount = MyChatFragment.this.layoutManager.getChildCount();
                MyChatFragment.this.totalItemCount = MyChatFragment.this.layoutManager.getItemCount();
                MyChatFragment.this.pastVisiblesItems = MyChatFragment.this.layoutManager.findFirstVisibleItemPosition();
                if (!MyChatFragment.this.isPagingApiInProgress && !MyChatFragment.this.isLastItemReached && MyChatFragment.this.visibleItemCount + MyChatFragment.this.pastVisiblesItems >= MyChatFragment.this.totalItemCount && MyChatFragment.this.conversationChatList != null && MyChatFragment.this.conversationChatList.size() > 1) {
                    int pageStart = MyChatFragment.this.conversationChatList.size() + 1;
                    MyChatFragment.this.toggleProgressBarVisibility(true);
                    MyChatFragment.this.getConversationData(pageStart, false);
                }
            } else if (MyChatFragment.this.getSnackbar() != null && MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 1) {
                MyChatFragment.this.getSnackbar().dismiss();
            }
        }
    };
    private int newMessageCount = 0;
    public boolean notifiacrionClicked;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.fragmentType = this.getArguments().getInt("fragment_type", FragmentType.MY_CHAT.getOrdinal());
            this.userUniqueId = this.getArguments().getString("user_unique_key");
            GetConversationResponse conversationResponse = (GetConversationResponse)new Gson().fromJson(this.getArguments().getString("conversation"), GetConversationResponse.class);
            this.conversationChatList = new ArrayList();
            this.conversationChatList.addAll(conversationResponse.getData().getConversation());
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_list_fragment, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.listView = (RecyclerView)view.findViewById(R.id.list_view);
        this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh);
        this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.swipeRefreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.swipeRefreshLayout.setSize(1);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.title_error = (TextView)view.findViewById(R.id.title_error);
        this.detail_error = (TextView)view.findViewById(R.id.detail_error);
        this.layoutManager = new WrapContentLinearLayoutManager((Context)this.getActivity(), 1, false);
        this.listView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.listView.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.listView.getItemAnimator().setAddDuration(500L);
        this.listView.getItemAnimator().setRemoveDuration(500L);
        this.listView.setHasFixedSize(false);
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        if (this.userData != null && !TextUtils.isEmpty((CharSequence)this.userData.getAccessToken())) {
            this.chatListAdapter = new ChatListAdapter(this.userData.getUserId(), true, this.fragmentType, this.conversationChatList, this, this.listView);
            this.listView.setAdapter((RecyclerView.Adapter)this.chatListAdapter);
            this.listView.addOnScrollListener(this.onScrollListener);
            this.listerner = new ConversationListHelper();
            if (this.fragmentType == FragmentType.MY_CHAT.getOrdinal()) {
                this.listerner.getOfflineData(this.fragmentType);
            }
        } else {
            this.llNoConversation.setVisibility(0);
            this.title_error.setVisibility(8);
            this.detail_error.setText((CharSequence)"Something went wrong. Please try again");
        }
    }

    private void setConnectionManager(boolean loader) {
        this.isLastItemReached = false;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, loader);
    }

    private void getConversationData(int pageStart, boolean loader) {
        this.getConversationData(pageStart, loader, -1);
    }

    private void getConversationData(int pageStart, boolean loader, int endPage) {
        this.getConversationData(pageStart, loader, endPage, false);
    }

    private void getConversationData(int pageStart, boolean loader, int endPage, boolean isRefreshing) {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        String userID = String.valueOf(this.userData.getEnUserId());
        String accessToken = this.userData.getAccessToken();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("en_user_id", userID);
        params.put("access_token", accessToken);
        params.put("status", "[1]");
        params.put("device_type", 1);
        params.put("type", Arrays.toString(this.typeIntArray));
        if (pageStart != 0) {
            params.put("page_start", String.valueOf(pageStart));
        }
        if (endPage > 0) {
            params.put("page_end", String.valueOf(endPage));
        }
        if (this.fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(this.userUniqueId);
            params.put("search_user_unique_key", new Gson().toJson(strings));
        }
        CommonParams commonParams = new CommonParams.Builder().addAll(params).build();
        this.getConversationList(commonParams.getMap(), pageStart > 0, loader, isRefreshing, endPage);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        HippoConfig.getInstance().addUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().addUIListener(OnUserChannelListener.class, this);
    }

    public void onDetach() {
        super.onDetach();
        HippoConfig.getInstance().removeUIListener(AgentServerListener.class, this);
        HippoConfig.getInstance().removeUIListener(OnUserChannelListener.class, this);
        if (this.fragmentType == FragmentType.MY_CHAT.getOrdinal()) {
            AgentCommonData.setAgentConversationList(this.fragmentType, this.conversationChatList);
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onPause() {
        super.onPause();
    }

    public boolean isPagingApiInProgress() {
        return this.isPagingApiInProgress;
    }

    public void setPagingApiInProgress(boolean pagingApiInProgress) {
        this.isPagingApiInProgress = pagingApiInProgress;
    }

    public Snackbar getSnackbar() {
        return this.snackbar;
    }

    public void newConversationSnackBar() {
        ++this.newMessageCount;
        String message = this.newMessageCount > 1 ? this.newMessageCount + " new Chats" : this.newMessageCount + " new Chat";
        this.snackbar = Snackbar.make((View)this.getActivity().getWindow().getDecorView().findViewById(0x1020002), (CharSequence)message, (int)0).setAction((CharSequence)this.getResources().getString(R.string.fugu_tap_to_view), new View.OnClickListener(){

            public void onClick(View view) {
                MyChatFragment.this.newMessageCount = 0;
                MyChatFragment.this.listView.smoothScrollToPosition(0);
            }
        });
        this.snackbar.setActionTextColor(-1);
        View sbView = this.snackbar.getView();
        sbView.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)17170453));
        TextView textView = (TextView)sbView.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        Button button = (Button)sbView.findViewById(R.id.snackbar_action);
        this.snackbar.setDuration(-2);
        this.snackbar.show();
    }

    private void getConversationList(HashMap<String, Object> params, boolean isPagination, boolean loader, boolean onRefreshing, int endPage) {
        if (this.listerner != null) {
            if (loader) {
                LoadingBox.showOn((Activity)this.getActivity());
            }
            try {
                if (!(this.conversationChatList == null || this.conversationChatList.size() <= 0 || isPagination || loader || onRefreshing)) {
                    ((AgentListActivity)this.getActivity()).allChatFlag = true;
                    ((AgentListActivity)this.getActivity()).setConnectionMessage(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isPagingApiInProgress = true;
            this.listerner.getAgentConversation(params, isPagination, this.fragmentType, endPage);
        }
    }

    private void getConversationResponse(GetConversationResponse getConversationResponse, boolean isPagination, int fragmentType, int endPage) {
        if (this.fragmentType != fragmentType) {
            return;
        }
        try {
            HippoLog.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
            if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                this.setConversationChatData((ArrayList)getConversationResponse.getData().getConversation(), isPagination, endPage);
                this.toggleProgressBarVisibility(false);
                this.setPagingApiInProgress(false);
                if (getConversationResponse.getData().getConversation().size() == 0) {
                    this.isLastItemReached = true;
                }
            }
            if (this.getActivity() != null) {
                ((AgentListActivity)this.getActivity()).hideLoader(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoadingBox.hide();
        this.swipeRefreshLayout.setRefreshing(false);
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination) {
        this.setConversationChatData(allChatData, isPagination, -1);
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, final boolean isPagination, final int endPage) {
        if (!isPagination) {
            this.conversationChatList.clear();
        }
        this.conversationChatList.addAll(allChatData);
        if (this.getView() != null && this.chatListAdapter != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    if (!isPagination && endPage < 1) {
                        MyChatFragment.this.listView.scrollToPosition(0);
                    }
                }
            });
        } else if (this.conversationChatList == null || this.conversationChatList.size() == 0) {
            this.setLlNoConversation(null);
        }
        this.addUnreadCount(allChatData);
    }

    private void setLlNoConversation(final String message) {
        if (this.llNoConversation != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (message != null) {
                        if (MyChatFragment.this.conversationChatList == null || MyChatFragment.this.conversationChatList.size() == 0) {
                            MyChatFragment.this.llNoConversation.setVisibility(0);
                            MyChatFragment.this.swipeRefreshLayout.setVisibility(8);
                        } else {
                            MyChatFragment.this.llNoConversation.setVisibility(8);
                        }
                        if (!TextUtils.isEmpty((CharSequence)message)) {
                            MyChatFragment.this.detail_error.setText((CharSequence)message);
                        }
                    } else if (MyChatFragment.this.conversationChatList == null || MyChatFragment.this.conversationChatList.size() == 0) {
                        MyChatFragment.this.llNoConversation.setVisibility(0);
                    } else {
                        MyChatFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ChatListAdapter.ProgressBarItem();
            }
            if (!this.conversationChatList.contains(this.progressBarItem)) {
                this.conversationChatList.add(this.progressBarItem);
                this.listView.post(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyItemInserted(MyChatFragment.this.conversationChatList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationChatList.contains(this.progressBarItem)) {
            this.conversationChatList.remove(this.progressBarItem);
            this.chatListAdapter.notifyItemRemoved(this.conversationChatList.size() - 1);
        }
    }

    public void onRefresh() {
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, -1, true);
    }

    @Override
    public void onClick(int position, int fragmentType, Conversation conversation) {
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        this.chatListAdapter.notifyDataSetChanged();
        ArrayList<String> userUniqueKeys = new ArrayList<String>();
        try {
            if (conversation.getCustomerUniqueKeys() != null) {
                for (CustomerUniqueKey uniqueKey : conversation.getCustomerUniqueKeys()) {
                    userUniqueKeys.add(uniqueKey.getUserUniqueKey());
                }
                this.setConversationChatCount(conversation.getChannelId().intValue(), userUniqueKeys);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        conversation.setUnreadCount(0);
        Intent chatIntent = new Intent((Context)this.getActivity(), AgentChatActivity.class);
        chatIntent.putExtra("fragment_type", fragmentType);
        chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
        this.startActivityForResult(chatIntent, 100);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        HippoLog.v("onActivityResult", "enter");
        if (requestCode == 100) {
            if (resultCode == MessageMode.OPEN_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == MessageMode.CLOSED_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.CLOSED_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == Overlay.ASSIGNMENT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            }
        }
    }

    private void setOverlayTransition(int channelId, int messageMode, int resultCode) {
        boolean success = false;
        Conversation overlayConversation = null;
        for (int i = 0; i < this.conversationChatList.size(); ++i) {
            Conversation conversation1;
            if (!(this.conversationChatList.get(i) instanceof Conversation)) continue;
            overlayConversation = conversation1 = (Conversation)this.conversationChatList.get(i);
            if (!conversation1.getChannelId().equals(channelId)) continue;
            success = true;
            if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                conversation1.setStatus(messageMode);
            }
            conversation1.setOverlay(resultCode);
            break;
        }
        if (success) {
            this.chatListAdapter.notifyDataSetChanged();
            this.removeConversation(channelId);
            if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                this.removeOverlay(overlayConversation);
            } else {
                this.removeConversation(channelId);
            }
        }
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    public void removeConversation(final int channelId) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < MyChatFragment.this.conversationChatList.size(); ++i) {
                            if (!(MyChatFragment.this.conversationChatList.get(i) instanceof Conversation) || (long)channelId != ((Conversation)MyChatFragment.this.conversationChatList.get(i)).getChannelId()) continue;
                            MyChatFragment.this.conversationChatList.remove(i);
                            MyChatFragment.this.chatListAdapter.notifyItemRemoved(i);
                            HashMap<Integer, Integer> unreadCount = AgentCommonData.removeTotalUnreadCount(channelId);
                            MyChatFragment.this.sendUnreadCount(unreadCount);
                            break;
                        }
                    }
                });
            }
        }, 1000L);
    }

    public void setConversationChatCount(Integer conversationCount, ArrayList<String> userUniqueKey) {
        try {
            for (Object conversation : this.conversationChatList) {
                if (!(conversation instanceof Conversation) || !((Conversation)conversation).getChannelId().equals(conversationCount)) continue;
                int count = ((Conversation)conversation).getUnreadCount();
                for (UnreadListener listener : HippoConfig.getInstance().getUIListeners(UnreadListener.class)) {
                    if (listener == null) continue;
                    listener.updateOpenChannelCount(userUniqueKey, count);
                }
                ((Conversation)conversation).setUnreadCount(0);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void conversationList(GetConversationResponse getConversationResponse, boolean isPagination, int fragmentType, int endPage) {
        this.getConversationResponse(getConversationResponse, isPagination, fragmentType, endPage);
    }

    @Override
    public void onError(APIError error, int fragmentType) {
        if (this.fragmentType != fragmentType) {
            return;
        }
        this.setLlNoConversation(error.getMessage() == null ? "" : error.getMessage());
    }

    @Override
    public void offlineConversationList(int fragmentType, ArrayList<Object> arrayList) {
        boolean loader = true;
        if (fragmentType == FragmentType.MY_CHAT.getOrdinal()) {
            if (arrayList != null && arrayList.size() > 0) {
                this.conversationChatList.addAll(arrayList);
                this.chatListAdapter.notifyDataSetChanged();
                loader = false;
            }
            this.setConnectionManager(loader);
        }
    }

    @Override
    public void onAssignChat(JSONObject jsonObject) {
        int pos = -1;
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        try {
            if (jsonObject.optInt("assigned_to") != this.userData.getUserId().intValue()) {
                for (int i = 0; i < this.conversationChatList.size(); ++i) {
                    Conversation conversation1;
                    if (!(this.conversationChatList.get(i) instanceof Conversation) || (conversation1 = (Conversation)this.conversationChatList.get(i)).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
                    pos = i;
                    break;
                }
                this.conversationChatList.remove(pos);
                this.remove(pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onControlChannelData(JSONObject jsonObject) {
        this.setControlChannelData(jsonObject);
    }

    @Override
    public void onRefreshData() {
        if (!this.isNetworkAvailable()) {
            this.swipeRefreshLayout.setRefreshing(false);
            return;
        }
        if (this.userData == null) {
            this.userData = AgentCommonData.getUserData();
        }
        this.getConversationData(0, false, this.conversationChatList.size());
    }

    @Override
    public void onReadAll(JSONObject jsonObject) {
        if (jsonObject != null) {
            if (this.userData == null) {
                this.userData = AgentCommonData.getUserData();
            }
            if (jsonObject.optInt("user_id", 0) == this.userData.getUserId().intValue()) {
                for (Object obj : this.conversationChatList) {
                    Conversation conversation;
                    if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
                    if (this.fragmentType == FragmentType.USER_CHAT.getOrdinal()) {
                        HashMap<Integer, Integer> unreadCount = AgentCommonData.removeTotalUnreadCount(conversation.getChannelId().intValue());
                        this.sendUnreadCount(unreadCount);
                        ArrayList<String> userUniqueKeys = new ArrayList<String>();
                        try {
                            if (conversation.getCustomerUniqueKeys() != null) {
                                for (CustomerUniqueKey uniqueKey : conversation.getCustomerUniqueKeys()) {
                                    userUniqueKeys.add(uniqueKey.getUserUniqueKey());
                                }
                                this.setConversationChatCount(conversation.getChannelId().intValue(), userUniqueKeys);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    conversation.setUnreadCount(0);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void updateCount(Long channelId) {
        try {
            for (Object obj : this.conversationChatList) {
                Conversation conversation;
                if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(channelId) != 0) continue;
                conversation.setUnreadCount(0);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                    }
                });
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setControlChannelData(JSONObject jsonObject) {
        try {
            boolean newConversation = true;
            for (Object obj : this.conversationChatList) {
                Conversation conversation;
                if (!(obj instanceof Conversation) || (conversation = (Conversation)obj).getChannelId().compareTo(jsonObject.optLong("channel_id")) != 0) continue;
                newConversation = false;
                conversation.setMessage(jsonObject.optString("message", ""));
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                conversation.setLast_sent_by_user_type(jsonObject.getInt("last_sent_by_user_type"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                if (jsonObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue() && jsonObject.optInt("is_my_chat", 0) == 1 && (long)jsonObject.optInt("channel_id", -1) != AgentChatActivity.pushChannelId) {
                    conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MyChatFragment.this.chatListAdapter.notifyDataSetChanged();
                        }
                    });
                }
                if (this.userData == null) {
                    this.userData = AgentCommonData.getUserData();
                }
                if (jsonObject.optInt("last_sent_by_id", -1) != this.userData.getUserId().intValue()) break;
                conversation.setUnreadCount(0);
                break;
            }
            if (newConversation && this.fragmentType == FragmentType.USER_CHAT.getOrdinal() && AgentCommonData.getUnreadCount(this.userUniqueId).getHippoUserId() != jsonObject.optInt("user_id")) {
                return;
            }
            if (jsonObject.optInt("is_my_chat", 0) == 0) {
                return;
            }
            if (newConversation) {
                HippoLog.v("New chat arrived", "send to unasssigned");
                Conversation conversation = new Conversation();
                conversation.setChannelId(jsonObject.optLong("channel_id"));
                conversation.setChannelName(jsonObject.optString("channel_name", ""));
                conversation.setUserId(jsonObject.optInt("user_id"));
                conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                conversation.setMessage(jsonObject.optString("message", ""));
                conversation.setLabel(jsonObject.optString("label", ""));
                conversation.setStatus(jsonObject.optInt("status", 1));
                conversation.setBotChannelName(jsonObject.optString("bot_channel_name", ""));
                if (jsonObject.optInt("is_my_chat", 0) == 1) {
                    conversation.setUnreadCount(jsonObject.optInt("unread_count", 1));
                } else {
                    conversation.setUnreadCount(jsonObject.optInt("unread_count", 0));
                }
                conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                this.conversationChatList.add(0, conversation);
                this.setLlNoConversation(null);
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MyChatFragment.this.chatListAdapter.notifyItemInserted(0);
                        if (MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() == 0) {
                            MyChatFragment.this.listView.scrollToPosition(0);
                        } else if (MyChatFragment.this.layoutManager.findFirstVisibleItemPosition() > 0) {
                            MyChatFragment.this.newConversationSnackBar();
                        }
                    }
                });
            } else if (jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal()) {
                this.setOverlayTransition(jsonObject.getInt("channel_id"), MessageMode.OPEN_CHAT.getOrdinal(), Overlay.ASSIGNMENT.getOrdinal());
            } else {
                ArrayList<Conversation> allChatData = new ArrayList<Conversation>();
                for (Object obj : this.conversationChatList) {
                    if (!(obj instanceof Conversation)) continue;
                    Conversation conversation = (Conversation)obj;
                    allChatData.add(conversation);
                }
                Collections.sort(allChatData, new Comparator<Conversation>(){

                    @Override
                    public int compare(Conversation o1, Conversation o2) {
                        if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null) {
                            return 0;
                        }
                        return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                    }
                });
                this.setConversationChatData(allChatData, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(final int position) {
        Conversation conversation = (Conversation)this.conversationChatList.get(position);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MyChatFragment.this.chatListAdapter.notifyItemChanged(position);
            }
        });
        this.removeConversation(conversation.getChannelId().intValue());
    }

    private void addUnreadCount(ArrayList<Conversation> allChatData) {
        HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
        for (Conversation conversation : allChatData) {
            hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
        }
        AgentCommonData.addTotalUnreadCount(hashMap);
        this.sendUnreadCount(null);
    }

    private void sendUnreadCount(HashMap<Integer, Integer> unreadCount) {
        if (unreadCount == null) {
            unreadCount = AgentCommonData.getTotalUnreadCount();
        }
        int count = 0;
        for (Integer value : unreadCount.values()) {
            count += value.intValue();
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(count);
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

