/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hippo.R;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.Overlay;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.ItemClickListener;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class ChatListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ItemClickListener {
    private static final String TAG = ChatListAdapter.class.getSimpleName();
    private Context context;
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    private RecyclerView recyclerView;
    private Integer userId;
    private Callback callback;
    private ArrayList<Object> conversationList;
    private boolean isAllChatClicked;
    private int fragmentType;

    public ChatListAdapter(Integer userId, boolean isAllChatClicked, int fragmentType, ArrayList<Object> conversationList, Callback callback, RecyclerView recyclerView) {
        this.userId = userId;
        this.isAllChatClicked = isAllChatClicked;
        this.fragmentType = fragmentType;
        this.conversationList = conversationList;
        this.callback = callback;
        this.recyclerView = recyclerView;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        if (viewType == 2) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_list_item_header, parent, false);
            return new ViewHolderHeader(v);
        }
        if (viewType == 3) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        }
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_list_item_chat, parent, false);
        return new ViewHolder(v, this);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            String[] nameArray;
            ViewHolder holder = (ViewHolder)viewholder;
            Conversation conversation = (Conversation)this.conversationList.get(position);
            if (conversation.getMessage_type() == 18) {
                holder.tvMessage.setText((CharSequence)this.getMessageData(conversation));
            } else if (conversation.getMessage_type() == 11) {
                holder.tvMessage.setText((CharSequence)this.getFileMessageData(conversation));
            } else if (conversation.getMessage_type() == 19) {
                holder.tvMessage.setText((CharSequence)"Payment initiated");
            } else if (!TextUtils.isEmpty((CharSequence)conversation.getMessage())) {
                if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(this.userId)) {
                    holder.tvMessage.setText((CharSequence)("You: " + Html.fromHtml((String)conversation.getMessage())));
                } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(this.userId)) {
                    if (conversation.getLast_sent_by_full_name().contains(" ")) {
                        nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                        holder.tvMessage.setText((CharSequence)(nameArray[0] + ": " + Html.fromHtml((String)conversation.getMessage())));
                    } else {
                        holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + ": " + Html.fromHtml((String)conversation.getMessage())));
                    }
                } else {
                    holder.tvMessage.setText((CharSequence)Html.fromHtml((String)conversation.getMessage()));
                }
            } else if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(this.userId)) {
                holder.tvMessage.setText((CharSequence)"You sent a photo");
            } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(this.userId)) {
                if (conversation.getLast_sent_by_full_name().contains(" ")) {
                    nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                    holder.tvMessage.setText((CharSequence)(nameArray[0] + " sent a photo"));
                } else {
                    holder.tvMessage.setText((CharSequence)(conversation.getLast_sent_by_full_name() + " sent a Photo"));
                }
            } else {
                holder.tvMessage.setText((CharSequence)"You received a photo");
            }
            boolean isO2OChat = conversation.isA2AChat();
            if (conversation.getAgentName() != null && !conversation.getAgentName().isEmpty() && this.isAllChatClicked && !isO2OChat) {
                holder.tvAgentName.setVisibility(0);
                holder.tvAgentName.setText((CharSequence)conversation.getAgentName());
            } else {
                holder.tvAgentName.setVisibility(8);
            }
            holder.tvName.setText((CharSequence)conversation.getLabel());
            if (!TextUtils.isEmpty((CharSequence)conversation.getBotChannelName())) {
                holder.tvChannelName.setVisibility(0);
                holder.tvChannelName.setText((CharSequence)conversation.getBotChannelName());
            } else {
                holder.tvChannelName.setVisibility(8);
            }
            if (!conversation.getUnreadCount().equals(0)) {
                holder.tvUnread.setVisibility(0);
                holder.tvUnread.setText((CharSequence)String.valueOf(conversation.getUnreadCount()));
            } else {
                holder.tvUnread.setVisibility(8);
            }
            float d = this.context.getResources().getDisplayMetrics().density;
            if (conversation.getStatus().intValue() == MessageMode.CLOSED_CHAT.getOrdinal()) {
                holder.tvClosed.setVisibility(0);
                float width = this.context.getResources().getDimension(R.dimen.fugu_name_width);
                holder.tvName.setMaxWidth((int)width);
                holder.tvName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                holder.tvMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                holder.tvTime.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(3.0f * d), (int)(50.0f * d), 0);
                holder.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.hippo_bg_tag_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_read_chat_text_color));
            } else {
                holder.tvClosed.setVisibility(8);
                holder.tvClosed.setFilters(new InputFilter[]{new InputFilter.LengthFilter(R.dimen.fugu_name_width_unClose)});
                float width = this.context.getResources().getDimension(R.dimen.fugu_name_width_unClose);
                holder.tvName.setMaxWidth((int)width);
                holder.tvName.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                holder.tvMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                holder.tvTime.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_text_color_primary));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)holder.tvMessage.getLayoutParams();
                layoutParams.setMargins(0, (int)(-2.0f * d), (int)(50.0f * d), 0);
                holder.tvMessage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                holder.tvUnassigned.setBackgroundResource(R.drawable.hippo_bg_unassigned_color_rounded);
                holder.tvUnassigned.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.hippo_white));
            }
            if (conversation.getAgentId() <= 0) {
                holder.tvUnassigned.setVisibility(0);
            } else {
                holder.tvUnassigned.setVisibility(8);
            }
            if (conversation.getOverlay() != null && conversation.getOverlay().intValue() != Overlay.DEFAULT.getOrdinal()) {
                holder.tvOverlay.setVisibility(0);
                if (conversation.getOverlay().intValue() == Overlay.OPEN_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_chat_re_opened, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_green_95));
                    holder.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_re_opend));
                } else if (conversation.getOverlay().intValue() == Overlay.CLOSED_CHAT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_fugu_chat_close, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_black_95));
                    holder.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_closed));
                } else if (conversation.getOverlay().intValue() == Overlay.ASSIGNMENT.getOrdinal()) {
                    holder.tvOverlay.setCompoundDrawablesWithIntrinsicBounds(R.drawable.hippo_ic_fugu_chat_assigned, 0, 0, 0);
                    holder.tvOverlay.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_overlay_yellow_95));
                    holder.tvOverlay.setText((CharSequence)this.context.getResources().getString(R.string.fugu_conversation_assigned));
                }
            } else {
                holder.tvOverlay.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getCreatedAt())) {
                TextView textView = holder.tvTime;
                DateUtils.getInstance();
                textView.setText((CharSequence)DateUtils.getDateTimeToShow(conversation.getCreatedAt()));
            }
        } else if (viewholder instanceof ViewHolderHeader) {
            ViewHolderHeader holder = (ViewHolderHeader)viewholder;
            holder.tvHeader.setText((CharSequence)("2 " + this.context.getResources().getString(R.string.fugu_open_conversations)));
        }
    }

    public int getItemCount() {
        if (this.conversationList == null || this.conversationList.size() == 0) {
            return 0;
        }
        return this.conversationList.size();
    }

    public int getItemViewType(int position) {
        if (this.conversationList.get(position) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    @Override
    public void onItemClick(View viewClicked, View parentView) {
        int pos = this.recyclerView.getChildLayoutPosition(parentView);
        if (pos != -1 && viewClicked.getId() == R.id.rlChat) {
            Conversation conversation = (Conversation)this.conversationList.get(pos);
            this.callback.onClick(pos, this.fragmentType, conversation);
        }
    }

    private String getFileMessageData(Conversation conversation) {
        String message = "You sent a file";
        if (conversation.getLast_sent_by_user_type().equals(2) && conversation.getLast_sent_by_id().equals(AgentCommonData.getUserData().getUserId())) {
            message = "You sent a file";
        } else if (conversation.getLast_sent_by_user_type().equals(2) && !conversation.getLast_sent_by_id().equals(AgentCommonData.getUserData().getUserId())) {
            if (conversation.getLast_sent_by_full_name().contains(" ")) {
                String[] nameArray = conversation.getLast_sent_by_full_name().split("\\ ");
                message = nameArray[0] + " sent a file";
            } else {
                message = conversation.getLast_sent_by_full_name() + " sent a file";
            }
        } else {
            message = "You received a file";
        }
        return message;
    }

    private String getMessageData(Conversation currentChannelItem) {
        String message = "The video call ended";
        String customerName = "Customer";
        String callType = "video";
        String agentName = "You";
        if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            callType = "Voice";
        }
        if (currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState() == 2) {
            if (currentChannelItem.getLast_sent_by_user_type() == 1) {
                customerName = currentChannelItem.getLast_sent_by_full_name();
                if (!this.isChatAssignToMe(currentChannelItem)) {
                    agentName = currentChannelItem.getAgentName();
                }
                message = agentName + " missed a " + callType + " call with " + customerName;
            } else {
                agentName = currentChannelItem.getLast_sent_by_id().intValue() == AgentCommonData.getUserData().getUserId().intValue() ? "you" : currentChannelItem.getLast_sent_by_full_name();
                message = customerName + " missed a " + callType + " call with " + agentName;
            }
        } else {
            message = "The " + callType + " call ended";
        }
        return message;
    }

    private boolean isChatAssignToMe(Conversation currentChannelItem) {
        return currentChannelItem.getAgentId().intValue() == AgentCommonData.getUserData().getUserId().intValue();
    }

    public static interface Callback {
        public void onClick(int var1, int var2, Conversation var3);
    }

    private static class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class ProgressBarItem {
    }

    public class ViewHolderHeader
    extends RecyclerView.ViewHolder {
        public TextView tvHeader;

        public ViewHolderHeader(View itemView) {
            super(itemView);
            this.tvHeader = (TextView)itemView.findViewById(R.id.tvHeader);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public RelativeLayout rlChat;
        public TextView tvMessage;
        public TextView tvName;
        public TextView tvChannelName;
        public TextView tvTime;
        public TextView tvUnread;
        public TextView tvClosed;
        public TextView tvTyping;
        public TextView tvOverlay;
        public TextView tvTagged;
        public TextView tvUnassigned;
        public TextView tvAgentName;

        public ViewHolder(final View itemView, final ItemClickListener itemClickListener) {
            super(itemView);
            this.rlChat = (RelativeLayout)itemView.findViewById(R.id.rlChat);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.tvUnread = (TextView)itemView.findViewById(R.id.tvUnread);
            this.tvClosed = (TextView)itemView.findViewById(R.id.tvClosed);
            this.tvTyping = (TextView)itemView.findViewById(R.id.tvTyping);
            this.tvTagged = (TextView)itemView.findViewById(R.id.tvTagged);
            this.tvUnassigned = (TextView)itemView.findViewById(R.id.tvUnassigned);
            this.tvAgentName = (TextView)itemView.findViewById(R.id.tvAgentName);
            this.tvOverlay = (TextView)itemView.findViewById(R.id.tvOverlay);
            this.rlChat.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)ViewHolder.this.rlChat, itemView);
                }
            });
            this.tvOverlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
    }
}

