/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.promotional.Data;
import com.hippo.utils.DateUtils;
import com.hippo.utils.RoundedCornersTransformation;
import java.util.ArrayList;

public class CampaignAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context mContext;
    private OnItemClickListener itemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ArrayList<Data> arrayList;
    private RecyclerView recyclerView;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private String outputFormat = "dd MMM, yy h:mm a";
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public CampaignAdapter(ArrayList<Data> arrayList, RecyclerView recyclerView, OnItemClickListener itemClickListener) {
        this.arrayList = arrayList;
        this.recyclerView = recyclerView;
        this.itemClickListener = itemClickListener;
        this.hippoColorConfig = CommonData.getColorConfig();
        if (HippoConfig.getInstance().getMobileCampaignBuilder() != null && !TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat())) {
            this.outputFormat = HippoConfig.getInstance().getMobileCampaignBuilder().getParseFormat();
        }
    }

    public void setData(ArrayList<Data> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        this.mContext = viewGroup.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_layout_loaddata, viewGroup, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.hippo_item_campaign, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int pos) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder)holder;
            viewHolder.title.setText((CharSequence)this.arrayList.get(pos).getTitle());
            viewHolder.description.setText((CharSequence)this.arrayList.get(pos).getDescription());
            String time = DateUtils.getInstance().convertToLocal(this.arrayList.get(pos).getCreatedAt(), this.outputFormat);
            viewHolder.dateTime.setText((CharSequence)time);
            String imagePath = "";
            try {
                imagePath = this.arrayList.get(pos).getCustomAttributes().getImage().getImageUrl();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)imagePath)) {
                viewHolder.imageView.setVisibility(8);
            } else {
                viewHolder.imageView.setVisibility(0);
                RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.mContext, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.hippo_placeholder));
                Glide.with((Context)this.mContext).load(imagePath).apply((BaseRequestOptions)myOptions).into(viewHolder.imageView);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getUserId() == -3) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        boolean isProgressBarExist;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl = isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getUserId() == -3;
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static Data progressBarModel;

        private ProgressBarModel() {
        }

        public static Data getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new Data(-3);
            }
            return progressBarModel;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView imageView;
        private TextView title;
        private TextView description;
        private TextView dateTime;
        private LinearLayout mainLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.mainLayout);
            this.imageView = (ImageView)itemView.findViewById(R.id.ivImage);
            this.title = (TextView)itemView.findViewById(R.id.tvTitle);
            this.description = (TextView)itemView.findViewById(R.id.tvDescription);
            this.dateTime = (TextView)itemView.findViewById(R.id.tvDateTime);
            this.title.setTextColor(CampaignAdapter.this.hippoColorConfig.getHippoPromotionalTitle());
            this.description.setTextColor(CampaignAdapter.this.hippoColorConfig.getHippoPromotionalMessage());
            this.dateTime.setTextColor(CampaignAdapter.this.hippoColorConfig.getHippoPromotionalTime());
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CampaignAdapter.this.itemClickListener != null) {
                        CampaignAdapter.this.itemClickListener.onClickListener(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }
}

