/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.CaptureUserData;
import com.hippo.GroupingTag;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoNotificationConfig;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.FuguChannelsAdapter;
import com.hippo.adapter.HippoChannelsAdapter;
import com.hippo.apis.ApiGetConversation;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UnreadCountModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.StringUtil;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.fileUpload.Prefs;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import retrofit2.Callback;

public class FuguChannelsActivity
extends FuguBaseActivity
implements SwipeRefreshLayout.OnRefreshListener,
Animation.AnimationListener {
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;
    private RelativeLayout rlRoot;
    private SwipeRefreshLayout swipeRefresh;
    private TextView tvNoInternet;
    private TextView tvNewConversation;
    private final int READ_PHONE_PERMISSION = 101;
    private final String TAG = FuguChannelsActivity.class.getSimpleName();
    private RecyclerView rvChannels;
    private FuguChannelsAdapter fuguChannelsAdapter;
    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;
    private final int IS_HIT_REQUIRED = 200;
    public static boolean isRefresh = false;
    public static Long readChannelId = -1L;
    public static Long readLabelId = -1L;
    private TextView tvPoweredBy;
    private HippoColorConfig hippoColorConfig;
    @SuppressLint(value={"StaticFieldLeak"})
    private static LinearLayout llInternet;
    @SuppressLint(value={"StaticFieldLeak"})
    private static TextView tvStatus;
    private boolean isScreenOpen = false;
    private boolean isFirstTimeOpen = true;
    private HippoChannelsAdapter hippoChannelsAdapter;
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean isPagingApiInProgress;
    private HippoChannelsAdapter.ProgressBarItem progressBarItem;
    private ArrayList<Object> fuguConversationList = new ArrayList();
    BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!FuguChannelsActivity.this.isScreenOpen) {
                    return;
                }
                JSONObject messageJson = new JSONObject(intent.getStringExtra("message"));
                HippoLog.d("receiver", "Got message: " + messageJson.toString());
                boolean hasChannelID = false;
                boolean hasLabelID = false;
                if (messageJson.has("notification_type") && messageJson.getInt("notification_type") == 5) {
                    FuguChannelsActivity.this.getConversations();
                } else {
                    FuguConversation currentConversation;
                    int index;
                    if (messageJson.has("channel_id") && messageJson.getLong("channel_id") > 0L && (index = FuguChannelsActivity.this.fuguConversationList.indexOf(new FuguConversation(messageJson.getLong("channel_id")))) != -1) {
                        hasChannelID = true;
                    }
                    if (messageJson.has("label_id") && messageJson.getLong("label_id") > 0L) {
                        for (int i = 0; i < FuguChannelsActivity.this.fuguConversationList.size(); ++i) {
                            if (!(FuguChannelsActivity.this.fuguConversationList.get(i) instanceof FuguConversation) || (currentConversation = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(i)).getLabelId().longValue() != messageJson.getLong("label_id")) continue;
                            hasLabelID = true;
                            break;
                        }
                    }
                    if (!hasChannelID && !hasLabelID) {
                        FuguChannelsActivity.this.getConversations();
                    } else if (messageJson.has("new_message") && messageJson.has("channel_id")) {
                        index = FuguChannelsActivity.this.fuguConversationList.indexOf(new FuguConversation(messageJson.getLong("channel_id")));
                        if (index > -1) {
                            if (FuguChannelsActivity.this.fuguConversationList.get(index) instanceof FuguConversation) {
                                currentConversation = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(index);
                                currentConversation.setDateTime(messageJson.getString("date_time").replace("+00:00", ".000Z"));
                                if (messageJson.has("new_message")) {
                                    currentConversation.setMessage(messageJson.getString("new_message"));
                                }
                                if (HippoNotificationConfig.pushChannelId.compareTo(messageJson.getLong("channel_id")) != 0) {
                                    currentConversation.setUnreadCount(currentConversation.getUnreadCount() + 1);
                                } else {
                                    currentConversation.setUnreadCount(0);
                                }
                                currentConversation.setLast_sent_by_id(messageJson.getLong("last_sent_by_id"));
                                currentConversation.setLast_sent_by_full_name(messageJson.getString("last_sent_by_full_name"));
                                if (FuguChannelsActivity.this.fuguChannelsAdapter != null) {
                                    FuguChannelsActivity.this.fuguChannelsAdapter.notifyDataSetChanged();
                                }
                                if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                                    FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                                }
                                FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                            }
                        } else {
                            FuguChannelsActivity.this.getConversations();
                        }
                    } else if (messageJson.has("new_message") && messageJson.has("label_id")) {
                        index = -1;
                        for (int i = 0; i < FuguChannelsActivity.this.fuguConversationList.size(); ++i) {
                            FuguConversation currentConversation2;
                            if (!(FuguChannelsActivity.this.fuguConversationList.get(i) instanceof FuguConversation) || (currentConversation2 = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(i)).getLabelId().compareTo(messageJson.getLong("label_id")) != 0) continue;
                            index = i;
                            break;
                        }
                        if (index > -1) {
                            if (FuguChannelsActivity.this.fuguConversationList.get(index) instanceof FuguConversation) {
                                FuguConversation currentConversation3 = (FuguConversation)FuguChannelsActivity.this.fuguConversationList.get(index);
                                currentConversation3.setDateTime(messageJson.getString("date_time").replace("+00:00", ".000Z"));
                                if (messageJson.has("new_message")) {
                                    currentConversation3.setMessage(messageJson.getString("new_message"));
                                }
                                if (HippoNotificationConfig.pushLabelId.compareTo(messageJson.getLong("label_id")) != 0) {
                                    currentConversation3.setUnreadCount(currentConversation3.getUnreadCount() + 1);
                                } else {
                                    currentConversation3.setUnreadCount(0);
                                }
                                currentConversation3.setLast_sent_by_id(messageJson.getLong("last_sent_by_id"));
                                currentConversation3.setLast_sent_by_full_name(messageJson.getString("last_sent_by_full_name"));
                                if (FuguChannelsActivity.this.fuguChannelsAdapter != null) {
                                    FuguChannelsActivity.this.fuguChannelsAdapter.notifyDataSetChanged();
                                }
                                if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                                    FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                                }
                                FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                            }
                        } else {
                            FuguChannelsActivity.this.getConversations();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fugu_activity_channels);
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mMessageReceiver, new IntentFilter("notification_received"));
        this.initViews();
        this.decideAppFlow();
        HippoConfig.getInstance().setChannelActivity(true);
    }

    private void initViews() {
        this.hippoColorConfig = CommonData.getColorConfig();
        Toolbar myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(myToolbar);
        String title = this.getIntent().getStringExtra("title");
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = CommonData.getChatTitle();
        }
        this.setToolbar(myToolbar, title);
        this.appVersion = this.getIntent().getIntExtra("appVersion", 0);
        this.rlRoot = (RelativeLayout)this.findViewById(R.id.rlRoot);
        this.swipeRefresh = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefresh);
        this.swipeRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.tvNoInternet = (TextView)this.findViewById(R.id.tvNoInternet);
        this.tvNewConversation = (TextView)this.findViewById(R.id.tvNewConversation);
        this.tvPoweredBy = (TextView)this.findViewById(R.id.tvPoweredBy);
        tvStatus = (TextView)this.findViewById(R.id.tvStatus);
        llInternet = (LinearLayout)this.findViewById(R.id.llInternet);
        this.configColors();
        if (!this.isNetworkAvailable()) {
            llInternet.setVisibility(0);
            llInternet.setBackgroundColor(Color.parseColor((String)"#FF0000"));
            tvStatus.setText(R.string.fugu_not_connected_to_internet);
        }
        this.rvChannels = (RecyclerView)this.findViewById(R.id.rvChannels);
        this.tvNewConversation.setVisibility(HippoConfig.getInstance().isShowCreateBtn() ? 0 : 8);
    }

    public boolean isPagingApiInProgress() {
        return this.isPagingApiInProgress;
    }

    public void setPagingApiInProgress(boolean pagingApiInProgress) {
        this.isPagingApiInProgress = pagingApiInProgress;
    }

    private void fetchNextPage() {
        this.toggleProgressBarVisibility(true);
        this.setPagingApiInProgress(true);
        int size = this.fuguConversationList.size();
        new ApiGetConversation((Activity)this, new ApiGetConversation.CallbackListener(){

            @Override
            public void onSuccess(FuguGetConversationsResponse fuguGetConversationsResponse) {
            }

            @Override
            public void onFailure() {
            }
        }).getConversation(this.enUserId, size, false, true);
    }

    private void decideAppFlow() {
        if (CommonData.getUserDetails() != null && CommonData.getConversationList().size() > 0) {
            this.setUpUI();
            this.getConversations(true);
        } else {
            this.sendUserDetails();
        }
    }

    private void setApiHit() {
        if (CommonData.getUserDetails() != null && CommonData.getConversationList().size() > 0) {
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setUpUI() {
        this.tvNoInternet.setVisibility(8);
        this.swipeRefresh.setVisibility(0);
        FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
        this.label = userData.getBusinessName();
        this.businessName = userData.getBusinessName();
        this.userId = userData.getUserId();
        this.enUserId = userData.getEn_user_id();
        if (!TextUtils.isEmpty((CharSequence)userData.getFullName())) {
            this.userName = userData.getFullName();
        }
        this.fuguConversationList.clear();
        try {
            if (CommonData.getConversationList().size() > 0) {
                this.fuguConversationList.addAll(CommonData.getConversationList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setRecyclerViewData();
        this.setPoweredByText(userData);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public static void changeStatus(int status) {
        switch (status) {
            case 0: {
                llInternet.setVisibility(0);
                llInternet.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                tvStatus.setText(R.string.fugu_not_connected_to_internet);
                break;
            }
            case 1: 
            case 2: {
                llInternet.setBackgroundColor(Color.parseColor((String)"#FFA500"));
                tvStatus.setText(R.string.fugu_connecting);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        llInternet.setBackgroundColor(Color.parseColor((String)"#00FF00"));
                        tvStatus.setText(R.string.fugu_connected);
                        llInternet.setVisibility(8);
                    }
                }, 1500L);
                break;
            }
        }
    }

    public void onRefresh() {
        this.getConversations();
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
    }

    public void onAnimationRepeat(Animation animation) {
    }

    @Override
    protected void onResume() {
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        if (nm != null) {
            nm.cancelAll();
        }
        super.onResume();
        this.isScreenOpen = true;
        if (isRefresh) {
            isRefresh = false;
            try {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    if (!(this.fuguConversationList.get(i) instanceof FuguConversation)) continue;
                    FuguConversation currentConversation = (FuguConversation)this.fuguConversationList.get(i);
                    if (readChannelId > -1L && currentConversation.getChannelId() > -1L && currentConversation.getChannelId().compareTo(readChannelId) == 0) {
                        currentConversation.setUnreadCount(0);
                        if (this.fuguChannelsAdapter != null) {
                            this.fuguChannelsAdapter.notifyDataSetChanged();
                        }
                        if (this.hippoChannelsAdapter != null) {
                            this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                    } else {
                        if (readLabelId <= -1L || currentConversation.getLabelId() <= -1L || currentConversation.getLabelId().compareTo(readLabelId) != 0) continue;
                        currentConversation.setUnreadCount(0);
                        if (this.fuguChannelsAdapter != null) {
                            this.fuguChannelsAdapter.notifyDataSetChanged();
                        }
                        if (this.hippoChannelsAdapter != null) {
                            this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateCount(this.fuguConversationList);
        }
        if (!this.isFirstTimeOpen) {
            this.setApiHit();
        }
        this.isFirstTimeOpen = false;
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.isScreenOpen = false;
        this.isFirstTimeOpen = false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        HippoLog.d(this.TAG, "Permission callback called-------" + requestCode);
        switch (requestCode) {
            case 101: {
                if (HippoConfig.getInstance().getTargetSDKVersion() > 22 && grantResults.length > 0 && grantResults[0] == 0) {
                    this.sendUserDetails();
                    break;
                }
                if (HippoConfig.getInstance().getTargetSDKVersion() <= 22 && grantResults.length > 0 && grantResults[0] == 0) {
                    this.sendUserDetails();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"Go to Settings and grant permission to access phone state", (int)1).show();
                this.finish();
            }
        }
    }

    private void configColors() {
        this.rlRoot.setBackgroundColor(this.hippoColorConfig.getHippoChannelBg());
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        if (Build.VERSION.SDK_INT >= 16) {
            this.tvNewConversation.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        } else {
            this.tvNewConversation.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        }
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.swipeRefresh.setColorSchemeColors(new int[]{this.hippoColorConfig.getHippoThemeColorPrimary()});
        this.tvNoInternet.setTextColor(this.hippoColorConfig.getHippoThemeColorSecondary());
    }

    protected void onDestroy() {
        super.onDestroy();
        HippoConfig.getInstance().setChannelActivity(false);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mMessageReceiver);
        readChannelId = null;
        readLabelId = null;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tvNoInternet) {
            if (CommonData.getUserDetails() != null) {
                this.getConversations();
            } else {
                this.sendUserDetails();
            }
        } else if (v.getId() == R.id.tvNewConversation) {
            Intent chatIntent = new Intent((Context)this, FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setUserId(this.userId);
            conversation.setLabel(this.label);
            conversation.setUserName(this.userName);
            conversation.setStatus(1);
            conversation.setEnUserId(this.enUserId);
            chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
            this.startActivityForResult(chatIntent, 200);
        } else if (v.getId() == R.id.tvPoweredBy) {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setData(Uri.parse((String)"https://fuguchat.com"));
            this.startActivity(i);
        }
    }

    private void sendUserDetails() {
        if (this.isNetworkAvailable()) {
            String deviceToken;
            Gson gson = new GsonBuilder().create();
            JsonObject deviceDetailsJson = null;
            try {
                deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(this.appVersion).getDeviceDetails()).getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            CaptureUserData userData = null;
            if (userData == null) {
                userData = HippoConfig.getInstance().getUserData();
            }
            HashMap<String, Object> commonParams = new HashMap<String, Object>();
            HippoConfig.getInstance();
            if (HippoConfig.getmResellerToken() != null) {
                commonParams.put("reseller_token", HippoConfig.getmResellerToken());
                commonParams.put("reference_id", String.valueOf(HippoConfig.getmReferenceId()));
            } else {
                commonParams.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            }
            commonParams.put("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this));
            commonParams.put("app_type", HippoConfig.getInstance().getAppType());
            commonParams.put("device_type", 1);
            commonParams.put("app_version", "2.0.8");
            commonParams.put("device_details", deviceDetailsJson);
            if (userData != null) {
                if (!TextUtils.isEmpty((CharSequence)userData.getUserUniqueKey())) {
                    commonParams.put("user_unique_key", userData.getUserUniqueKey().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getFullName())) {
                    commonParams.put("full_name", userData.getFullName().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getEmail())) {
                    commonParams.put("email", userData.getEmail().trim());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getPhoneNumber())) {
                    String contact = userData.getPhoneNumber().replaceAll("[^\\d.]", "");
                    commonParams.put("phone_number", contact);
                }
                if (!TextUtils.isEmpty((CharSequence)CommonData.getImagePath())) {
                    commonParams.put("user_image", CommonData.getImagePath());
                }
                if (!userData.getTags().isEmpty()) {
                    ArrayList<GroupingTag> groupingTags = new ArrayList<GroupingTag>();
                    for (GroupingTag tag : userData.getTags()) {
                        GroupingTag groupingTag = new GroupingTag();
                        if (!TextUtils.isEmpty((CharSequence)tag.getTagName())) {
                            groupingTag.setTagName(tag.getTagName());
                        }
                        if (tag.getTeamId() != null) {
                            groupingTag.setTeamId(tag.getTeamId());
                        }
                        if (TextUtils.isEmpty((CharSequence)tag.getTagName()) && tag.getTeamId() == null) continue;
                        groupingTags.add(groupingTag);
                    }
                    commonParams.put("grouping_tags", new Gson().toJson(groupingTags));
                } else {
                    commonParams.put("grouping_tags", "[]");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceToken = CommonData.getAttributes().getDeviceToken()))) {
                commonParams.put("device_token", deviceToken);
            }
            if (userData != null && !userData.getCustom_attributes().isEmpty()) {
                commonParams.put("custom_attributes", new JSONObject(userData.getCustom_attributes()));
            }
            HippoLog.e(this.TAG + "sendUserDetails map", "==" + commonParams.toString());
            if (!TextUtils.isEmpty((CharSequence)HippoConfig.getmResellerToken())) {
                this.apiPutUserDetailReseller(commonParams);
            } else {
                this.apiPutUserDetail(commonParams);
            }
        } else {
            this.tvNoInternet.setVisibility(0);
            this.swipeRefresh.setVisibility(8);
            this.tvNewConversation.setVisibility(HippoConfig.getInstance().isShowCreateBtn() ? 0 : 8);
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetails(params.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)FuguChannelsActivity.this).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)FuguChannelsActivity.this).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)FuguChannelsActivity.this).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)FuguChannelsActivity.this).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FuguChannelsActivity.this.setUpUI();
                try {
                    if (fuguPutUserDetailsResponse.getData().getFuguConversations().size() == 0) {
                        Intent chatIntent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                        FuguConversation conversation = new FuguConversation();
                        conversation.setBusinessName(CommonData.getChatTitle());
                        conversation.setOpenChat(true);
                        conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                        conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                        conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                        chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                        FuguChannelsActivity.this.startActivity(chatIntent);
                        FuguChannelsActivity.this.finish();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(error.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (error.getStatusCode() == 403) {
                    Toast.makeText((Context)FuguChannelsActivity.this, (CharSequence)error.getMessage(), (int)0).show();
                    FuguChannelsActivity.this.finish();
                } else {
                    FuguChannelsActivity.this.tvNoInternet.setVisibility(0);
                    FuguChannelsActivity.this.swipeRefresh.setVisibility(8);
                    FuguChannelsActivity.this.tvNewConversation.setVisibility(8);
                }
            }
        });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> commonParams) {
        try {
            if (HippoConfig.getInstance().getOnApiCallback() != null) {
                HippoConfig.getInstance().getOnApiCallback().onProcessing();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetailsReseller(params.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)FuguChannelsActivity.this).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)FuguChannelsActivity.this).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)FuguChannelsActivity.this).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)FuguChannelsActivity.this).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onSucess();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FuguChannelsActivity.this.setUpUI();
                try {
                    if (fuguPutUserDetailsResponse.getData().getFuguConversations().size() == 0) {
                        Intent chatIntent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                        FuguConversation conversation = new FuguConversation();
                        conversation.setBusinessName(CommonData.getChatTitle());
                        conversation.setOpenChat(true);
                        conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                        conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                        conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                        chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                        FuguChannelsActivity.this.startActivity(chatIntent);
                        FuguChannelsActivity.this.finish();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
                try {
                    if (HippoConfig.getInstance().getOnApiCallback() != null) {
                        HippoConfig.getInstance().getOnApiCallback().onFailure(error.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (error.getStatusCode() == 403) {
                    Toast.makeText((Context)FuguChannelsActivity.this, (CharSequence)error.getMessage(), (int)0).show();
                    FuguChannelsActivity.this.finish();
                } else {
                    FuguChannelsActivity.this.tvNoInternet.setVisibility(0);
                    FuguChannelsActivity.this.swipeRefresh.setVisibility(8);
                    FuguChannelsActivity.this.tvNewConversation.setVisibility(8);
                }
            }
        });
    }

    private void getConversations() {
        this.getConversations(false);
    }

    private void getConversations(boolean showLoader) {
        if (this.isNetworkAvailable()) {
            new ApiGetConversation((Activity)this, new ApiGetConversation.CallbackListener(){

                @Override
                public void onSuccess(FuguGetConversationsResponse fuguGetConversationsResponse) {
                    try {
                        for (int i = 0; i < fuguGetConversationsResponse.getData().getFuguConversationList().size(); ++i) {
                            String removeLt = fuguGetConversationsResponse.getData().getFuguConversationList().get(i).getMessage().replaceAll("<", "&lt;");
                            String removeGt = removeLt.replaceAll(">", "&gt;");
                            fuguGetConversationsResponse.getData().getFuguConversationList().get(i).setMessage(removeGt);
                        }
                        CommonData.setConversationList(fuguGetConversationsResponse.getData().getFuguConversationList());
                        FuguChannelsActivity.this.fuguConversationList.clear();
                        FuguChannelsActivity.this.fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                        FuguChannelsActivity.this.updateCount(FuguChannelsActivity.this.fuguConversationList);
                        if (FuguChannelsActivity.this.fuguChannelsAdapter != null) {
                            FuguChannelsActivity.this.fuguChannelsAdapter.notifyDataSetChanged();
                        }
                        if (FuguChannelsActivity.this.hippoChannelsAdapter != null) {
                            FuguChannelsActivity.this.hippoChannelsAdapter.notifyDataSetChanged();
                        }
                        FuguChannelsActivity.this.swipeRefresh.setRefreshing(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure() {
                    FuguChannelsActivity.this.swipeRefresh.setRefreshing(false);
                }
            }).getConversation(this.enUserId, 1, showLoader, false);
        } else {
            this.swipeRefresh.setRefreshing(false);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 200 && resultCode == -1) {
            FuguConversation conversation = (FuguConversation)new Gson().fromJson(data.getStringExtra("conversation"), FuguConversation.class);
            if (conversation != null && conversation.getLabelId().compareTo(-1L) != 0) {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    FuguConversation fuguConversation;
                    if (!(this.fuguConversationList.get(i) instanceof FuguConversation) || (fuguConversation = (FuguConversation)this.fuguConversationList.get(i)).getLabelId().compareTo(conversation.getLabelId()) != 0) continue;
                    fuguConversation.setChannelId(conversation.getChannelId());
                    fuguConversation.setMessage(conversation.getDefaultMessage());
                    fuguConversation.setDateTime(conversation.getDateTime());
                    fuguConversation.setChannelStatus(conversation.getChannelStatus());
                    fuguConversation.setIsTimeSet(1);
                    fuguConversation.setLast_sent_by_id(conversation.getLast_sent_by_id());
                    fuguConversation.setUserId(conversation.getLast_sent_by_id());
                    fuguConversation.setEnUserId(conversation.getEnUserId());
                    fuguConversation.setLast_message_status(conversation.getLast_message_status());
                    fuguConversation.setChatType(conversation.getChatType());
                    if (this.hippoChannelsAdapter != null) {
                        this.hippoChannelsAdapter.updateList(this.fuguConversationList);
                    }
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            } else if (conversation != null && conversation.getLabelId().compareTo(-1L) == 0) {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    FuguConversation fuguConversation;
                    if (!(this.fuguConversationList.get(i) instanceof FuguConversation) || (fuguConversation = (FuguConversation)this.fuguConversationList.get(i)).getChannelId().compareTo(conversation.getChannelId()) != 0) continue;
                    fuguConversation.setChannelId(conversation.getChannelId());
                    fuguConversation.setMessage(conversation.getDefaultMessage());
                    fuguConversation.setDateTime(conversation.getDateTime());
                    fuguConversation.setChannelStatus(conversation.getChannelStatus());
                    fuguConversation.setIsTimeSet(1);
                    fuguConversation.setLast_sent_by_id(conversation.getLast_sent_by_id());
                    fuguConversation.setLast_message_status(conversation.getLast_message_status());
                    fuguConversation.setChatType(conversation.getChatType());
                    if (this.hippoChannelsAdapter != null) {
                        this.hippoChannelsAdapter.updateList(this.fuguConversationList);
                    }
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            }
        }
        try {
            if (CommonData.getIsNewChat()) {
                this.getConversations();
                CommonData.setIsNewchat(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRecyclerViewData() {
        this.hippoChannelsAdapter = new HippoChannelsAdapter((Activity)this, this.fuguConversationList, this.userName, this.userId, this.businessName, new HippoChannelsAdapter.Callback(){

            @Override
            public void onClick(FuguConversation conversation) {
                Intent chatIntent = new Intent((Context)FuguChannelsActivity.this, FuguChatActivity.class);
                chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                FuguChannelsActivity.this.startActivityForResult(chatIntent, 200);
            }
        }, this.enUserId);
        this.updateCount(this.fuguConversationList);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.rvChannels.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        if (this.fuguChannelsAdapter != null) {
            this.rvChannels.setAdapter((RecyclerView.Adapter)this.fuguChannelsAdapter);
        }
        if (this.hippoChannelsAdapter != null) {
            this.rvChannels.setAdapter((RecyclerView.Adapter)this.hippoChannelsAdapter);
        }
    }

    private void setPoweredByText(FuguPutUserDetailsResponse.Data userData) {
        if (!userData.getWhiteLabel().booleanValue()) {
            try {
                this.poweredByView(this.getString(R.string.fugu_powered_by), this.getString(R.string.fugu_text), this.hippoColorConfig);
            }
            catch (Exception e) {
                if (Build.VERSION.SDK_INT >= 24) {
                    String text = "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getFuguRunsOnColor()) + "> " + this.getString(R.string.fugu_text) + "</font>";
                    this.tvPoweredBy.setText((CharSequence)Html.fromHtml((String)text));
                } else {
                    String text = "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getHippoTextColorPrimary()) + ">" + this.getString(R.string.fugu_powered_by) + "<font color=" + String.format("#%06X", 0xFFFFFF & this.hippoColorConfig.getFuguRunsOnColor()) + "> " + this.getString(R.string.fugu_text) + "</font>";
                    this.tvPoweredBy.setText((CharSequence)Html.fromHtml((String)text));
                }
                this.tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(this.hippoColorConfig.getHippoChannelItemBg(), this.hippoColorConfig.getHippoChannelItemBgPressed()));
            }
        } else {
            this.tvPoweredBy.setVisibility(8);
        }
    }

    private void poweredByView(String firstString, String lastString, HippoColorConfig hippoColorConfig) throws Exception {
        String changeString = lastString != null ? lastString : "Hippo";
        String totalString = firstString + " " + changeString;
        Log.v((String)this.TAG, (String)("totalString = " + totalString));
        SpannableString spanText = new SpannableString((CharSequence)totalString);
        spanText.setSpan((Object)new StyleSpan(1), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new ForegroundColorSpan(hippoColorConfig.getFuguRunsOnColor()), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new RelativeSizeSpan(0.8f), 0, String.valueOf(firstString).length(), 0);
        this.tvPoweredBy.setText((CharSequence)spanText);
        this.tvPoweredBy.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(hippoColorConfig.getHippoChannelItemBg(), hippoColorConfig.getHippoChannelItemBgPressed()));
    }

    private void updateCount(ArrayList<Object> fuguConversationList) {
        try {
            int count = 0;
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            for (int i = 0; i < fuguConversationList.size(); ++i) {
                FuguConversation currentConversation;
                if (!(fuguConversationList.get(i) instanceof FuguConversation) || (currentConversation = (FuguConversation)fuguConversationList.get(i)).getUnreadCount() <= 0) continue;
                UnreadCountModel countModel = new UnreadCountModel(currentConversation.getChannelId(), currentConversation.getLabelId(), currentConversation.getUnreadCount());
                this.unreadCountModels.add(countModel);
                count += currentConversation.getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
            HippoLog.e(this.TAG, "unreadCountModels: " + new Gson().toJson(this.unreadCountModels));
            HippoLog.v(this.TAG, "unreadCountModels size = " + this.unreadCountModels.size());
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new HippoChannelsAdapter.ProgressBarItem();
            }
            if (!this.fuguConversationList.contains(this.progressBarItem)) {
                this.fuguConversationList.add(this.progressBarItem);
                this.rvChannels.post(new Runnable(){

                    @Override
                    public void run() {
                        FuguChannelsActivity.this.hippoChannelsAdapter.notifyItemInserted(FuguChannelsActivity.this.fuguConversationList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.fuguConversationList.contains(this.progressBarItem)) {
            this.fuguConversationList.remove(this.progressBarItem);
            this.hippoChannelsAdapter.notifyItemRemoved(this.fuguConversationList.size() - 1);
        }
    }
}

