/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.filepicker.MyForeGroundService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class FuguBaseActivity
extends AppCompatActivity
implements FuguAppConstant {
    private static final String TAG = FuguBaseActivity.class.getSimpleName();
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setStatusBarColor();
        }
        this.uncaughtExceptionError();
    }

    @RequiresApi(api=21)
    private void setStatusBarColor() {
        Window window = this.getWindow();
        window.clearFlags(0x4000000);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(CommonData.getColorConfig().getHippoStatusBar());
    }

    protected void checkAutoUpload() {
        if (!this.isMyServiceRunning(MyForeGroundService.class)) {
            ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
            if (fileuploadModels == null) {
                return;
            }
            HippoLog.e("TAG", "fileuploadModels data = " + new Gson().toJson((Object)fileuploadModels));
            if (fileuploadModels.size() > 0) {
                Intent intent = new Intent(this.getBaseContext(), MyForeGroundService.class);
                intent.setAction("start");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.startForegroundService(intent);
                } else {
                    this.startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void uncaughtExceptionError() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread paramThread, Throwable paramThrowable) {
                HippoLog.e("unCaughtException paramThread", "---> " + paramThread.toString());
                HippoLog.e("unCaughtException paramThrowable", "---> " + paramThrowable.toString());
                StringWriter stackTrace = new StringWriter();
                paramThrowable.printStackTrace(new PrintWriter(stackTrace));
                HippoLog.e("unCaughtException stackTrace", "---> " + stackTrace);
                System.err.println(stackTrace);
                if (!HippoConfig.DEBUG) {
                    FuguBaseActivity.this.apiSendError(stackTrace.toString());
                }
            }
        });
    }

    public void apiSendError(String logs) {
        if (this.isNetworkAvailable()) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            JSONObject error = new JSONObject();
            try {
                error.put("log", (Object)logs);
                if (pInfo != null) {
                    error.put("version", pInfo.versionCode);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            params.put("device_type", 1);
            params.put("app_version", 208);
            params.put("device_details", CommonData.deviceDetails((Context)this));
            params.put("error", error.toString());
            CommonParams commonParams = new CommonParams.Builder().putMap(params).build();
            RestClient.getApiInterface().sendError(commonParams.getMap()).enqueue((Callback)new ResponseResolver<CommonResponse>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(true)){

                @Override
                public void success(CommonResponse commonResponse) {
                    HippoLog.v("success", commonResponse.toString());
                }

                @Override
                public void failure(APIError error) {
                    HippoLog.v("failure", error.toString());
                }
            });
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title, String subTitle) {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            toolbar.setSubtitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            ab.setTitle((CharSequence)title);
            ab.setSubtitle((CharSequence)subTitle);
        }
        return this.getSupportActionBar();
    }

    protected void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1) {
                ab.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());
            }
            ab.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return this.getSupportActionBar();
    }

    public void showErrorMessage(String errorMessage, String positiveButtonText) {
        this.showErrorMessage(errorMessage, positiveButtonText, false);
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)FuguBaseActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (isFinish) {
                            FuguBaseActivity.this.finish();
                        }
                    }
                }).setCancelable(false).show();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onPause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (HippoConfig.getInstance().getLifeCyclerListener() != null) {
            HippoConfig.getInstance().getLifeCyclerListener().onResume();
        }
    }
}

