package com.hippo.campaign;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.MobileCampaignBuilder;
import com.hippo.NotificationListener;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.adapter.CampaignAdapter;
import com.hippo.apis.ApiGetMobileNotification;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.filepicker.ToastUtil;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-12-23.
 *
 * @author gurmail
 */
public class CampaignActivity extends FuguBaseActivity implements OnItemClickListener, SwipeRefreshLayout.OnRefreshListener {

    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recyclerView;
    private CampaignAdapter campaignAdapter;
    private MobileCampaignBuilder campaignBuilder;
    private int startOffset = 0;
    private int offset = 19;
    private int endOffset;
    private ArrayList<Data> arrayList = new ArrayList<>();
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private LinearLayout llNoConversation;
    private TextView titleError, detailError;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.hippo_campaigns_layout);

        campaignBuilder = HippoConfig.getInstance().getMobileCampaignBuilder();

        Toolbar myToolbar = findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);
        String title = campaignBuilder.getmTitle();
        if (TextUtils.isEmpty(title))
            title = CommonData.getChatTitle();
        setToolbar(myToolbar, title);

        endOffset = startOffset + offset;
        refreshLayout = findViewById(R.id.swipe_refresh);
        refreshLayout.setOnRefreshListener(this);
        refreshLayout.setColorSchemeResources(R.color.hippo_white);
        refreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        refreshLayout.setSize(SwipeRefreshLayout.DEFAULT);

        titleError = findViewById(R.id.title_error);
        detailError = findViewById(R.id.detail_error);

        titleError.setText("No Message Found");
        detailError.setText("Currently no message available");

        recyclerView = findViewById(R.id.recyclerView);
        layoutManager = new LinearLayoutManager(this);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);
        campaignAdapter = new CampaignAdapter(null, recyclerView, this);
        recyclerView.setAdapter(campaignAdapter);
        llNoConversation = findViewById(R.id.llNoConversation);

        fetchData();

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (!isPagingApiInProgress && hasMorePages) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            startOffset = endOffset+1;
                            endOffset = startOffset +offset;
                            fetchData();
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();

    }

    @Override
    protected void onPause() {
        super.onPause();

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

    }

    @Override
    public void onRefresh() {
        if(isNetworkAvailable()) {
            startOffset = 0;
            endOffset = startOffset + offset;
            fetchData();
        } else {
            refreshLayout.setRefreshing(false);
        }
    }

    private void fetchData() {
        if(isNetworkAvailable()) {
            if(startOffset != 0) {
                isPagingApiInProgress= true;
                campaignAdapter.showPaginationProgressBar(true, true);
            }
            new ApiGetMobileNotification(this, new NotificationListener() {
                @Override
                public void onSucessListener(PromotionResponse response) {
                    try {

                        if (arrayList == null)
                            arrayList = new ArrayList<>();

                        if (startOffset == 0)
                            arrayList.clear();

                        if (startOffset != 0) {
                            isPagingApiInProgress = false;
                            campaignAdapter.showPaginationProgressBar(false, true);
                        }

                        arrayList.addAll(response.getData());

                        if (arrayList.size() == 0) {
                            llNoConversation.setVisibility(View.VISIBLE);
                        } else {
                            llNoConversation.setVisibility(View.GONE);
                        }

                        if(campaignAdapter != null) {
                            campaignAdapter.setData(arrayList);
                        }
                        refreshLayout.setRefreshing(false);
                        hasMorePages = response.getData().size() == offset;

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureListener() {
                    refreshLayout.setRefreshing(false);
                    if (startOffset != 0) {
                        isPagingApiInProgress = false;
                        campaignAdapter.showPaginationProgressBar(false, true);
                    }
                }

                @Override
                public void onItemClickListener(String url) {

                }
            }).getNotificationData(startOffset, endOffset);
        } else {
            ToastUtil.getInstance(this).showToast(R.string.fugu_not_connected_to_internet);
            refreshLayout.setRefreshing(false);
            if (startOffset != 0) {
                isPagingApiInProgress = false;
                campaignAdapter.showPaginationProgressBar(false, true);
            }
        }
    }

    @Override
    public void onLoadMore() {

    }

    @Override
    public void onClickListener(int position) {
        try {
            if(campaignBuilder != null && campaignBuilder.getListener() != null) {
                String data = new Gson().toJson(arrayList.get(position).getCustomAttributes());
                campaignBuilder.getListener().onItemClickListener(data);


//                Intent notificationIntent = new Intent();
//                String packageName = "hipposdk.com.hipposdk";//getApplicationContext().getPackageName();
//                String className = "PushActivity";
//                notificationIntent.setComponent(new ComponentName("com.test.hipposdk", packageName+"."+className));
//                startActivity(notificationIntent);

                if(campaignBuilder != null) {
                    if(campaignBuilder.isCloseActivityOnClick()) {
                        finish();
                    } else if(campaignBuilder.isCloseOnlyDeepLink() && !TextUtils.isEmpty(arrayList.get(position).getCustomAttributes().getDeeplink())) {
                        finish();
                    }
                }
            }
        } catch (Exception e) {

        }
    }
}
