package com.hippo.retrofit;


import com.hippo.model.*;
import com.hippo.support.model.HippoSendQueryParams;
import com.hippo.support.model.SupportModelResponse;
import com.hippo.support.model.SupportResponse;

import okhttp3.MultipartBody;
import org.json.JSONObject;

import java.util.Map;

import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.*;

import static com.hippo.constant.FuguAppConstant.APP_SECRET_KEY;
import static com.hippo.constant.FuguAppConstant.APP_VERSION;
import static com.hippo.constant.FuguAppConstant.DEVICE_TYPE;

/**
 * ApiInterface
 */
public interface ApiInterface {

    @FormUrlEncoded
    @POST("/api/users/putUserDetails")
    Call<FuguPutUserDetailsResponse> putUserDetails(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/reseller/putUserDetails")
    Call<FuguPutUserDetailsResponse> putUserDetailsReseller(@FieldMap Map<String, Object> map);

    //@FormUrlEncoded
    @POST("/api/conversation/createConversation")
    Call<FuguCreateConversationResponse> createConversation(@Body FuguCreateConversationParams obj);


    @POST("/api/conversation/getMessages")
    Call<FuguGetMessageResponse> getMessages(@Body FuguGetMessageParams obj);


    @POST("/api/conversation/getByLabelId")
    Call<FuguGetMessageResponse> getByLabelId(@Body FuguGetByLabelIdParams obj);

    //change same as get messages
    @FormUrlEncoded
    @POST("/api/conversation/getConversations")
    Call<FuguGetConversationsResponse> getConversations(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/users/userlogout")
    Call<CommonResponse> logOut(@FieldMap Map<String, Object> map);

    @Multipart
    @POST("/api/conversation/uploadFile")
    Call<FuguUploadImageResponse> uploadFile(@PartMap Map<String, RequestBody> map);

    @Multipart
    @POST("/api/conversation/uploadFile")
    Call<FuguUploadImageResponse> uploadFile(@Header(APP_SECRET_KEY) String appSecretKey, @Header(DEVICE_TYPE) int deviceType, @Header(APP_VERSION) int appVersion, @Part MultipartBody.Part file, @PartMap Map<String, RequestBody> map);


    @FormUrlEncoded
    @POST("/api/server/logException")
    Call<CommonResponse> sendError(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/server/logException")
    Call<CommonResponse> sendAckToServer(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/business/getBusinessSupportPanel")
    Call<SupportResponse> fetchSupportData(@FieldMap Map<String, Object> map);

    @FormUrlEncoded
    @POST("/api/business/getBusinessSupportPanel")
    Call<SupportResponse> sendSupportQuery(@FieldMap Map<String, Object> map);

    @POST("/api/support/createConversation")
    Call<SupportModelResponse> createTicket(@Body HippoSendQueryParams obj);

    @GET("/requestCountryCodeGeoIP2")
    Call<UserInfoModel> getUserInfo();

    @FormUrlEncoded
    @POST("/api/users/inRideStatus")
    Call<CommonResponse> stopRideStatus(@FieldMap Map<String, Object> stringObjectMap);

}
