package com.hippo.agent.model;

import com.hippo.BuildConfig;
import com.hippo.constant.FuguAppConstant;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by gurmail on 19/06/18.
 *
 * @author gurmail
 */

public class FuguAgentGetMessageParams {
    @SerializedName(FuguAppConstant.PAGE_START)
    @Expose
    private Integer pageStart;
    @SerializedName(FuguAppConstant.ACCESS_TOKEN)
    @Expose
    private String appSecretKey;
    @SerializedName(FuguAppConstant.CHANNEL_ID)
    @Expose
    private Integer channelId;
    @SerializedName(FuguAppConstant.EN_USER_ID)
    @Expose
    private String userId;
    @SerializedName(FuguAppConstant.PAGE_END)
    @Expose
    private Integer pageEnd;
    @SerializedName("app_version")
    @Expose
    private int appVersion = BuildConfig.VERSION_CODE;
//    @SerializedName("app_version_code")
//    @Expose
//    private int appVersionCode = BuildConfig.VERSION_CODE;
    @SerializedName("source_type")
    @Expose
    private int source = 2;

    public FuguAgentGetMessageParams(String appSecretKey, Integer channelId, String userId, Integer pageStart){
        this.appSecretKey = appSecretKey;
        this.channelId = channelId;
        this.userId = userId;
        this.pageStart = pageStart;
        appVersion = BuildConfig.VERSION_CODE;
//        appVersionCode = BuildConfig.VERSION_CODE;
        source = 2;
    }

    public void setPageEnd(Integer size) {
        pageEnd = size;
    }
}
