package com.hippo.agent.model;

import android.support.annotation.NonNull;
import com.hippo.constant.FuguAppConstant;

import static com.hippo.constant.FuguAppConstant.ASSIGNMENT_MESSAGE;

public class EventItem extends ListItem implements FuguAppConstant {

    @NonNull
    private Message event;

    public EventItem(@NonNull Message event) {
        this.event = event;
    }

    @NonNull
    public Message getEvent() {
        return event;
    }

    /*case none = 0,
        normal = 1,
        assignAgent = 2,
        privateNote = 3,
        imageFile = 10,
        attachment = 11,
        actionableMessage = 12,
        feedback = 14,
        botText = 15,
        quickReply = 16,
        botFormMessage = 17,
        call = 18,
        hippoPay = 19

        // for agent sdk
        [.normal, .imageFile, .privateNote, .assignAgent, .botText, .call, .attachment]

    */

    @Override
    public int getType() {
        int messageType = event.getMessageType();
        switch (messageType) {
            case ASSIGNMENT_MESSAGE:
                return ITEM_ASSIGNMENT;
            case TEXT_MESSAGE:
            case IMAGE_MESSAGE:
            case PRIVATE_NOTE:
            case ACTION_MESSAGE_NEW:
                if(event.isSelf())
                    return ITEM_TYPE_SELF;
                return ITEM_TYPE_OTHER;
            case HIPPO_FILE_VIEW:
                if(event.isSelf()){
                    if(event.getDocumentType().equalsIgnoreCase(DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_SELF;
                    } else {
                        return HIPPO_SELF_FILE_VIEW;
                    }
                } else {
                    if(event.getDocumentType().equalsIgnoreCase(DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_OTHER;
                    } else {
                        return HIPPO_FILE_VIEW;
                    }
                }
            case FUGU_SELF_VIDEO_VIEW:
                if(event.isSelf())
                    return FUGU_SELF_VIDEO_VIEW;
                return FUGU_OTHER_VIDEO_VIEW;
            case FUGU_TEXT_VIEW:
                return ITEM_TYPE_SELF;
//                if(event.isSelf())
//                    return ITEM_TYPE_SELF;
//                return ITEM_TYPE_OTHER;
            default:
                if(event.isSelf())
                    return HIPPO_UNKNOWN_MESSAGE_SELF;
                return HIPPO_UNKNOWN_MESSAGE_OTHER;
        }

//        if(event.getMessageType() == ASSIGNMENT_MESSAGE)
//            return ITEM_ASSIGNMENT;
//        else if(event.getMessageType() == 18)
//            return 18;
//        else if(event.getMessageType() == 19)
//            return 19;
//        else if (event.isSelf())
//            return ITEM_TYPE_SELF;
//        else if(event.getUserType() == 0 || event.getUserType() == 2)
//            return ITEM_TYPE_SELF;
//        else
//            return ITEM_TYPE_OTHER;
    }
}
